/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.manager.RankRequirementProgressManager;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.ExperienceLevelRequirement;
import com.raindropcentral.rdq.requirement.ItemRequirement;
import com.raindropcentral.rdq.requirement.PlaytimeRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import com.raindropcentral.rdq.view.ranks.RankRequirementsJourneyView;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.heads.view.Return;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.APaginatedView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RankRequirementDetailView
extends APaginatedView<RequirementDetailItem> {
    private static final Logger LOGGER = CentralLogger.getLogger(RankRequirementDetailView.class.getName());
    private final State<RDQ> rdq = this.initialState("plugin");
    private final State<RDQPlayer> currentPlayer = this.initialState("player");
    private final State<RRankTree> selectedRankTree = this.initialState("rankTree");
    private final State<RRank> targetRank = this.initialState("targetRank");
    private final State<RRankUpgradeRequirement> targetRequirement = this.initialState("requirement");
    private final State<Boolean> previewMode = this.initialState("previewMode");
    private RankRequirementProgressManager progressManager;

    public RankRequirementDetailView() {
        super(RankRequirementsJourneyView.class);
    }

    @Override
    protected String getKey() {
        return "rank_requirement_detail_ui";
    }

    @Override
    protected String[] getLayout() {
        return new String[]{"    T    ", " O O O O ", " O O O O ", " O O O O ", " O O O O ", "b  <p>  S"};
    }

    @Override
    protected CompletableFuture<List<RequirementDetailItem>> getAsyncPaginationSource(@NotNull Context context) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                RRankUpgradeRequirement requirement = (RRankUpgradeRequirement)this.targetRequirement.get((StateValueHost)context);
                Player player = context.getPlayer();
                if (requirement == null) {
                    return null;
                }
                ArrayList<RequirementDetailItem> items = new ArrayList<RequirementDetailItem>();
                AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
                if (abstractReq instanceof ItemRequirement) {
                    ItemRequirement itemReq = (ItemRequirement)abstractReq;
                    List<ItemRequirement.ItemProgress> itemProgressList = itemReq.getDetailedProgress(player);
                    for (int i = 0; i < itemProgressList.size(); ++i) {
                        ItemRequirement.ItemProgress itemProgress = itemProgressList.get(i);
                        ItemStack displayItem = this.createItemProgressItem(player, itemProgress, i + 1);
                        items.add(new RequirementDetailItem(displayItem, "Item " + (i + 1), itemProgress, i));
                    }
                } else {
                    ItemStack summaryItem = this.createGenericSummaryItem(player, abstractReq, requirement, context);
                    items.add(new RequirementDetailItem(summaryItem, "Details", RequirementDetailItemType.SUMMARY));
                }
                return items;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error generating pagination source", exception);
                return null;
            }
        });
    }

    @Override
    protected void renderEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull RequirementDetailItem entry) {
        ((BukkitItemComponentBuilder)builder.withItem(entry.getDisplayItem()).updateOnClick()).onClick(clickContext -> this.handleDetailItemClick(context, entry));
    }

    @Override
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext open) {
        try {
            RRankUpgradeRequirement requirement = (RRankUpgradeRequirement)this.targetRequirement.get((StateValueHost)open);
            if (requirement == null) {
                return Map.of("requirement_type", "UNKNOWN");
            }
            return Map.of("requirement_type", this.getRequirementType(requirement), "requirement_name", this.getRequirementName(requirement));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error in getTitlePlaceholders", exception);
            return Map.of("requirement_type", "ERROR");
        }
    }

    @Override
    protected void onPaginatedRender(@NotNull RenderContext render, @NotNull Player player) {
        this.progressManager = new RankRequirementProgressManager((RDQ)this.rdq.get((StateValueHost)render));
        try {
            RRankUpgradeRequirement requirement = (RRankUpgradeRequirement)this.targetRequirement.get((StateValueHost)render);
            if (requirement == null) {
                this.renderErrorState(render, player);
                return;
            }
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)render);
            RankRequirementProgressManager.RequirementProgressData progress = this.progressManager.getRequirementProgress(player, rdqPlayer, requirement);
            AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
            render.layoutSlot('T', this.createRequirementTipsItem(player, abstractReq));
            render.layoutSlot('b', this.createBackButton(player)).onClick(context -> this.navigateBackToJourneyView((Context)context));
            if (abstractReq instanceof ItemRequirement) {
                ItemRequirement itemReq = (ItemRequirement)abstractReq;
                if (progress.isCompleted()) {
                    render.layoutSlot('S', this.createCompletedIndicator(player));
                } else {
                    render.layoutSlot('S', this.createSubmitButton(player, itemReq)).onClick(context -> this.handleSubmitClick((Context)context, requirement, itemReq));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Critical error during requirement detail render", exception);
            this.renderErrorState(render, player);
        }
    }

    private ItemStack createBackButton(@NotNull Player player) {
        try {
            return UnifiedBuilderFactory.item(new Return().getHead(player)).setLore(this.i18n("back.lore", player).build().children()).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create back button", exception);
            return UnifiedBuilderFactory.item(Material.ARROW).setName((Component)Component.text((String)"Back")).build();
        }
    }

    private ItemStack createSubmitButton(@NotNull Player player, @NotNull ItemRequirement itemReq) {
        boolean canSubmit = itemReq.isMet(player);
        Material material = canSubmit ? Material.HOPPER : Material.BARRIER;
        NamedTextColor color = canSubmit ? NamedTextColor.GREEN : NamedTextColor.RED;
        String text = canSubmit ? "Submit Items" : "Missing Items";
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)Component.empty());
        if (canSubmit) {
            lore.add(Component.text((String)"Click to submit all items").color((TextColor)NamedTextColor.GRAY));
            lore.add(Component.text((String)"Items will be consumed").color((TextColor)NamedTextColor.YELLOW));
        } else {
            lore.add(Component.text((String)"Collect all required items first").color((TextColor)NamedTextColor.GRAY));
        }
        return UnifiedBuilderFactory.item(material).setName(Component.text((String)text).color((TextColor)color)).setLore(lore).setGlowing(canSubmit).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private ItemStack createCompletedIndicator(@NotNull Player player) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)Component.empty());
        lore.add(Component.text((String)"This requirement has been completed").color((TextColor)NamedTextColor.GRAY));
        lore.add(Component.text((String)"Click back to return").color((TextColor)NamedTextColor.YELLOW));
        return UnifiedBuilderFactory.item(Material.LIME_CONCRETE).setName(Component.text((String)"\u2713 Completed").color((TextColor)NamedTextColor.GREEN)).setLore(lore).setGlowing(true).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void handleSubmitClick(@NotNull Context context, @NotNull RRankUpgradeRequirement requirement, @NotNull ItemRequirement itemReq) {
        RDQPlayer rdqPlayer;
        Player player = context.getPlayer();
        RankRequirementProgressManager.RequirementProgressData currentProgress = this.progressManager.getRequirementProgress(player, rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)context), requirement);
        if (currentProgress.isCompleted()) {
            this.i18n("submit.already_completed", player).includePrefix().build().sendMessage();
            this.navigateBackToJourneyView(context);
            return;
        }
        if (!itemReq.isMet(player)) {
            this.i18n("submit.missing_items", player).includePrefix().build().sendMessage();
            return;
        }
        try {
            RankRequirementProgressManager.RequirementCompletionResult result = this.progressManager.attemptRequirementCompletion(player, rdqPlayer, requirement);
            if (result.isSuccess()) {
                this.i18n("submit.success", player).includePrefix().build().sendMessage();
                this.navigateBackToJourneyView(context);
            } else if (result.getUpdatedProgress().isCompleted()) {
                this.i18n("submit.already_completed", player).includePrefix().build().sendMessage();
                this.navigateBackToJourneyView(context);
            } else {
                this.i18n("submit.failed", player).includePrefix().build().sendMessage();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to submit items", exception);
            this.i18n("submit.error", player).includePrefix().build().sendMessage();
        }
    }

    private void navigateBackToJourneyView(@NotNull Context context) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("plugin", this.rdq.get((StateValueHost)context));
            data.put("player", this.currentPlayer.get((StateValueHost)context));
            data.put("rankTree", this.selectedRankTree.get((StateValueHost)context));
            data.put("targetRank", this.targetRank.get((StateValueHost)context));
            data.put("previewMode", this.previewMode.get((StateValueHost)context));
            context.openForPlayer(RankRequirementsJourneyView.class, data);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to navigate back to journey view, using fallback", exception);
            context.back();
        }
    }

    private ItemStack createItemProgressItem(@NotNull Player player, @NotNull ItemRequirement.ItemProgress itemProgress, int itemNumber) {
        try {
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add((Component)Component.empty());
            lore.add(this.createProgressBar(itemProgress.progress(), 12));
            lore.add((Component)Component.empty());
            lore.add(((TextComponent)Component.text((String)"Have: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)itemProgress.currentAmount()).color((TextColor)(itemProgress.completed() ? NamedTextColor.GREEN : NamedTextColor.WHITE))));
            lore.add(((TextComponent)Component.text((String)"Need: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)itemProgress.requiredAmount()).color((TextColor)NamedTextColor.YELLOW)));
            lore.add((Component)Component.empty());
            if (itemProgress.completed()) {
                lore.add(Component.text((String)"\u2713 Collected").color((TextColor)NamedTextColor.GREEN));
            } else {
                lore.add(Component.text((String)("Missing: " + itemProgress.getShortage())).color((TextColor)NamedTextColor.RED));
            }
            return UnifiedBuilderFactory.item(itemProgress.requiredItem()).setLore(lore).setAmount(Math.max(1, Math.min(64, itemProgress.requiredAmount()))).setGlowing(itemProgress.completed()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create item progress item", exception);
            return this.createFallbackItem(player, "Item " + itemNumber + " (Error)");
        }
    }

    private ItemStack createItemRequirementTips(@NotNull Player player, @NotNull ItemRequirement itemReq) {
        return UnifiedBuilderFactory.item(Material.KNOWLEDGE_BOOK).setLore(this.i18n("item_requirement.tip", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private Component createProgressBar(double progress, int length) {
        int filled = (int)(progress * (double)length);
        return ((TextComponent)Component.text((String)"").append(MiniMessage.miniMessage().deserialize((Object)"<green>\u2588</green>".repeat(Math.max(0, filled))))).append(MiniMessage.miniMessage().deserialize((Object)"<gray>\u2588</gray>".repeat(Math.max(0, length - filled))));
    }

    private ItemStack createGenericSummaryItem(@NotNull Player player, @NotNull AbstractRequirement abstractReq, @NotNull RRankUpgradeRequirement requirement, @NotNull Context context) {
        Material iconMaterial = switch (abstractReq.getType()) {
            case Requirement.Type.CURRENCY -> Material.GOLD_INGOT;
            case Requirement.Type.EXPERIENCE_LEVEL -> Material.EXPERIENCE_BOTTLE;
            case Requirement.Type.PLAYTIME -> Material.CLOCK;
            case Requirement.Type.PERMISSION -> Material.PAPER;
            case Requirement.Type.LOCATION -> Material.COMPASS;
            default -> Material.BOOK;
        };
        RankRequirementProgressManager.RequirementProgressData progress = this.progressManager.getRequirementProgress(player, (RDQPlayer)this.currentPlayer.get((StateValueHost)context), requirement);
        ArrayList<Component> lore = new ArrayList<Component>();
        if (abstractReq instanceof ExperienceLevelRequirement) {
            ExperienceLevelRequirement expReq = (ExperienceLevelRequirement)abstractReq;
            int currentLevel = expReq.getCurrentExperience(player);
            int requiredLevel = expReq.getRequiredLevel();
            int levelsNeeded = expReq.getShortage(player);
            lore.add((Component)Component.empty());
            lore.add((Component)this.i18n("experience.current_level", player).withPlaceholder("current", currentLevel).build().component());
            lore.add((Component)this.i18n("experience.required_level", player).withPlaceholder("required", requiredLevel).build().component());
            if (levelsNeeded > 0) {
                lore.add((Component)this.i18n("experience.levels_needed", player).withPlaceholder("needed", levelsNeeded).build().component());
            } else {
                lore.add((Component)this.i18n("experience.completed", player).build().component());
            }
            lore.add((Component)Component.empty());
            lore.add(this.createProgressBar(progress.getProgressPercentage(), 15));
            lore.add(Component.text((String)(progress.getProgressAsPercentage() + "% Complete")).color((TextColor)(progress.isCompleted() ? NamedTextColor.GREEN : NamedTextColor.YELLOW)));
        } else if (abstractReq instanceof PlaytimeRequirement) {
            PlaytimeRequirement playReq = (PlaytimeRequirement)abstractReq;
            long currentSeconds = playReq.getTotalPlaytimeSeconds(player);
            long requiredSeconds = playReq.getRequiredPlaytimeSeconds();
            long remainingSeconds = Math.max(0L, requiredSeconds - currentSeconds);
            long currentHours = currentSeconds / 3600L;
            long currentMinutes = currentSeconds % 3600L / 60L;
            long requiredHours = requiredSeconds / 3600L;
            long requiredMinutes = requiredSeconds % 3600L / 60L;
            long remainingHours = remainingSeconds / 3600L;
            long remainingMinutes = remainingSeconds % 3600L / 60L;
            lore.add((Component)Component.empty());
            lore.add((Component)this.i18n("playtime.current", player).withPlaceholder("hours", currentHours).withPlaceholder("minutes", currentMinutes).build().component());
            lore.add((Component)this.i18n("playtime.required", player).withPlaceholder("hours", requiredHours).withPlaceholder("minutes", requiredMinutes).build().component());
            if (remainingSeconds > 0L) {
                lore.add((Component)this.i18n("playtime.remaining", player).withPlaceholder("hours", remainingHours).withPlaceholder("minutes", remainingMinutes).build().component());
            } else {
                lore.add((Component)this.i18n("playtime.completed", player).build().component());
            }
            lore.add((Component)Component.empty());
            lore.add(this.createProgressBar(progress.getProgressPercentage(), 15));
            lore.add(Component.text((String)(progress.getProgressAsPercentage() + "% Complete")).color((TextColor)(progress.isCompleted() ? NamedTextColor.GREEN : NamedTextColor.YELLOW)));
        } else {
            lore.add((Component)this.i18n("summary.requirement_type", player).withPlaceholder("type", (Object)abstractReq.getType()).build().component());
            lore.add((Component)Component.empty());
            lore.add(this.createProgressBar(progress.getProgressPercentage(), 15));
            lore.add((Component)this.i18n("summary.progress_percentage", player).withPlaceholder("completion_progress_percentage", progress.getProgressAsPercentage() + "%").build().component());
            lore.add((Component)Component.empty());
            lore.add((Component)this.i18n("summary.completion_status", player).withPlaceholder("completion_status", progress.getStatus().name()).build().component());
        }
        return UnifiedBuilderFactory.item(iconMaterial).setName((Component)this.i18n("summary.requirement_summary.name", player).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_STORED_ENCHANTS).setGlowing(progress.isCompleted()).build();
    }

    private ItemStack createRequirementTipsItem(@NotNull Player player, @NotNull AbstractRequirement abstractReq) {
        ArrayList<Component> lore = new ArrayList<Component>();
        switch (abstractReq.getType()) {
            case CURRENCY: {
                lore.addAll(this.i18n("requirement_tip.currency", player).build().children());
                break;
            }
            case EXPERIENCE_LEVEL: {
                lore.addAll(this.i18n("requirement_tip.experience_level", player).build().children());
                break;
            }
            case PLAYTIME: {
                lore.addAll(this.i18n("requirement_tip.playtime", player).build().children());
                break;
            }
            default: {
                lore.addAll(this.i18n("requirement_tip.other", player).build().children());
            }
        }
        return UnifiedBuilderFactory.item(Material.KNOWLEDGE_BOOK).setName((Component)this.i18n("summary.requirement_tip.name", player).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_STORED_ENCHANTS).build();
    }

    private void handleDetailItemClick(@NotNull Context context, @NotNull RequirementDetailItem detailItem) {
        Player player = context.getPlayer();
        try {
            switch (detailItem.getType().ordinal()) {
                case 0: {
                    if (detailItem.getItemProgress() == null) break;
                    this.handleItemProgressClick(context, detailItem.getItemProgress());
                    break;
                }
                case 1: {
                    this.i18n("summary_clicked", player).includePrefix().build().sendMessage();
                    break;
                }
                case 2: {
                    this.i18n("tips_clicked", player).includePrefix().build().sendMessage();
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to handle detail item click", e);
        }
    }

    private void handleItemProgressClick(@NotNull Context context, @NotNull ItemRequirement.ItemProgress itemProgress) {
        context.update();
    }

    private ItemStack createRequirementInfoItem(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        try {
            ItemRequirement itemReq;
            List<ItemStack> missingItems;
            Material iconMaterial = Material.valueOf((String)requirement.getIcon().getMaterial());
            ArrayList<Component> lore = new ArrayList<Component>(List.of((Component)this.i18n("requirement_info.requirement_type", player).withPlaceholder("type", requirement.getRequirement().getRequirement().getType().name()).build().component(), Component.empty(), this.createProgressBar(progress.getProgressPercentage() / 100.0, 20), (Component)this.i18n("requirement_info.progress_percentage", player).withPlaceholder("completion_progress_percentage", progress.getProgressAsPercentage() + "%").build().component(), Component.empty(), (Component)this.i18n("requirement_info.completion_status", player).withPlaceholder("completion_status", progress.getStatus().name()).build().component()));
            AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
            if (abstractReq instanceof ItemRequirement && !(missingItems = (itemReq = (ItemRequirement)abstractReq).getMissingItems(player)).isEmpty()) {
                lore.addAll(List.of(Component.empty(), (TextComponent)this.i18n("requirement_info.missing_items.item", player).build().component()));
                int itemCount = Math.min(3, missingItems.size());
                for (int i = 0; i < itemCount; ++i) {
                    ItemStack missingItem = missingItems.get(i);
                    String itemInfo = "\u2022 " + missingItem.getAmount() + "x " + missingItem.getType().name();
                    lore.add((Component)this.i18n("requirement_info.missing_items.entry", player).withPlaceholder("item_info", itemInfo).build().component());
                }
                if (missingItems.size() > 3) {
                    lore.add((Component)this.i18n("requirement_info.missing_items.more", player).withPlaceholder("item_amount", missingItems.size() - 3).build().component());
                }
            }
            lore.addAll(List.of(Component.empty(), (TextComponent)this.i18n("requirement_info.detailed_information", player).build().component()));
            return UnifiedBuilderFactory.item(iconMaterial).setName((Component)this.i18n("requirement_info.name", player).withPlaceholder("requirement_name", this.getRequirementName(requirement)).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setGlowing(progress.isCompleted()).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create requirement info item", exception);
            return this.createFallbackItem(player, "Requirement Info");
        }
    }

    private ItemStack createStatusItem(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        Material statusMaterial = switch (progress.getStatus()) {
            default -> throw new MatchException(null, null);
            case RankRequirementProgressManager.RequirementStatus.COMPLETED -> Material.EMERALD_BLOCK;
            case RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE -> Material.GOLD_BLOCK;
            case RankRequirementProgressManager.RequirementStatus.IN_PROGRESS -> Material.IRON_BLOCK;
            case RankRequirementProgressManager.RequirementStatus.NOT_STARTED -> Material.REDSTONE_BLOCK;
            case RankRequirementProgressManager.RequirementStatus.ERROR -> Material.BARRIER;
        };
        ArrayList<Component> lore = new ArrayList<Component>();
        switch (progress.getStatus()) {
            case COMPLETED: {
                lore.addAll(this.i18n("requirement.completed", player).build().children());
                break;
            }
            case READY_TO_COMPLETE: {
                lore.addAll(this.i18n("requirement.ready_to_complete", player).build().children());
                break;
            }
            case IN_PROGRESS: {
                lore.addAll(this.i18n("requirement.in_progress", player).build().children());
                break;
            }
            case NOT_STARTED: {
                lore.addAll(this.i18n("requirement.not_started", player).build().children());
                break;
            }
            case ERROR: {
                lore.addAll(this.i18n("requirement.error", player).build().children());
            }
        }
        return UnifiedBuilderFactory.item(statusMaterial).setName((Component)this.i18n("requirement.status_name", player).withPlaceholder("requirement_status", progress.getStatus().name()).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setGlowing(progress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE).build();
    }

    private NamedTextColor getStatusColor(RankRequirementProgressManager.RequirementStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case RankRequirementProgressManager.RequirementStatus.COMPLETED -> NamedTextColor.GREEN;
            case RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE -> NamedTextColor.GOLD;
            case RankRequirementProgressManager.RequirementStatus.IN_PROGRESS -> NamedTextColor.YELLOW;
            case RankRequirementProgressManager.RequirementStatus.NOT_STARTED -> NamedTextColor.RED;
            case RankRequirementProgressManager.RequirementStatus.ERROR -> NamedTextColor.DARK_RED;
        };
    }

    private ItemStack createProgressItem(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        try {
            Material progressMaterial = switch (progress.getStatus()) {
                default -> throw new MatchException(null, null);
                case RankRequirementProgressManager.RequirementStatus.COMPLETED -> Material.LIME_CONCRETE;
                case RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE -> Material.YELLOW_CONCRETE;
                case RankRequirementProgressManager.RequirementStatus.IN_PROGRESS -> Material.ORANGE_CONCRETE;
                case RankRequirementProgressManager.RequirementStatus.NOT_STARTED -> Material.RED_CONCRETE;
                case RankRequirementProgressManager.RequirementStatus.ERROR -> Material.GRAY_CONCRETE;
            };
            ArrayList<Component> lore = new ArrayList<Component>(List.of(Component.empty(), (Component)this.i18n("progress_item", player).build().component(), this.createProgressBar(progress.getProgressPercentage() / 100.0, 15), (Component)this.i18n("progress_item_completion", player).withPlaceholder("progress_item_percentage", progress.getProgressAsPercentage()).build().component(), Component.empty(), (Component)this.i18n("progress_item_status", player).withPlaceholder("progress_item_status", progress.getStatus().name()).build().component(), Component.empty(), (Component)this.i18n("progress_click_to_refresh", player).build().component()));
            return UnifiedBuilderFactory.item(progressMaterial).setName((Component)this.i18n("progress_overview", player).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setGlowing(progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create progress item", exception);
            return this.createFallbackItem(player, "Progress Unknown");
        }
    }

    private ItemStack createActionButton(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        try {
            String loreKey;
            String nameKey;
            Material buttonMaterial;
            boolean isCompleted;
            boolean canComplete = progress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE;
            boolean bl = isCompleted = progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED;
            if (isCompleted) {
                buttonMaterial = Material.EMERALD_BLOCK;
                nameKey = "action_button.completed_name";
                loreKey = "action_button.completed_lore";
            } else if (canComplete) {
                buttonMaterial = Material.EMERALD;
                nameKey = "action_button.complete_name";
                loreKey = "action_button.complete_lore";
            } else {
                buttonMaterial = Material.DIAMOND;
                nameKey = "action_button.refresh_name";
                loreKey = "action_button.refresh_lore";
            }
            return UnifiedBuilderFactory.item(buttonMaterial).setName((Component)this.i18n(nameKey, player).build().component()).setLore(this.i18n(loreKey, player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setGlowing(canComplete).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create action button", exception);
            return this.createFallbackItem(player, "Action (Error)");
        }
    }

    private void handleInfoClick(@NotNull Context context) {
        context.update();
    }

    private void handleProgressClick(@NotNull Context context, @NotNull RRankUpgradeRequirement requirement) {
        context.update();
    }

    private void handleStatusClick(@NotNull Context context, @NotNull RRankUpgradeRequirement requirement) {
        Player player = context.getPlayer();
        RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)context);
        try {
            this.progressManager.refreshRequirementProgress(player, rdqPlayer, requirement);
            context.update();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh requirement progress", exception);
        }
    }

    private void handleActionClick(@NotNull Context context, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData currentProgress) {
        Player player = context.getPlayer();
        RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)context);
        try {
            if (currentProgress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED) {
                this.i18n("already_completed", player).withPlaceholder("requirement_name", this.getRequirementName(requirement)).includePrefix().build().sendMessage();
                return;
            }
            if (currentProgress.getStatus() == RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE) {
                RankRequirementProgressManager.RequirementCompletionResult result = this.progressManager.attemptRequirementCompletion(player, rdqPlayer, requirement);
                if (result.isSuccess()) {
                    context.update();
                }
            } else {
                this.progressManager.refreshRankProgress(player, rdqPlayer, requirement.getRank());
                this.i18n("progress_refreshed", player).includePrefix().build().sendMessage();
                context.update();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle action click", exception);
            this.i18n("action_error", player).includePrefix().build().sendMessage();
        }
    }

    private String getRequirementType(@NotNull RRankUpgradeRequirement requirement) {
        try {
            return requirement.getRequirement().getRequirement().getType().name();
        }
        catch (Exception exception) {
            return "UNKNOWN";
        }
    }

    private String getRequirementName(@NotNull RRankUpgradeRequirement requirement) {
        try {
            return requirement.getRequirement().getRequirement().getType().name();
        }
        catch (Exception exception) {
            return "Unknown Requirement";
        }
    }

    private String getRequirementDescription(@NotNull RRankUpgradeRequirement requirement) {
        try {
            return requirement.getRequirement().getRequirement().getDescriptionKey();
        }
        catch (Exception exception) {
            return "A requirement for rank progression";
        }
    }

    private ItemStack createFallbackItem(@NotNull Player player, @NotNull String name) {
        return UnifiedBuilderFactory.item(Material.PAPER).setName((Component)this.i18n("fallback.name", player).build().component()).setLore(this.i18n("fallback.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void renderErrorState(@NotNull RenderContext render, @NotNull Player player) {
        try {
            render.slot(22, UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("error.name", player).build().component()).setLore(this.i18n("error.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build());
            LOGGER.log(Level.WARNING, "Rendering error state for requirement detail view");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render error state", exception);
        }
    }

    public static class RequirementDetailItem {
        private final ItemStack displayItem;
        private final String itemName;
        private final ItemRequirement.ItemProgress itemProgress;
        private final int itemIndex;
        private final RequirementDetailItemType type;

        public RequirementDetailItem(@NotNull ItemStack displayItem, @NotNull String itemName, @NotNull ItemRequirement.ItemProgress itemProgress, int itemIndex) {
            this.displayItem = displayItem;
            this.itemName = itemName;
            this.itemProgress = itemProgress;
            this.itemIndex = itemIndex;
            this.type = RequirementDetailItemType.ITEM_PROGRESS;
        }

        public RequirementDetailItem(@NotNull ItemStack displayItem, @NotNull String itemName, @NotNull RequirementDetailItemType type) {
            this.displayItem = displayItem;
            this.itemName = itemName;
            this.itemProgress = null;
            this.itemIndex = -1;
            this.type = type;
        }

        public ItemStack getDisplayItem() {
            return this.displayItem;
        }

        public String getItemName() {
            return this.itemName;
        }

        public ItemRequirement.ItemProgress getItemProgress() {
            return this.itemProgress;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public RequirementDetailItemType getType() {
            return this.type;
        }
    }

    public static enum RequirementDetailItemType {
        ITEM_PROGRESS,
        SUMMARY,
        TIPS,
        FILLER;

    }
}

