/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.manager.RankRequirementProgressManager;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.ItemRequirement;
import com.raindropcentral.rdq.view.ranks.RankPathOverview;
import com.raindropcentral.rdq.view.ranks.RankRequirementDetailView;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.APaginatedView;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.CloseContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RankPathRankRequirementOverview
extends APaginatedView<RRankUpgradeRequirement> {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final State<RDQPlayer> currentPlayer = this.initialState("player");
    private final State<RRank> targetRank = this.initialState("targetRank");
    private final State<RRankTree> selectedRankTree = this.initialState("rankTree");
    private final State<Boolean> previewMode = this.initialState("previewMode");
    private RankRequirementProgressManager progressManager;

    public RankPathRankRequirementOverview() {
        super(RankPathOverview.class);
    }

    @Override
    protected String getKey() {
        return "rank_requirements_overview_ui";
    }

    @Override
    @NotNull
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext openContext) {
        RRank rank = (RRank)this.targetRank.get((StateValueHost)openContext);
        return Map.of("rank_name", rank.getIdentifier(), "requirement_count", rank.getUpgradeRequirements().size());
    }

    @Override
    protected CompletableFuture<List<RRankUpgradeRequirement>> getAsyncPaginationSource(@NotNull Context context) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                RRankTree cachedTree;
                RRank passedRank = (RRank)this.targetRank.get((StateValueHost)context);
                if (passedRank == null) {
                    LOGGER.log(Level.WARNING, "Target rank is null, returning empty requirements list");
                    return new ArrayList();
                }
                RDQ plugin = (RDQ)this.rdq.get((StateValueHost)context);
                if (this.progressManager == null) {
                    this.progressManager = new RankRequirementProgressManager(plugin);
                }
                RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)context);
                RRank cachedRank = null;
                if (rankTree != null && (cachedTree = plugin.getRankSystemFactory().getRankTrees().get(rankTree.getIdentifier())) != null) {
                    cachedRank = cachedTree.getRanks().stream().filter(r -> r.getIdentifier().equals(passedRank.getIdentifier())).findFirst().orElse(null);
                }
                RRank rank = cachedRank != null ? cachedRank : passedRank;
                ArrayList<RRankUpgradeRequirement> requirements = new ArrayList<RRankUpgradeRequirement>(rank.getUpgradeRequirements());
                requirements.sort(Comparator.comparingInt(RRankUpgradeRequirement::getDisplayOrder));
                LOGGER.log(Level.INFO, "Loaded " + requirements.size() + " requirements for rank: " + rank.getIdentifier());
                return requirements;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to load rank upgrade requirements", exception);
                return new ArrayList();
            }
        });
    }

    @Override
    protected void renderEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull RRankUpgradeRequirement requirement) {
        try {
            Player player = context.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)context);
            boolean isPreviewMode = (Boolean)this.previewMode.get((StateValueHost)context);
            RankRequirementProgressManager.RequirementProgressData progress = this.progressManager.getRequirementProgress(player, rdqPlayer, requirement);
            ItemStack displayItem = this.createRequirementDisplayItem(player, requirement, progress, index, isPreviewMode);
            builder.renderWith(() -> displayItem).onClick(clickContext -> this.handleRequirementClick((SlotClickContext)clickContext, requirement, progress, isPreviewMode));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render requirement entry at index " + index, exception);
            this.renderFallbackRequirementEntry(context, builder, index, requirement);
        }
    }

    @Override
    protected void onPaginatedRender(@NotNull RenderContext render, @NotNull Player player) {
        try {
            RRankTree cachedTree;
            RRank passedRank = (RRank)this.targetRank.get((StateValueHost)render);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)render);
            if (passedRank == null) {
                LOGGER.log(Level.WARNING, "Target rank is null during first render");
                this.renderErrorState(render, player);
                return;
            }
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)render);
            if (this.progressManager == null) {
                this.progressManager = new RankRequirementProgressManager(plugin);
            }
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)render);
            RRank cachedRank = null;
            if (rankTree != null && (cachedTree = plugin.getRankSystemFactory().getRankTrees().get(rankTree.getIdentifier())) != null) {
                cachedRank = cachedTree.getRanks().stream().filter(r -> r.getIdentifier().equals(passedRank.getIdentifier())).findFirst().orElse(null);
            }
            RRank rank = cachedRank != null ? cachedRank : passedRank;
            this.progressManager.initializeRankProgressTracking(rdqPlayer, rank);
            this.renderAdditionalInfo(render, player, rank, rdqPlayer);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Critical error during requirements overview render", exception);
            this.renderErrorState(render, player);
        }
    }

    @Override
    public void onResume(Context origin, Context target) {
        try {
            LOGGER.log(Level.FINE, "RankPathRankRequirementOverview resumed, refreshing requirement progress");
            Player player = target.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)target);
            RRank rank = (RRank)this.targetRank.get((StateValueHost)target);
            if (this.progressManager != null) {
                this.progressManager.refreshRankProgress(player, rdqPlayer, rank);
            }
            target.update();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh on resume", exception);
        }
    }

    public void onClick(@NotNull SlotClickContext click) {
        try {
            LOGGER.log(Level.FINE, "RankPathRankRequirementOverview closing, ensuring progress is saved");
            if (this.progressManager != null) {
                this.progressManager.cleaRDQPlayerCache(click.getPlayer());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle view close", exception);
        }
    }

    @NotNull
    private ItemStack createRequirementDisplayItem(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress, int index, boolean isPreviewMode) {
        try {
            Material iconMaterial = Material.valueOf((String)requirement.getIcon().getMaterial());
            Component displayName = this.createRequirementDisplayName(player, requirement, index, progress, isPreviewMode);
            List<Component> lore = this.createRequirementLore(player, requirement, progress, isPreviewMode);
            ItemStack finalItem = UnifiedBuilderFactory.item(iconMaterial).setName(displayName).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            if (progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED) {
                finalItem = UnifiedBuilderFactory.item(finalItem).setGlowing(true).build();
            }
            return finalItem;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create requirement display item", exception);
            return this.createFallbackRequirementItem(player, requirement, index);
        }
    }

    @NotNull
    private Component createRequirementDisplayName(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, int index, @NotNull RankRequirementProgressManager.RequirementProgressData progress, boolean isPreviewMode) {
        try {
            String statusKey = switch (progress.getStatus()) {
                default -> throw new MatchException(null, null);
                case RankRequirementProgressManager.RequirementStatus.COMPLETED -> "requirement.status.completed";
                case RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE -> "requirement.status.ready_to_complete";
                case RankRequirementProgressManager.RequirementStatus.IN_PROGRESS -> "requirement.status.in_progress";
                case RankRequirementProgressManager.RequirementStatus.NOT_STARTED -> "requirement.status.not_started";
                case RankRequirementProgressManager.RequirementStatus.ERROR -> "requirement.status.error";
            };
            String requirementName = this.getRequirementName(requirement);
            int itemCount = this.getRequirementItemCount(requirement);
            I18n.Builder i18n = this.i18n(statusKey, player).withPlaceholder("index", index + 1).withPlaceholder("requirement_name", requirementName).withPlaceholder("item_count", itemCount).withPlaceholder("progress", progress.getFormattedProgress());
            if (isPreviewMode) {
                i18n.withPlaceholder("preview_prefix", "[PREVIEW] ");
            }
            return (Component)i18n.build().component();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create requirement display name", exception);
            return (Component)this.i18n("requirement.fallback", player).withPlaceholder("index", index + 1).build().component();
        }
    }

    @NotNull
    private List<Component> createRequirementLore(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress, boolean isPreviewMode) {
        ArrayList<Component> lore = new ArrayList<Component>();
        try {
            String description = this.getRequirementDescription(requirement);
            int itemCount = this.getRequirementItemCount(requirement);
            lore.add((Component)this.i18n("requirement.type", player).withPlaceholder("type", progress.getRequirementType()).build().component());
            lore.add((Component)this.i18n("requirement.lore", player).withPlaceholder("description", description).build().component());
            if (itemCount > 1) {
                lore.add((Component)this.i18n("requirement.item_count", player).withPlaceholder("count", itemCount).build().component());
            }
            lore.add((Component)Component.empty());
            lore.add((Component)this.i18n("requirement.progress", player).withPlaceholder("progress", progress.getProgressAsPercentage()).build().component());
            String statusInfoKey = switch (progress.getStatus()) {
                default -> throw new MatchException(null, null);
                case RankRequirementProgressManager.RequirementStatus.COMPLETED -> "requirement.info.completed";
                case RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE -> "requirement.info.ready_to_complete";
                case RankRequirementProgressManager.RequirementStatus.IN_PROGRESS -> "requirement.info.in_progress";
                case RankRequirementProgressManager.RequirementStatus.NOT_STARTED -> "requirement.info.not_started";
                case RankRequirementProgressManager.RequirementStatus.ERROR -> "requirement.info.error";
            };
            lore.add((Component)this.i18n(statusInfoKey, player).build().component());
            lore.add((Component)Component.empty());
            if (isPreviewMode) {
                lore.add((Component)this.i18n("requirement.preview_mode", player).build().component());
            } else {
                switch (progress.getStatus()) {
                    case READY_TO_COMPLETE: {
                        lore.add((Component)this.i18n("requirement.click.complete", player).build().component());
                        lore.add((Component)this.i18n("requirement.click.details", player).build().component());
                        break;
                    }
                    case COMPLETED: {
                        lore.add((Component)this.i18n("requirement.click.already_completed", player).build().component());
                        break;
                    }
                    default: {
                        lore.add((Component)this.i18n("requirement.click.for_details", player).build().component());
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create requirement lore", exception);
            lore.add((Component)this.i18n("requirement.lore_error", player).build().component());
        }
        return lore;
    }

    private void handleRequirementClick(@NotNull SlotClickContext clickContext, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress, boolean isPreviewMode) {
        Player player = clickContext.getPlayer();
        ClickType clickType = clickContext.getClickOrigin().getClick();
        try {
            if (isPreviewMode) {
                this.i18n("messages.preview_mode_click", player).withPlaceholder("requirement_name", this.getRequirementName(requirement)).includePrefix().build().sendMessage();
                return;
            }
            if (clickType == ClickType.LEFT) {
                this.handleLeftClick(clickContext, requirement, progress);
            } else if (clickType == ClickType.RIGHT) {
                this.handleRightClick(clickContext, requirement, progress);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle requirement click", exception);
            this.i18n("error.click_failed", player).includePrefix().build().sendMessage();
        }
    }

    private void handleLeftClick(@NotNull SlotClickContext clickContext, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        Player player = clickContext.getPlayer();
        RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
        if (progress.getStatus() == RankRequirementProgressManager.RequirementStatus.COMPLETED) {
            this.i18n("messages.already_completed", player).withPlaceholder("requirement_name", this.getRequirementName(requirement)).includePrefix().build().sendMessage();
            return;
        }
        if (progress.getStatus() != RankRequirementProgressManager.RequirementStatus.READY_TO_COMPLETE) {
            this.i18n("messages.not_ready_to_complete", player).withPlaceholder("requirement_name", this.getRequirementName(requirement)).includePrefix().build().sendMessage();
            return;
        }
        RankRequirementProgressManager.RequirementCompletionResult result = this.progressManager.attemptRequirementCompletion(player, rdqPlayer, requirement);
        if (result.isSuccess()) {
            RRankTree cachedTree;
            clickContext.update();
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)clickContext);
            RRank passedRank = (RRank)this.targetRank.get((StateValueHost)clickContext);
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)clickContext);
            RRank rank = passedRank;
            if (rankTree != null && passedRank != null && (cachedTree = plugin.getRankSystemFactory().getRankTrees().get(rankTree.getIdentifier())) != null) {
                rank = cachedTree.getRanks().stream().filter(r -> r.getIdentifier().equals(passedRank.getIdentifier())).findFirst().orElse(passedRank);
            }
            if (this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank)) {
                LOGGER.log(Level.INFO, "All requirements completed for rank " + rank.getIdentifier() + " by player " + player.getName() + ". Starting rank progression.");
                this.processRankProgression(clickContext, rank, rdqPlayer, player);
            }
        }
    }

    private void processRankProgression(@NotNull SlotClickContext clickContext, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer, @NotNull Player player) {
        try {
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)clickContext);
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)clickContext);
            this.updatePlayerRankInDatabase(plugin, rdqPlayer, rankTree, rank);
            this.updateLuckPermsGroup(plugin, player, rank);
            this.i18n("messages.rank_progression_completed", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
            HashMap<String, Object> updatedData = new HashMap<String, Object>((Map)clickContext.getInitialData());
            updatedData.put("rank_progression_completed", true);
            updatedData.put("completed_rank", rank);
            updatedData.put("new_rank_id", rank.getIdentifier());
            this.scheduleReturnToParent(clickContext, updatedData, 2000L);
            LOGGER.log(Level.INFO, "Successfully completed rank progression for player " + player.getName() + " to rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to process rank progression", exception);
            this.i18n("error.rank_progression_failed", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
    }

    private void updatePlayerRankInDatabase(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull RRank newRank) {
        try {
            List playerRanks = plugin.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId()));
            RPlayerRank existingRank = playerRanks.stream().filter(rank -> Objects.equals(rank.getRankTree(), rankTree)).findFirst().orElse(null);
            if (existingRank != null) {
                existingRank.setCurrentRank(newRank);
                plugin.getPlayerRankRepository().update(existingRank);
                LOGGER.log(Level.INFO, "Updated existing rank for player " + rdqPlayer.getPlayerName() + " to " + newRank.getIdentifier());
            } else {
                RPlayerRank newPlayerRank = new RPlayerRank(rdqPlayer, newRank, rankTree);
                plugin.getPlayerRankRepository().create(newPlayerRank);
                LOGGER.log(Level.INFO, "Created new rank entry for player " + rdqPlayer.getPlayerName() + " with rank " + newRank.getIdentifier());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to update player rank in database", exception);
            throw new RuntimeException("Database rank update failed", exception);
        }
    }

    private void updateLuckPermsGroup(@NotNull RDQ plugin, @NotNull Player player, @NotNull RRank rank) {
        try {
            String luckPermsGroup;
            if (plugin.getLuckPermsService() != null && (luckPermsGroup = rank.getAssignedLuckPermsGroup()) != null && !luckPermsGroup.isEmpty()) {
                LOGGER.log(Level.INFO, "Updated LuckPerms group for " + player.getName() + " to " + luckPermsGroup);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to update LuckPerms group", exception);
        }
    }

    private void scheduleReturnToParent(@NotNull SlotClickContext clickContext, @NotNull Map<String, Object> updatedData, long delayMs) {
        RDQ rdq = (RDQ)this.rdq.get((StateValueHost)clickContext);
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)rdq.getPlugin(), () -> {
            try {
                clickContext.openForPlayer(RankPathOverview.class, (Object)updatedData);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Failed to return to parent view", exception);
                clickContext.getPlayer().closeInventory();
            }
        }, delayMs / 50L);
    }

    public void onClose(@NotNull CloseContext close) {
        try {
            LOGGER.log(Level.FINE, "RankPathRankRequirementOverview closing, ensuring progress is saved");
            if (this.progressManager != null) {
                this.progressManager.cleaRDQPlayerCache(close.getPlayer());
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.putAll((Map)close.getInitialData());
            map.put("view_closed_with_updates", true);
            close.setInitialData(map);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle view close", exception);
        }
    }

    private void handleRightClick(@NotNull SlotClickContext clickContext, @NotNull RRankUpgradeRequirement requirement, @NotNull RankRequirementProgressManager.RequirementProgressData progress) {
        Player player = clickContext.getPlayer();
        try {
            HashMap<String, Object> initialData = new HashMap<String, Object>((Map)clickContext.getInitialData());
            initialData.put("requirement", requirement);
            initialData.put("progress", progress);
            LOGGER.log(Level.INFO, "Player " + player.getName() + " opening detailed view for requirement: " + this.getRequirementName(requirement) + " - Initial data keys: " + String.valueOf(initialData.keySet()));
            clickContext.openForPlayer(RankRequirementDetailView.class, initialData);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to open requirement detail view", exception);
            this.i18n("error.detail_view_failed", player).includePrefix().build().sendMessage();
        }
    }

    private void renderAdditionalInfo(@NotNull RenderContext render, @NotNull Player player, @NotNull RRank rank, @NotNull RDQPlayer rdqPlayer) {
        try {
            double overallProgress = this.progressManager.getRankOverallProgress(player, rdqPlayer, rank);
            boolean allCompleted = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
            LOGGER.log(Level.FINE, "Additional info rendered for rank: " + rank.getIdentifier() + " - Progress: " + (int)(overallProgress * 100.0) + "% - All completed: " + allCompleted);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render additional info", exception);
        }
    }

    private String getRequirementName(@NotNull RRankUpgradeRequirement requirement) {
        try {
            return requirement.getRequirement().getRequirement().getType().name();
        }
        catch (Exception exception) {
            return "Unknown Requirement";
        }
    }

    private String getRequirementDescription(@NotNull RRankUpgradeRequirement requirement) {
        try {
            return requirement.getRequirement().getRequirement().getDescriptionKey();
        }
        catch (Exception exception) {
            return "A requirement for rank progression";
        }
    }

    private int getRequirementItemCount(@NotNull RRankUpgradeRequirement requirement) {
        try {
            AbstractRequirement abstractReq = requirement.getRequirement().getRequirement();
            if (abstractReq instanceof ItemRequirement) {
                ItemRequirement itemReq = (ItemRequirement)abstractReq;
                return itemReq.getRequiredItems().size();
            }
            return 1;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    @NotNull
    private ItemStack createFallbackRequirementItem(@NotNull Player player, @NotNull RRankUpgradeRequirement requirement, int index) {
        return UnifiedBuilderFactory.item(Material.PAPER).setName((Component)this.i18n("requirement.fallback", player).withPlaceholder("index", index + 1).build().component()).setLore(List.of((Component[])this.i18n("requirement.fallback_lore", player).build().component())).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void renderFallbackRequirementEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull RRankUpgradeRequirement requirement) {
        Player player = context.getPlayer();
        ItemStack fallbackItem = this.createFallbackRequirementItem(player, requirement, index);
        builder.withItem(fallbackItem).onClick(clickContext -> this.i18n("error.requirement_unavailable", player).includePrefix().build().sendMessage());
    }

    private void renderErrorState(@NotNull RenderContext render, @NotNull Player player) {
        try {
            LOGGER.log(Level.WARNING, "Rendering error state for requirements overview");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render error state", exception);
        }
    }
}

