/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.ranks;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.manager.RankRequirementProgressManager;
import com.raindropcentral.rdq.rank.IRankSystemService;
import com.raindropcentral.rdq.view.ranks.RankRequirementsJourneyView;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.heads.view.Down;
import com.raindropcentral.rplatform.utility.heads.view.Next;
import com.raindropcentral.rplatform.utility.heads.view.Previous;
import com.raindropcentral.rplatform.utility.heads.view.Return;
import com.raindropcentral.rplatform.utility.heads.view.Up;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RankPathOverview
extends BaseView {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final State<RDQPlayer> currentPlayer = this.initialState("player");
    private final State<RRankTree> selectedRankTree = this.initialState("rankTree");
    private final State<Boolean> isPreviewMode = this.initialState("previewMode");
    private final MutableState<Integer> viewOffsetX = this.mutableState(0);
    private final MutableState<Integer> viewOffsetY = this.mutableState(0);
    private final MutableState<Long> dataRefreshTimestamp = this.mutableState(System.currentTimeMillis());
    private final MutableState<Map<String, RankNode>> cachedRankHierarchy = this.mutableState(new HashMap());
    private final MutableState<Map<String, GridPosition>> cachedWorldPositions = this.mutableState(new HashMap());
    private final MutableState<Map<String, RankStatus>> cachedRankStatuses = this.mutableState(new HashMap());
    private final MutableState<Set<String>> cachedOwnedRanks = this.mutableState(new HashSet());
    private final MutableState<Set<String>> cachedInProgressRanks = this.mutableState(new HashSet());
    private static final Map<GridPosition, Integer> RANK_SLOT_MAPPING = RankPathOverview.createRankSlotMapping();
    private static final List<Integer> ALL_RANK_SLOT_NUMBERS = RankPathOverview.createAllRankSlotNumbers();
    private static final GridPosition INITIAL_RANK_POSITION = new GridPosition(3, 2);
    private static final int RANK_SPACING_DISTANCE = 5;
    private static final int NAVIGATION_LEFT_SLOT = 18;
    private static final int NAVIGATION_RIGHT_SLOT = 26;
    private static final int NAVIGATION_UP_SLOT = 4;
    private static final int NAVIGATION_DOWN_SLOT = 49;
    private static final int BACK_BUTTON_SLOT = 45;
    private static final int CENTER_VIEW_SLOT = 53;
    private static final int PREVIEW_INDICATOR_SLOT = 8;
    private static final Material OWNED_RANK_MATERIAL = Material.LIME_STAINED_GLASS_PANE;
    private static final Material IN_PROGRESS_RANK_MATERIAL = Material.YELLOW_STAINED_GLASS_PANE;
    private static final Material AVAILABLE_RANK_MATERIAL = Material.ORANGE_STAINED_GLASS_PANE;
    private static final Material LOCKED_RANK_MATERIAL = Material.RED_STAINED_GLASS_PANE;
    private static final Material CONNECTION_LINE_MATERIAL = Material.LIGHT_GRAY_STAINED_GLASS_PANE;
    private static final Material BACKGROUND_FILL_MATERIAL = Material.GRAY_STAINED_GLASS_PANE;
    private static final Material PREVIEW_MODE_MATERIAL = Material.SPYGLASS;
    private RankRequirementProgressManager progressManager;

    @Override
    protected String getKey() {
        return "rank_path_overview_ui";
    }

    @Override
    @NotNull
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext openContext) {
        try {
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)openContext);
            boolean previewMode = (Boolean)this.isPreviewMode.get((StateValueHost)openContext);
            I18n rankTreeDisplayName = this.extractRankTreeDisplayName(rankTree, openContext.getPlayer());
            Component displayComponent = (Component)rankTreeDisplayName.component();
            if (previewMode) {
                Component prefix = (Component)this.i18n("preview_prefix", openContext.getPlayer()).build().component();
                displayComponent = prefix.append(displayComponent);
            }
            return Map.of("rank_tree_name", LegacyComponentSerializer.legacySection().serialize(displayComponent));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to generate title placeholders", exception);
            return Map.of("rank_tree_name", this.i18n("unknown_tree", openContext.getPlayer()).build().component());
        }
    }

    @Override
    public void onResume(@NotNull Context origin, @NotNull Context target) {
        try {
            LOGGER.log(Level.FINE, "RankPathOverview resumed, checking if data refresh is needed");
            long currentTime = System.currentTimeMillis();
            long lastRefresh = (Long)this.dataRefreshTimestamp.get((StateValueHost)target);
            long timeSinceRefresh = currentTime - lastRefresh;
            LOGGER.log(Level.INFO, "Refreshing cached data due to time elapsed: " + timeSinceRefresh + "ms");
            boolean previewMode = (Boolean)this.isPreviewMode.get((StateValueHost)target);
            this.initializeAndCacheData(target, previewMode);
            this.renderDynamicRankGrid((RenderContext)target, target.getPlayer(), (RRankTree)this.selectedRankTree.get((StateValueHost)target), previewMode);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh data on resume", exception);
        }
    }

    @Override
    public void onFirstRender(@NotNull RenderContext renderContext, @NotNull Player player) {
        try {
            LOGGER.log(Level.INFO, "Starting rank path overview render for player: " + player.getName());
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)renderContext);
            boolean previewMode = (Boolean)this.isPreviewMode.get((StateValueHost)renderContext);
            if (rankTree == null) {
                LOGGER.log(Level.WARNING, "RankTree is null, rendering error state");
                this.renderErrorState(renderContext, player);
                return;
            }
            this.initializeAndCacheData((Context)renderContext, previewMode);
            this.initializeViewOffsets(renderContext);
            this.renderStaticInterfaceComponents(renderContext, player, rankTree, previewMode);
            this.renderDynamicRankGrid(renderContext, player, rankTree, previewMode);
            LOGGER.log(Level.INFO, "Rank path overview render completed successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Critical error during rank path overview render", exception);
            this.renderCriticalErrorState(renderContext, player);
        }
    }

    private void initializeAndCacheData(@NotNull SlotClickContext renderContext, boolean previewMode) {
        try {
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)renderContext);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)renderContext);
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)renderContext);
            IRankSystemService rankSystemService = plugin.getRankSystemService();
            LOGGER.log(Level.FINE, "Pre-loading and caching rank data...");
            Map<String, RankNode> rankHierarchy = this.buildRankNodeHierarchy(rankTree);
            this.cachedRankHierarchy.set(rankHierarchy, (StateValueHost)renderContext);
            Map<String, GridPosition> worldPositions = this.calculateRankWorldPositions(rankHierarchy);
            this.cachedWorldPositions.set(worldPositions, (StateValueHost)renderContext);
            if (!previewMode) {
                Set<String> ownedRanks = this.loadOwnedRanks(plugin, rdqPlayer, rankTree);
                Set<String> inProgressRanks = this.loadInProgressRanks(plugin, rdqPlayer, rankTree);
                this.cachedOwnedRanks.set(ownedRanks, (StateValueHost)renderContext);
                this.cachedInProgressRanks.set(inProgressRanks, (StateValueHost)renderContext);
                Map<String, RankStatus> rankStatuses = this.calculateAllRankStatuses(rankHierarchy, ownedRanks, inProgressRanks, previewMode, rankTree, rankSystemService);
                this.cachedRankStatuses.set(rankStatuses, (StateValueHost)renderContext);
                LOGGER.log(Level.FINE, "Cached data: " + ownedRanks.size() + " owned ranks, " + inProgressRanks.size() + " in-progress ranks");
            } else {
                Map<String, RankStatus> previewStatuses = this.calculateAllRankStatuses(rankHierarchy, new HashSet<String>(), new HashSet<String>(), previewMode, rankTree, rankSystemService);
                this.cachedRankStatuses.set(previewStatuses, (StateValueHost)renderContext);
            }
            this.dataRefreshTimestamp.set((Object)System.currentTimeMillis(), (StateValueHost)renderContext);
            LOGGER.log(Level.FINE, "Data caching completed successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize and cache data", exception);
            this.cachedRankHierarchy.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedWorldPositions.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedRankStatuses.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedOwnedRanks.set(new HashSet(), (StateValueHost)renderContext);
            this.cachedInProgressRanks.set(new HashSet(), (StateValueHost)renderContext);
        }
    }

    @NotNull
    private Set<String> loadOwnedRanks(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            HashSet<String> ownedRanks = new HashSet<String>();
            RPlayerRank playerRank = this.getPlayerRankForTree(plugin, rdqPlayer, rankTree);
            if (playerRank != null && playerRank.getCurrentRank() != null) {
                RRank currentRank = playerRank.getCurrentRank();
                ownedRanks.add(currentRank.getIdentifier());
                this.addProgressionPathRanks(currentRank, rankTree, ownedRanks);
            }
            return ownedRanks;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to load owned ranks", exception);
            return new HashSet<String>();
        }
    }

    private void addProgressionPathRanks(@NotNull RRank targetRank, @NotNull RRankTree rankTree, @NotNull Set<String> ownedRanks) {
        Map<String, RRank> rankMap = rankTree.getRanks().stream().collect(Collectors.toMap(RRank::getIdentifier, rank -> rank));
        HashSet<String> visited = new HashSet<String>();
        this.addProgressionPathRanksRecursive(targetRank, rankMap, ownedRanks, visited);
    }

    private void addProgressionPathRanksRecursive(@NotNull RRank currentRank, @NotNull Map<String, RRank> rankMap, @NotNull Set<String> ownedRanks, @NotNull Set<String> visited) {
        if (visited.contains(currentRank.getIdentifier())) {
            return;
        }
        visited.add(currentRank.getIdentifier());
        ownedRanks.add(currentRank.getIdentifier());
        for (String previousRankId : currentRank.getPreviousRanks()) {
            RRank previousRank = rankMap.get(previousRankId);
            if (previousRank == null) continue;
            this.addProgressionPathRanksRecursive(previousRank, rankMap, ownedRanks, visited);
        }
    }

    @NotNull
    private Set<String> loadInProgressRanks(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            HashSet<String> inProgressRanks = new HashSet<String>();
            for (RRank rank : rankTree.getRanks()) {
                if (!this.isRankInProgressDirect(plugin, rdqPlayer, rank)) continue;
                inProgressRanks.add(rank.getIdentifier());
            }
            return inProgressRanks;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to load in-progress ranks", exception);
            return new HashSet<String>();
        }
    }

    private boolean isRankInProgressDirect(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = rank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                return false;
            }
            boolean hasAnyProgress = false;
            boolean hasCompletedAll = true;
            for (RRankUpgradeRequirement requirement : upgradeRequirements) {
                List progressList = plugin.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
                if (!progressList.isEmpty()) {
                    hasAnyProgress = true;
                    RPlayerRankUpgradeProgress progress = (RPlayerRankUpgradeProgress)progressList.get(0);
                    if (progress.isCompleted()) continue;
                    hasCompletedAll = false;
                    continue;
                }
                hasCompletedAll = false;
            }
            return hasAnyProgress && !hasCompletedAll;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if rank is in progress: " + rank.getIdentifier(), exception);
            return false;
        }
    }

    @NotNull
    private Map<String, RankStatus> calculateAllRankStatuses(@NotNull Map<String, RankNode> rankHierarchy, @NotNull Set<String> ownedRanks, @NotNull Set<String> inProgressRanks, boolean previewMode, @NotNull RRankTree rankTree, IRankSystemService rankSystemService) {
        HashMap<String, RankStatus> statuses = new HashMap<String, RankStatus>();
        if (previewMode) {
            for (Map.Entry<String, RankNode> entry : rankHierarchy.entrySet()) {
                RRank rank = entry.getValue().rank;
                if (rankSystemService != null && rankSystemService.isRankBeyondLimit(rank, rankTree)) {
                    statuses.put(entry.getKey(), RankStatus.FREE_VERSION_LOCKED);
                    continue;
                }
                statuses.put(entry.getKey(), rank.isInitialRank() ? RankStatus.OWNED : RankStatus.AVAILABLE);
            }
            return statuses;
        }
        for (Map.Entry<String, RankNode> entry : rankHierarchy.entrySet()) {
            String rankId = entry.getKey();
            RankNode rankNode = entry.getValue();
            RRank rank = rankNode.rank;
            if (rankSystemService != null && rankSystemService.isRankBeyondLimit(rank, rankTree)) {
                statuses.put(rankId, RankStatus.FREE_VERSION_LOCKED);
                continue;
            }
            if (ownedRanks.contains(rankId)) {
                statuses.put(rankId, RankStatus.OWNED);
                continue;
            }
            if (inProgressRanks.contains(rankId)) {
                statuses.put(rankId, RankStatus.IN_PROGRESS);
                continue;
            }
            if (this.arePrerequisitesMetCached(rankNode, ownedRanks)) {
                statuses.put(rankId, RankStatus.AVAILABLE);
                continue;
            }
            statuses.put(rankId, RankStatus.LOCKED);
        }
        return statuses;
    }

    private boolean arePrerequisitesMetCached(@NotNull RankNode rankNode, @NotNull Set<String> ownedRanks) {
        if (rankNode.parents.isEmpty() || rankNode.rank.isInitialRank()) {
            return true;
        }
        return rankNode.parents.stream().anyMatch(parent -> ownedRanks.contains(parent.rank.getIdentifier()));
    }

    @NotNull
    private I18n extractRankTreeDisplayName(RRankTree rankTree, @NotNull Player player) {
        if (rankTree == null) {
            return this.i18n("unknown_tree", player).build();
        }
        return new I18n.Builder(rankTree.getDisplayNameKey(), player).build();
    }

    private void initializeViewOffsets(@NotNull RenderContext renderContext) {
        try {
            this.viewOffsetX.set((Object)0, (StateValueHost)renderContext);
            this.viewOffsetY.set((Object)0, (StateValueHost)renderContext);
            LOGGER.log(Level.FINE, "Initialized view offsets to zero");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to initialize view offsets", exception);
            this.viewOffsetX.set((Object)0, (StateValueHost)renderContext);
            this.viewOffsetY.set((Object)0, (StateValueHost)renderContext);
        }
    }

    private void renderStaticInterfaceComponents(@NotNull RenderContext renderContext, @NotNull Player player, @NotNull RRankTree rankTree, boolean previewMode) {
        try {
            this.renderNavigationControls(renderContext, player);
            this.renderUtilityButtons(renderContext, player, previewMode);
            if (previewMode) {
                this.renderPreviewModeIndicator(renderContext, player);
            }
            LOGGER.log(Level.FINE, "Static interface components rendered successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render static interface components", exception);
        }
    }

    private void renderNavigationControls(@NotNull RenderContext renderContext, @NotNull Player player) {
        boolean invertNavigation = ((RDQ)this.rdq.get((StateValueHost)renderContext)).getRankSystemFactory().getRankSystemSection().getSettings().getInvertNavigation();
        int upDeltaY = invertNavigation ? 1 : -1;
        int downDeltaY = invertNavigation ? -1 : 1;
        this.renderNavigationArrow(renderContext, player, 18, new Previous(), "left", -1, 0);
        this.renderNavigationArrow(renderContext, player, 26, new Next(), "right", 1, 0);
        this.renderNavigationArrow(renderContext, player, 4, new Up(), "up", 0, upDeltaY);
        this.renderNavigationArrow(renderContext, player, 49, new Down(), "down", 0, downDeltaY);
    }

    private void renderNavigationArrow(@NotNull RenderContext renderContext, @NotNull Player player, int slotNumber, @NotNull Object headProvider, @NotNull String direction, int deltaX, int deltaY) {
        try {
            ((BukkitItemComponentBuilder)renderContext.slot(slotNumber)).renderWith(() -> this.createNavigationArrowItem(headProvider, player, direction)).onClick(clickContext -> this.handleNavigationClick(renderContext, deltaX, deltaY, direction));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render navigation arrow: " + direction, exception);
        }
    }

    @NotNull
    private ItemStack createNavigationArrowItem(@NotNull Object headProvider, @NotNull Player player, @NotNull String direction) {
        try {
            ItemStack headItem = this.extractHeadFromProvider(headProvider, player);
            return UnifiedBuilderFactory.item(headItem).setName((Component)this.i18n("nav." + direction, player).build().component()).setLore(List.of()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create navigation arrow item for: " + direction, exception);
            return UnifiedBuilderFactory.item(Material.ARROW).setName((Component)this.i18n("nav.fallback", player).withPlaceholder("direction", direction).build().component()).setLore(List.of()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    @NotNull
    private ItemStack extractHeadFromProvider(@NotNull Object headProvider, @NotNull Player player) {
        if (headProvider instanceof Previous) {
            return ((Previous)headProvider).getHead(player);
        }
        if (headProvider instanceof Next) {
            return ((Next)headProvider).getHead(player);
        }
        if (headProvider instanceof Up) {
            return ((Up)headProvider).getHead(player);
        }
        if (headProvider instanceof Down) {
            return ((Down)headProvider).getHead(player);
        }
        return UnifiedBuilderFactory.item(Material.ARROW).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void handleNavigationClick(@NotNull RenderContext renderContext, int deltaX, int deltaY, @NotNull String direction) {
        int currentX = (Integer)this.viewOffsetX.get((StateValueHost)renderContext);
        int currentY = (Integer)this.viewOffsetY.get((StateValueHost)renderContext);
        int newOffsetX = currentX + deltaX;
        int newOffsetY = currentY + deltaY;
        this.viewOffsetX.set((Object)newOffsetX, (StateValueHost)renderContext);
        this.viewOffsetY.set((Object)newOffsetY, (StateValueHost)renderContext);
        LOGGER.log(Level.FINE, "Navigation " + direction + ": offset X=" + newOffsetX + ", Y=" + newOffsetY);
    }

    private void renderUtilityButtons(@NotNull RenderContext renderContext, @NotNull Player player, boolean previewMode) {
        this.renderBackButton(renderContext, player, previewMode);
        this.renderCenterViewButton(renderContext, player, previewMode);
    }

    private void renderBackButton(@NotNull RenderContext renderContext, @NotNull Player player, boolean previewMode) {
        try {
            ((BukkitItemComponentBuilder)renderContext.slot(45)).renderWith(() -> this.createBackButtonItem(player, previewMode)).onClick(SlotContext::back);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render back button", exception);
        }
    }

    @NotNull
    private ItemStack createBackButtonItem(@NotNull Player player, boolean previewMode) {
        try {
            ItemStack backItem = new Return().getHead(player);
            if (previewMode) {
                ArrayList<Component> lore = new ArrayList<Component>();
                lore.addAll(this.i18n("back.lore", player).build().children());
                lore.addAll(this.i18n("preview_mode.lore", player).build().children());
                return UnifiedBuilderFactory.item(backItem).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setLore(lore).build();
            }
            return backItem;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create back button item", exception);
            return new Return().getHead(player);
        }
    }

    private void renderCenterViewButton(@NotNull RenderContext renderContext, @NotNull Player player, boolean previewMode) {
        try {
            ((BukkitItemComponentBuilder)renderContext.slot(53)).renderWith(() -> this.createCenterViewButtonItem(player, previewMode)).onClick(clickContext -> this.handleCenterViewClick(renderContext));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render center view button", exception);
        }
    }

    @NotNull
    private ItemStack createCenterViewButtonItem(@NotNull Player player, boolean previewMode) {
        try {
            return UnifiedBuilderFactory.item(Material.COMPASS).setName((Component)this.i18n("center_view.name", player).build().component()).setLore(this.i18n("center_view.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create center view button item", exception);
            return UnifiedBuilderFactory.item(Material.COMPASS).setName((Component)this.i18n("center_view.fallback", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    private void handleCenterViewClick(@NotNull RenderContext renderContext) {
        LOGGER.log(Level.FINE, "Resetting view to center position");
        this.viewOffsetX.set((Object)0, (StateValueHost)renderContext);
        this.viewOffsetY.set((Object)0, (StateValueHost)renderContext);
    }

    private void renderPreviewModeIndicator(@NotNull RenderContext renderContext, @NotNull Player player) {
        try {
            ((BukkitItemComponentBuilder)renderContext.slot(8)).renderWith(() -> this.createPreviewModeIndicatorItem(player));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to render preview mode indicator", exception);
        }
    }

    @NotNull
    private ItemStack createPreviewModeIndicatorItem(@NotNull Player player) {
        try {
            return UnifiedBuilderFactory.item(PREVIEW_MODE_MATERIAL).setName((Component)this.i18n("preview_mode.name", player).build().component()).setLore(this.i18n("preview_mode.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create preview mode indicator item", exception);
            return UnifiedBuilderFactory.item(PREVIEW_MODE_MATERIAL).setName((Component)this.i18n("preview_mode.fallback", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    private void renderDynamicRankGrid(@NotNull RenderContext renderContext, @NotNull Player player, @NotNull RRankTree rankTree, boolean previewMode) {
        try {
            Map rankNodeHierarchy = (Map)this.cachedRankHierarchy.get((StateValueHost)renderContext);
            Map worldPositionMapping = (Map)this.cachedWorldPositions.get((StateValueHost)renderContext);
            LOGGER.log(Level.FINE, "Rendering dynamic grid with cached data: {} nodes", rankNodeHierarchy.size());
            for (Integer slotNumber : ALL_RANK_SLOT_NUMBERS) {
                this.bindSlotToDynamicContent(renderContext, player, rankTree, slotNumber, rankNodeHierarchy, worldPositionMapping, previewMode);
            }
            LOGGER.log(Level.FINE, "Dynamic rank grid rendered successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render dynamic rank grid", exception);
            this.renderFallbackGrid(renderContext, player, rankTree);
        }
    }

    private void bindSlotToDynamicContent(@NotNull RenderContext renderContext, @NotNull Player player, @NotNull RRankTree rankTree, int slotNumber, @NotNull Map<String, RankNode> rankNodeHierarchy, @NotNull Map<String, GridPosition> worldPositionMapping, boolean previewMode) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)renderContext.slot(slotNumber)).renderWith(() -> this.createDynamicSlotContent(slotNumber, renderContext, player, rankTree, rankNodeHierarchy, worldPositionMapping, previewMode)).updateOnStateChange(this.viewOffsetX, new State[]{this.viewOffsetY, this.dataRefreshTimestamp})).onClick(clickContext -> this.handleDynamicSlotClick((SlotClickContext)clickContext, slotNumber, renderContext, rankNodeHierarchy, worldPositionMapping));
    }

    @NotNull
    private ItemStack createDynamicSlotContent(int slotNumber, @NotNull RenderContext renderContext, @NotNull Player player, @NotNull RRankTree rankTree, @NotNull Map<String, RankNode> rankNodeHierarchy, @NotNull Map<String, GridPosition> worldPositionMapping, boolean previewMode) {
        try {
            RankNode rankNode;
            int offsetX = (Integer)this.viewOffsetX.get((StateValueHost)renderContext);
            int offsetY = (Integer)this.viewOffsetY.get((StateValueHost)renderContext);
            GridPosition slotGridPosition = this.findGridPositionForSlot(slotNumber);
            if (slotGridPosition == null) {
                return this.createBackgroundPane(player);
            }
            if (slotGridPosition.y == 0) {
                return this.createBackgroundPane(player);
            }
            GridPosition worldPosition = new GridPosition(slotGridPosition.x - offsetX, slotGridPosition.y - offsetY);
            String rankIdAtPosition = this.findRankIdAtWorldPosition(worldPosition, worldPositionMapping);
            if (rankIdAtPosition != null && (rankNode = rankNodeHierarchy.get(rankIdAtPosition)) != null) {
                return this.createRankDisplayItem(player, rankNode, renderContext, previewMode);
            }
            ItemStack connectionItem = this.createConnectionLineItem(slotGridPosition, offsetX, offsetY, worldPositionMapping, rankNodeHierarchy, player, renderContext, previewMode);
            if (connectionItem != null) {
                return connectionItem;
            }
            return this.createBackgroundPane(player);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create dynamic slot content for slot " + slotNumber, exception);
            return this.createBackgroundPane(player);
        }
    }

    private GridPosition findGridPositionForSlot(int slotNumber) {
        for (Map.Entry<GridPosition, Integer> entry : RANK_SLOT_MAPPING.entrySet()) {
            if (!entry.getValue().equals(slotNumber)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String findRankIdAtWorldPosition(@NotNull GridPosition worldPosition, @NotNull Map<String, GridPosition> worldPositionMapping) {
        for (Map.Entry<String, GridPosition> entry : worldPositionMapping.entrySet()) {
            if (!entry.getValue().equals(worldPosition)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    private ItemStack createBackgroundPane(@NotNull Player player) {
        return UnifiedBuilderFactory.item(BACKGROUND_FILL_MATERIAL).setName((Component)this.i18n("background.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private ItemStack createConnectionLineItem(@NotNull GridPosition slotPosition, int offsetX, int offsetY, @NotNull Map<String, GridPosition> worldPositionMapping, @NotNull Map<String, RankNode> rankNodeHierarchy, @NotNull Player player, @NotNull RenderContext renderContext, boolean previewMode) {
        try {
            GridPosition worldPosition = new GridPosition(slotPosition.x - offsetX, slotPosition.y - offsetY);
            for (Map.Entry<String, RankNode> entry : rankNodeHierarchy.entrySet()) {
                RankNode parentNode = entry.getValue();
                GridPosition parentWorldPosition = worldPositionMapping.get(entry.getKey());
                if (parentWorldPosition == null) continue;
                for (RankNode childNode : parentNode.children) {
                    GridPosition childWorldPosition = worldPositionMapping.get(childNode.rank.getIdentifier());
                    if (childWorldPosition == null || !this.isConnectionPosition(worldPosition, parentWorldPosition, childWorldPosition, parentNode, worldPositionMapping)) continue;
                    return this.createConnectionLineDisplayItem(parentNode, childNode, player, renderContext, previewMode);
                }
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create connection line item", exception);
            return null;
        }
    }

    private boolean isConnectionPosition(@NotNull GridPosition position, @NotNull GridPosition parentPosition, @NotNull GridPosition childPosition, @NotNull RankNode parentNode, @NotNull Map<String, GridPosition> worldPositionMapping) {
        if (parentNode.children.size() == 1) {
            return this.isDirectConnectionPosition(position, parentPosition, childPosition);
        }
        return this.isBalancedBranchingConnectionPosition(position, parentPosition, childPosition, parentNode, worldPositionMapping);
    }

    private boolean isDirectConnectionPosition(@NotNull GridPosition position, @NotNull GridPosition parentPosition, @NotNull GridPosition childPosition) {
        if (parentPosition.x == childPosition.x && parentPosition.x == position.x) {
            int minY = Math.min(parentPosition.y, childPosition.y);
            int maxY = Math.max(parentPosition.y, childPosition.y);
            return position.y > minY && position.y < maxY;
        }
        if (parentPosition.y == childPosition.y && parentPosition.y == position.y) {
            int minX = Math.min(parentPosition.x, childPosition.x);
            int maxX = Math.max(parentPosition.x, childPosition.x);
            return position.x > minX && position.x < maxX;
        }
        int deltaX = Math.abs(parentPosition.x - childPosition.x);
        int deltaY = Math.abs(parentPosition.y - childPosition.y);
        if (deltaX == 5 && deltaY == 5) {
            int stepX = Integer.signum(childPosition.x - parentPosition.x);
            int stepY = Integer.signum(childPosition.y - parentPosition.y);
            for (int step = 1; step < 5; ++step) {
                int connectionX = parentPosition.x + stepX * step;
                int connectionY = parentPosition.y + stepY * step;
                if (position.x != connectionX || position.y != connectionY) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBalancedBranchingConnectionPosition(@NotNull GridPosition position, @NotNull GridPosition parentPosition, @NotNull GridPosition childPosition, @NotNull RankNode parentNode, @NotNull Map<String, GridPosition> worldPositionMapping) {
        int halfWidth;
        int maxX;
        int minX;
        int centerX;
        List<GridPosition> childPositions = this.extractChildPositions(parentNode, worldPositionMapping);
        if (childPositions.isEmpty()) {
            return false;
        }
        childPositions.sort(Comparator.comparingInt(p -> p.x));
        int branchingDistance = 2;
        GridPosition branchingPoint = new GridPosition(parentPosition.x, parentPosition.y + 2);
        GridPosition leftmostChild = childPositions.get(0);
        GridPosition rightmostChild = childPositions.get(childPositions.size() - 1);
        if (position.x == parentPosition.x && position.y > parentPosition.y && position.y < branchingPoint.y) {
            return true;
        }
        if (position.y == branchingPoint.y && position.x >= (centerX = ((minX = Math.min(leftmostChild.x, rightmostChild.x)) + (maxX = Math.max(leftmostChild.x, rightmostChild.x))) / 2) - (halfWidth = (maxX - minX) / 2) && position.x <= centerX + halfWidth) {
            return true;
        }
        for (GridPosition childPos : childPositions) {
            if (position.x != childPos.x || position.y <= branchingPoint.y || position.y >= childPos.y) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<GridPosition> extractChildPositions(@NotNull RankNode parentNode, @NotNull Map<String, GridPosition> worldPositionMapping) {
        ArrayList<GridPosition> childPositions = new ArrayList<GridPosition>();
        for (RankNode childNode : parentNode.children) {
            GridPosition childPosition = worldPositionMapping.get(childNode.rank.getIdentifier());
            if (childPosition == null) continue;
            childPositions.add(childPosition);
        }
        return childPositions;
    }

    @NotNull
    private ItemStack createConnectionLineDisplayItem(@NotNull RankNode parentNode, @NotNull RankNode childNode, @NotNull Player player, @NotNull RenderContext renderContext, boolean previewMode) {
        try {
            Map cachedStatuses = (Map)this.cachedRankStatuses.get((StateValueHost)renderContext);
            RankStatus childStatus = cachedStatuses.getOrDefault(childNode.rank.getIdentifier(), RankStatus.LOCKED);
            Material connectionMaterial = this.getConnectionMaterialForStatus(childStatus);
            Component connectionName = this.getConnectionNameForStatus(childStatus, player);
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add((Component)this.i18n("connection.from", player).withPlaceholder("rank_name", parentNode.rank.getIdentifier()).build().component());
            lore.add((Component)this.i18n("connection.to", player).withPlaceholder("rank_name", childNode.rank.getIdentifier()).build().component());
            if (previewMode) {
                lore.addAll(this.i18n("preview_mode.lore", player).build().children());
            }
            return UnifiedBuilderFactory.item(connectionMaterial).setName(connectionName).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create connection line display item", exception);
            return UnifiedBuilderFactory.item(CONNECTION_LINE_MATERIAL).setName((Component)this.i18n("connection.fallback", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    @NotNull
    private Material getConnectionMaterialForStatus(@NotNull RankStatus status) {
        return switch (status.ordinal()) {
            case 0 -> OWNED_RANK_MATERIAL;
            case 1 -> AVAILABLE_RANK_MATERIAL;
            case 2 -> IN_PROGRESS_RANK_MATERIAL;
            default -> LOCKED_RANK_MATERIAL;
        };
    }

    @NotNull
    private Component getConnectionNameForStatus(@NotNull RankStatus status, @NotNull Player player) {
        return switch (status.ordinal()) {
            case 0 -> (Component)this.i18n("connection.owned", player).build().component();
            case 1 -> (Component)this.i18n("connection.available", player).build().component();
            case 2 -> (Component)this.i18n("connection.in_progress", player).build().component();
            default -> (Component)this.i18n("connection.locked", player).build().component();
        };
    }

    private void handleDynamicSlotClick(@NotNull SlotClickContext clickContext, int slotNumber, @NotNull RenderContext renderContext, @NotNull Map<String, RankNode> rankNodeHierarchy, @NotNull Map<String, GridPosition> worldPositionMapping) {
        try {
            RankNode rankNode;
            int offsetX = (Integer)this.viewOffsetX.get((StateValueHost)renderContext);
            int offsetY = (Integer)this.viewOffsetY.get((StateValueHost)renderContext);
            GridPosition slotGridPosition = this.findGridPositionForSlot(slotNumber);
            if (slotGridPosition == null) {
                return;
            }
            GridPosition worldPosition = new GridPosition(slotGridPosition.x - offsetX, slotGridPosition.y - offsetY);
            String rankIdAtPosition = this.findRankIdAtWorldPosition(worldPosition, worldPositionMapping);
            if (rankIdAtPosition != null && (rankNode = rankNodeHierarchy.get(rankIdAtPosition)) != null) {
                this.handleRankNodeClick(clickContext, rankNode, renderContext);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle dynamic slot click", exception);
        }
    }

    private void handleRankNodeClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull RenderContext renderContext) {
        Player player = clickContext.getPlayer();
        boolean currentPreviewMode = (Boolean)this.isPreviewMode.get((StateValueHost)clickContext);
        Map cachedStatuses = (Map)this.cachedRankStatuses.get((StateValueHost)renderContext);
        RankStatus rankStatus = cachedStatuses.getOrDefault(rankNode.rank.getIdentifier(), RankStatus.LOCKED);
        ClickType clickType = clickContext.getClickOrigin().getClick();
        LOGGER.log(Level.FINE, "Handling rank click: " + rankNode.rank.getIdentifier() + " - Preview: " + currentPreviewMode + " - Status: " + String.valueOf((Object)rankStatus) + " - Click: " + String.valueOf(clickType));
        if (currentPreviewMode) {
            this.handlePreviewModeRankClick(player, rankNode.rank);
            return;
        }
        switch (rankStatus.ordinal()) {
            case 0: {
                this.handleOwnedRankClick(player, rankNode.rank);
                break;
            }
            case 1: {
                this.handleAvailableRankClick(clickContext, rankNode, clickType);
                break;
            }
            case 2: {
                this.handleInProgressRankClick(clickContext, rankNode, clickType);
                break;
            }
            case 3: {
                this.handleLockedRankClick(player, rankNode.rank);
                break;
            }
            case 4: {
                this.handleFreeVersionLockedRankClick(player, rankNode.rank);
            }
        }
    }

    private void handleFreeVersionLockedRankClick(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.free_version_locked", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send free version locked rank click message", exception);
        }
    }

    private void handlePreviewModeRankClick(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.preview_rank_click", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send preview mode rank click message", exception);
            this.i18n("messages.preview_rank_click_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void handleOwnedRankClick(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.rank_owned", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send owned rank click message", exception);
            this.i18n("messages.rank_owned_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void handleAvailableRankClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            Player player = clickContext.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
            RRank rank = rankNode.rank;
            if (this.progressManager != null && this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank)) {
                this.redeemRank(clickContext, rankNode);
            } else {
                this.startRankProgression(clickContext, rankNode);
            }
        } else if (clickType == ClickType.RIGHT) {
            this.openRankRequirementsView(clickContext, rankNode);
        }
    }

    private void handleInProgressRankClick(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode, @NotNull ClickType clickType) {
        if (clickType == ClickType.LEFT) {
            this.openRankRequirementsView(clickContext, rankNode);
        } else if (clickType == ClickType.RIGHT) {
            this.openRankRequirementsView(clickContext, rankNode);
        }
    }

    private void handleLockedRankClick(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.rank_locked", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send locked rank click message", exception);
            this.i18n("messages.rank_locked_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void createProgressTrackingEntries(@NotNull RDQ plugin, @NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull Set<RRankUpgradeRequirement> upgradeRequirements) {
        for (RRankUpgradeRequirement requirement : upgradeRequirements) {
            List existingProgress = plugin.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
            if (!existingProgress.isEmpty()) continue;
            RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(rdqPlayer, requirement);
            plugin.getPlayerRankUpgradeProgressRepository().create(newProgress);
            LOGGER.log(Level.FINE, "Created progress tracking for requirement " + requirement.getId());
        }
    }

    private void sendNoRequirementsMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.no_requirements", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send no requirements message", exception);
            this.i18n("messages.no_requirements_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void sendProgressStartedMessage(@NotNull Player player, @NotNull RRank rank, int requirementCount) {
        try {
            this.i18n("messages.rank_started", player).withPlaceholder("rank_name", rank.getIdentifier()).withPlaceholder("requirement_count", requirementCount).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send progress started message", exception);
            this.i18n("messages.rank_started_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).withPlaceholder("requirement_count", requirementCount).build().sendMessage();
        }
    }

    private void sendProgressStartErrorMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.rank_start_error", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send progress start error message", exception);
            this.i18n("messages.rank_start_error_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private boolean checkAllRequirementsCompleted(@NotNull RDQ plugin, @NotNull Player player, @NotNull Set<RRankUpgradeRequirement> upgradeRequirements) {
        for (RRankUpgradeRequirement requirement : upgradeRequirements) {
            List progressList = plugin.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
            if (!progressList.isEmpty() && ((RPlayerRankUpgradeProgress)progressList.get(0)).isCompleted()) continue;
            return false;
        }
        return true;
    }

    private void redeemRank(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        Player player = clickContext.getPlayer();
        try {
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)clickContext);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)clickContext);
            RRank newRank = rankNode.rank;
            LOGGER.log(Level.INFO, "Starting rank redemption for player " + player.getName() + " to rank " + newRank.getIdentifier());
            this.handleRankRedemptionForTree(plugin, rdqPlayer, rankTree, newRank);
            this.handleLuckPermsRankAssignment(plugin, player, newRank);
            this.refreshCachedData(clickContext);
            this.sendRankRedeemedMessage(player, newRank);
            LOGGER.log(Level.INFO, "Successfully redeemed rank " + newRank.getIdentifier() + " for player " + player.getName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to redeem rank " + rankNode.rank.getIdentifier() + " for player " + player.getName(), exception);
            this.sendRankRedemptionErrorMessage(player, rankNode.rank);
        }
    }

    private void sendRequirementsNotCompletedMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.requirements_not_completed", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send requirements not completed message", exception);
            this.i18n("messages.requirements_not_completed_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void handleRankRedemptionForTree(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull RRank newRank) {
        try {
            RPlayerRank existingRankInTree = this.getPlayerRankForTree(plugin, rdqPlayer, rankTree);
            if (existingRankInTree != null) {
                RPlayerRank freshRank = plugin.getPlayerRankRepository().findById(existingRankInTree.getId()).orElse(null);
                if (freshRank != null) {
                    freshRank.setCurrentRank(newRank);
                    freshRank.setActive(true);
                    plugin.getPlayerRankRepository().update(freshRank);
                    LOGGER.info("Updated existing rank for player " + rdqPlayer.getPlayerName() + " to " + newRank.getIdentifier() + " in tree " + rankTree.getIdentifier());
                }
            } else {
                RPlayerRank newPlayerRank = new RPlayerRank(rdqPlayer, newRank, rankTree);
                rdqPlayer.addPlayerRank(newPlayerRank);
                plugin.getPlayerRankRepository().create(newPlayerRank);
                LOGGER.info("Created new rank assignment for player " + rdqPlayer.getPlayerName() + " with rank " + newRank.getIdentifier() + " in tree " + rankTree.getIdentifier());
            }
            RDQPlayer freshPlayer = plugin.getPlayerRepository().findById(rdqPlayer.getId()).orElse(null);
            if (freshPlayer != null) {
                plugin.getPlayerRepository().update(freshPlayer);
            }
            this.markProgressEntriesCompleted(plugin, rdqPlayer, newRank);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to handle rank redemption database operations", exception);
            throw new RuntimeException("Database rank redemption failed", exception);
        }
    }

    private void handleLuckPermsRankAssignment(@NotNull RDQ plugin, @NotNull Player player, @NotNull RRank newRank) {
        try {
            if (plugin.getLuckPermsService() != null) {
                String luckPermsGroup = newRank.getAssignedLuckPermsGroup();
                if (luckPermsGroup != null && !luckPermsGroup.isEmpty()) {
                    this.removePlayerFromPreviousRankGroups(plugin, player, newRank);
                    LOGGER.info("Assigned LuckPerms group '" + luckPermsGroup + "' to player " + player.getName());
                } else {
                    LOGGER.warning("No LuckPerms group defined for rank " + newRank.getIdentifier());
                }
            } else {
                LOGGER.warning("LuckPerms service not available for rank assignment");
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to handle LuckPerms rank assignment", exception);
        }
    }

    private void removePlayerFromPreviousRankGroups(@NotNull RDQ plugin, @NotNull Player player, @NotNull RRank newRank) {
        block3: {
            try {
                RRankTree rankTree = newRank.getRankTree();
                if (rankTree == null) break block3;
                for (RRank rank : rankTree.getRanks()) {
                    String groupToRemove;
                    if (!rank.equals(newRank) && (groupToRemove = rank.getAssignedLuckPermsGroup()) != null && groupToRemove.isEmpty()) continue;
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Failed to remove player from previous rank groups", exception);
            }
        }
    }

    private void markProgressEntriesCompleted(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = rank.getUpgradeRequirements();
            for (RRankUpgradeRequirement requirement : upgradeRequirements) {
                List progressList = plugin.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
                for (RPlayerRankUpgradeProgress progress : progressList) {
                    RPlayerRankUpgradeProgress freshProgress;
                    if (progress.isCompleted() || (freshProgress = (RPlayerRankUpgradeProgress)plugin.getPlayerRankUpgradeProgressRepository().findById(progress.getId()).orElse(null)) == null) continue;
                    freshProgress.setProgress(1.0);
                    plugin.getPlayerRankUpgradeProgressRepository().update(freshProgress);
                }
            }
            LOGGER.log(Level.FINE, "Marked progress entries as completed for rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to mark progress entries as completed", exception);
        }
    }

    private RPlayerRank getPlayerRankForTree(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree) {
        try {
            List playerRanks = plugin.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId()));
            return playerRanks.stream().filter(rank -> {
                RRankTree playerRankTree = rank.getRankTree();
                return playerRankTree != null && Objects.equals(playerRankTree, rankTree);
            }).findFirst().orElse(null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get player rank for tree", exception);
            return null;
        }
    }

    private void sendRankRedemptionErrorMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.rank_redemption_error", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send rank redemption error message", exception);
            this.i18n("messages.rank_redemption_error_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void sendRankRedeemedMessage(@NotNull Player player, @NotNull RRank rank) {
        try {
            this.i18n("messages.rank_redeemed", player).withPlaceholder("rank_name", rank.getIdentifier()).includePrefix().build().sendMessage();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to send rank redeemed message", exception);
            this.i18n("messages.rank_redeemed_fallback", player).withPlaceholder("rank_name", rank.getIdentifier()).build().sendMessage();
        }
    }

    private void openRankRequirementsView(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        try {
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)clickContext);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
            boolean previewMode = (Boolean)this.isPreviewMode.get((StateValueHost)clickContext);
            this.dataRefreshTimestamp.set((Object)0L, (StateValueHost)clickContext);
            clickContext.openForPlayer(RankRequirementsJourneyView.class, Map.of("plugin", plugin, "player", rdqPlayer, "targetRank", rankNode.rank, "rankTree", this.selectedRankTree.get((StateValueHost)clickContext), "previewMode", previewMode));
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to open requirements view for rank " + rankNode.rank.getIdentifier(), exception);
            this.i18n("error.requirements_view_failed", clickContext.getPlayer()).withPlaceholder("rank_name", rankNode.rank.getIdentifier()).includePrefix().build().sendMessage();
        }
    }

    @NotNull
    private Map<String, RankNode> buildRankNodeHierarchy(@NotNull RRankTree rankTree) {
        HashMap<String, RankNode> nodeHierarchy = new HashMap<String, RankNode>();
        try {
            for (RRank rank : rankTree.getRanks()) {
                nodeHierarchy.put(rank.getIdentifier(), new RankNode(rank));
            }
            for (RRank rank : rankTree.getRanks()) {
                RankNode currentNode = (RankNode)nodeHierarchy.get(rank.getIdentifier());
                if (currentNode == null) continue;
                for (String nextRankId : rank.getNextRanks()) {
                    RankNode childNode = (RankNode)nodeHierarchy.get(nextRankId);
                    if (childNode == null) continue;
                    currentNode.children.add(childNode);
                    childNode.parents.add(currentNode);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error building rank node hierarchy", exception);
        }
        return nodeHierarchy;
    }

    @NotNull
    private Map<String, GridPosition> calculateRankWorldPositions(@NotNull Map<String, RankNode> rankNodeHierarchy) {
        HashMap<String, GridPosition> worldPositions = new HashMap<String, GridPosition>();
        HashSet<String> positionedRanks = new HashSet<String>();
        try {
            List<RankNode> initialRanks = this.findInitialRanks(rankNodeHierarchy);
            if (initialRanks.isEmpty()) {
                LOGGER.log(Level.WARNING, "No initial ranks found in hierarchy");
                return worldPositions;
            }
            LOGGER.log(Level.FINE, "Found " + initialRanks.size() + " initial ranks");
            if (initialRanks.size() == 1) {
                this.positionSingleInitialRank(initialRanks.get(0), worldPositions, positionedRanks, rankNodeHierarchy);
            } else {
                this.positionMultipleInitialRanks(initialRanks, worldPositions, positionedRanks, rankNodeHierarchy);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error calculating rank world positions", exception);
        }
        return worldPositions;
    }

    @NotNull
    private List<RankNode> findInitialRanks(@NotNull Map<String, RankNode> rankNodeHierarchy) {
        return rankNodeHierarchy.values().stream().filter(node -> node.parents.isEmpty() || node.rank.isInitialRank()).sorted(Comparator.comparingInt(node -> node.rank.getTier())).toList();
    }

    private void positionSingleInitialRank(@NotNull RankNode initialRank, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> rankNodeHierarchy) {
        worldPositions.put(initialRank.rank.getIdentifier(), INITIAL_RANK_POSITION);
        positionedRanks.add(initialRank.rank.getIdentifier());
        Integer slotNumber = RANK_SLOT_MAPPING.get(INITIAL_RANK_POSITION);
        LOGGER.log(Level.FINE, "Positioned single initial rank '" + initialRank.rank.getIdentifier() + "' at center: " + String.valueOf(INITIAL_RANK_POSITION) + " (slot " + slotNumber + ")");
        this.positionRankChildren(initialRank, INITIAL_RANK_POSITION, worldPositions, positionedRanks, rankNodeHierarchy);
    }

    private void positionMultipleInitialRanks(@NotNull List<RankNode> initialRanks, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> rankNodeHierarchy) {
        int startX = RankPathOverview.INITIAL_RANK_POSITION.x - (initialRanks.size() - 1) * 5 / 2;
        for (int i = 0; i < initialRanks.size(); ++i) {
            RankNode initialRank = initialRanks.get(i);
            GridPosition position = new GridPosition(startX + i * 5, RankPathOverview.INITIAL_RANK_POSITION.y);
            worldPositions.put(initialRank.rank.getIdentifier(), position);
            positionedRanks.add(initialRank.rank.getIdentifier());
            Integer slotNumber = RANK_SLOT_MAPPING.get(position);
            LOGGER.log(Level.FINE, "Positioned initial rank '" + initialRank.rank.getIdentifier() + "' at: " + String.valueOf(position) + " (slot " + slotNumber + ")");
            this.positionRankChildren(initialRank, position, worldPositions, positionedRanks, rankNodeHierarchy);
        }
    }

    private void positionRankChildren(@NotNull RankNode parentNode, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        if (parentNode.children.isEmpty()) {
            return;
        }
        ArrayList<RankNode> sortedChildren = new ArrayList<RankNode>(parentNode.children);
        sortedChildren.sort(Comparator.comparingInt(node -> node.rank.getTier()));
        if (sortedChildren.size() == 1) {
            this.positionSingleChild((RankNode)sortedChildren.get(0), parentPosition, worldPositions, positionedRanks, allNodes);
        } else {
            this.positionMultipleChildren(sortedChildren, parentPosition, worldPositions, positionedRanks, allNodes);
        }
    }

    private void positionSingleChild(@NotNull RankNode childNode, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        if (!positionedRanks.contains(childNode.rank.getIdentifier())) {
            GridPosition childPosition = new GridPosition(parentPosition.x, parentPosition.y + 5);
            worldPositions.put(childNode.rank.getIdentifier(), childPosition);
            positionedRanks.add(childNode.rank.getIdentifier());
            Integer slotNumber = RANK_SLOT_MAPPING.get(childPosition);
            LOGGER.log(Level.FINE, "Positioned single child '" + childNode.rank.getIdentifier() + "' below parent at: " + String.valueOf(childPosition) + " (slot " + slotNumber + ")");
            this.positionRankChildren(childNode, childPosition, worldPositions, positionedRanks, allNodes);
        }
    }

    private void positionMultipleChildren(@NotNull List<RankNode> children, @NotNull GridPosition parentPosition, @NotNull Map<String, GridPosition> worldPositions, @NotNull Set<String> positionedRanks, @NotNull Map<String, RankNode> allNodes) {
        int childY = parentPosition.y + 5;
        int totalWidth = (children.size() - 1) * 5;
        int startX = parentPosition.x - totalWidth / 2;
        for (int i = 0; i < children.size(); ++i) {
            RankNode child = children.get(i);
            if (positionedRanks.contains(child.rank.getIdentifier())) continue;
            GridPosition childPosition = new GridPosition(startX + i * 5, childY);
            worldPositions.put(child.rank.getIdentifier(), childPosition);
            positionedRanks.add(child.rank.getIdentifier());
            Integer slotNumber = RANK_SLOT_MAPPING.get(childPosition);
            LOGGER.log(Level.FINE, "Positioned child '" + child.rank.getIdentifier() + "' at balanced position: " + String.valueOf(childPosition) + " (slot " + slotNumber + ")");
            this.positionRankChildren(child, childPosition, worldPositions, positionedRanks, allNodes);
        }
    }

    @NotNull
    private ItemStack createRankDisplayItem(@NotNull Player player, @NotNull RankNode rankNode, @NotNull RenderContext renderContext, boolean previewMode) {
        try {
            RRank rank = rankNode.rank;
            Map cachedStatuses = (Map)this.cachedRankStatuses.get((StateValueHost)renderContext);
            RankStatus status = cachedStatuses.getOrDefault(rank.getIdentifier(), RankStatus.LOCKED);
            Material iconMaterial = this.extractRankIconMaterial(rank);
            List<Component> lore = this.buildRankDisplayLore(player, rank, status, previewMode);
            Component displayName = this.extractRankDisplayName(player, rank);
            ItemStack baseItem = UnifiedBuilderFactory.item(iconMaterial).setName(displayName).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            if (status == RankStatus.OWNED && !previewMode) {
                baseItem = UnifiedBuilderFactory.item(baseItem).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setGlowing(true).build();
            }
            return baseItem;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create rank display item", exception);
            return UnifiedBuilderFactory.item(Material.STONE).setName((Component)this.i18n("error.render_rank", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    @NotNull
    private Material extractRankIconMaterial(@NotNull RRank rank) {
        try {
            return Material.valueOf((String)rank.getIcon().getMaterial());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Invalid material for rank " + rank.getIdentifier() + ": " + rank.getIcon().getMaterial(), exception);
            return Material.STONE;
        }
    }

    @NotNull
    private Component extractRankDisplayName(@NotNull Player player, @NotNull RRank rank) {
        try {
            return (Component)new I18n.Builder(rank.getDisplayNameKey(), player).build().component();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to extract localized rank display name", exception);
            return (Component)this.i18n("rank.fallback_name", player).withPlaceholder("rank_id", rank.getIdentifier()).build().component();
        }
    }

    private void initializeAndCacheData(@NotNull Context renderContext, boolean previewMode) {
        try {
            RRankTree rankTree = (RRankTree)this.selectedRankTree.get((StateValueHost)renderContext);
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)renderContext);
            RDQ plugin = (RDQ)this.rdq.get((StateValueHost)renderContext);
            IRankSystemService rankSystemService = plugin.getRankSystemService();
            if (this.progressManager == null) {
                this.progressManager = new RankRequirementProgressManager(plugin);
            }
            LOGGER.log(Level.FINE, "Pre-loading and caching rank data...");
            Map<String, RankNode> rankHierarchy = this.buildRankNodeHierarchy(rankTree);
            this.cachedRankHierarchy.set(rankHierarchy, (StateValueHost)renderContext);
            Map<String, GridPosition> worldPositions = this.calculateRankWorldPositions(rankHierarchy);
            this.cachedWorldPositions.set(worldPositions, (StateValueHost)renderContext);
            if (!previewMode) {
                Set<String> ownedRanks = this.loadOwnedRanks(plugin, rdqPlayer, rankTree);
                Set<String> inProgressRanks = this.loadInProgressRanks(plugin, rdqPlayer, rankTree, renderContext.getPlayer());
                this.cachedOwnedRanks.set(ownedRanks, (StateValueHost)renderContext);
                this.cachedInProgressRanks.set(inProgressRanks, (StateValueHost)renderContext);
                Map<String, RankStatus> rankStatuses = this.calculateAllRankStatuses(rankHierarchy, ownedRanks, inProgressRanks, previewMode, rankTree, rankSystemService);
                this.cachedRankStatuses.set(rankStatuses, (StateValueHost)renderContext);
                LOGGER.log(Level.FINE, "Cached data: " + ownedRanks.size() + " owned ranks, " + inProgressRanks.size() + " in-progress ranks");
            } else {
                Map<String, RankStatus> previewStatuses = this.calculateAllRankStatuses(rankHierarchy, new HashSet<String>(), new HashSet<String>(), previewMode, rankTree, rankSystemService);
                this.cachedRankStatuses.set(previewStatuses, (StateValueHost)renderContext);
            }
            this.dataRefreshTimestamp.set((Object)System.currentTimeMillis(), (StateValueHost)renderContext);
            LOGGER.log(Level.FINE, "Data caching completed successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize and cache data", exception);
            this.cachedRankHierarchy.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedWorldPositions.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedRankStatuses.set(new HashMap(), (StateValueHost)renderContext);
            this.cachedOwnedRanks.set(new HashSet(), (StateValueHost)renderContext);
            this.cachedInProgressRanks.set(new HashSet(), (StateValueHost)renderContext);
        }
    }

    @NotNull
    private Set<String> loadInProgressRanks(@NotNull RDQ plugin, @NotNull RDQPlayer rdqPlayer, @NotNull RRankTree rankTree, @NotNull Player player) {
        try {
            HashSet<String> inProgressRanks = new HashSet<String>();
            for (RRank rank : rankTree.getRanks()) {
                if (!this.isRankInProgress(rdqPlayer, rank, player)) continue;
                inProgressRanks.add(rank.getIdentifier());
            }
            return inProgressRanks;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to load in-progress ranks", exception);
            return new HashSet<String>();
        }
    }

    private boolean isRankInProgress(@NotNull RDQPlayer rdqPlayer, @NotNull RRank rank, @NotNull Player player) {
        try {
            if (rank.getUpgradeRequirements().isEmpty()) {
                return false;
            }
            double overallProgress = this.progressManager.getRankOverallProgress(player, rdqPlayer, rank);
            boolean allCompleted = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
            return overallProgress > 0.0 && !allCompleted;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if rank is in progress: " + rank.getIdentifier(), exception);
            return false;
        }
    }

    private void attemptRankRedemption(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        try {
            Player player = clickContext.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
            RRank rank = rankNode.rank;
            boolean allRequirementsCompleted = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
            if (allRequirementsCompleted) {
                this.redeemRank(clickContext, rankNode);
            } else {
                this.sendRequirementsNotCompletedMessage(player, rank);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to attempt rank redemption for " + rankNode.rank.getIdentifier(), exception);
            this.i18n("error.general", clickContext.getPlayer()).build().sendMessage();
        }
    }

    private void startRankProgression(@NotNull SlotClickContext clickContext, @NotNull RankNode rankNode) {
        try {
            Player player = clickContext.getPlayer();
            RDQPlayer rdqPlayer = (RDQPlayer)this.currentPlayer.get((StateValueHost)clickContext);
            RRank rank = rankNode.rank;
            Set<RRankUpgradeRequirement> upgradeRequirements = rank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                this.sendNoRequirementsMessage(player, rank);
                this.redeemRank(clickContext, rankNode);
                return;
            }
            boolean allRequirementsCompleted = this.progressManager.areAllRequirementsCompleted(player, rdqPlayer, rank);
            if (allRequirementsCompleted) {
                LOGGER.log(Level.INFO, "All requirements already completed for rank " + rank.getIdentifier() + ", directly redeeming for player " + player.getName());
                this.redeemRank(clickContext, rankNode);
                return;
            }
            this.progressManager.initializeRankProgressTracking(rdqPlayer, rank);
            this.sendProgressStartedMessage(player, rank, upgradeRequirements.size());
            this.refreshCachedData(clickContext);
            LOGGER.log(Level.INFO, "Started rank progression for player " + player.getName() + " on rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to start rank progression for " + rankNode.rank.getIdentifier(), exception);
            this.sendProgressStartErrorMessage(clickContext.getPlayer(), rankNode.rank);
        }
    }

    private void refreshCachedData(@NotNull SlotClickContext clickContext) {
        try {
            boolean previewMode = (Boolean)this.isPreviewMode.get((StateValueHost)clickContext);
            if (!previewMode) {
                LOGGER.log(Level.FINE, "Refreshing cached data after rank interaction");
                if (this.progressManager != null) {
                    this.progressManager.cleaRDQPlayerCache(clickContext.getPlayer());
                }
                this.initializeAndCacheData(clickContext, previewMode);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh cached data", exception);
        }
    }

    @NotNull
    private List<Component> buildRankDisplayLore(@NotNull Player player, @NotNull RRank rank, @NotNull RankStatus status, boolean previewMode) {
        ArrayList<Component> lore = new ArrayList<Component>();
        try {
            lore.addAll(this.i18n(rank.getDescriptionKey(), player).build().children());
            lore.add((Component)Component.empty());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to extract localized rank description", exception);
            lore.add((Component)this.i18n("rank.fallback_description", player).withPlaceholder("rank_id", rank.getIdentifier()).build().component());
            lore.add((Component)Component.empty());
        }
        lore.add(this.createStatusComponent(status, player));
        if (!previewMode) {
            lore.add((Component)Component.empty());
            this.addClickInstructions(lore, status, player);
        }
        if (previewMode) {
            lore.add((Component)Component.empty());
            lore.addAll(this.i18n("preview_mode.lore", player).build().children());
        }
        return lore;
    }

    @NotNull
    private Component createStatusComponent(@NotNull RankStatus status, @NotNull Player player) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Component)this.i18n("status.owned", player).build().component();
            case 1 -> (Component)this.i18n("status.available", player).build().component();
            case 2 -> (Component)this.i18n("status.in_progress", player).build().component();
            case 3 -> (Component)this.i18n("status.locked", player).build().component();
            case 4 -> (Component)this.i18n("status.free_version_locked", player).build().component();
        };
    }

    private void addClickInstructions(@NotNull List<Component> lore, @NotNull RankStatus status, @NotNull Player player) {
        switch (status.ordinal()) {
            case 1: {
                lore.add((Component)this.i18n("click.left_start", player).build().component());
                lore.add((Component)this.i18n("click.right_requirements", player).build().component());
                break;
            }
            case 2: {
                lore.add((Component)this.i18n("click.left_redeem", player).build().component());
                lore.add((Component)this.i18n("click.right_progress", player).build().component());
            }
        }
    }

    private void renderFallbackGrid(@NotNull RenderContext renderContext, @NotNull Player player, @NotNull RRankTree rankTree) {
        try {
            ArrayList<RRank> ranks = new ArrayList<RRank>(rankTree.getRanks());
            ranks.sort(Comparator.comparingInt(RRank::getTier));
            List<Integer> centerSlots = List.of(Integer.valueOf(22), Integer.valueOf(21), Integer.valueOf(23), Integer.valueOf(13), Integer.valueOf(31));
            for (int i = 0; i < Math.min(ranks.size(), centerSlots.size()); ++i) {
                RRank rank = (RRank)ranks.get(i);
                ItemStack item = UnifiedBuilderFactory.item(Material.STONE).setName((Component)this.i18n("fallback.rank", player).withPlaceholder("rank_id", rank.getIdentifier()).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
                ((BukkitItemComponentBuilder)renderContext.slot(centerSlots.get(i).intValue())).renderWith(() -> item);
            }
            for (Integer slot : ALL_RANK_SLOT_NUMBERS) {
                if (centerSlots.subList(0, Math.min(ranks.size(), centerSlots.size())).contains(slot)) continue;
                ((BukkitItemComponentBuilder)renderContext.slot(slot.intValue())).renderWith(() -> this.createBackgroundPane(player));
            }
            LOGGER.log(Level.INFO, "Rendered fallback grid with " + Math.min(ranks.size(), centerSlots.size()) + " ranks");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Fallback grid rendering failed", exception);
        }
    }

    private void renderErrorState(@NotNull RenderContext renderContext, @NotNull Player player) {
        try {
            ItemStack errorItem = UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("error.no_rank_tree", player).build().component()).setLore(this.i18n("error.no_rank_tree_lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            ((BukkitItemComponentBuilder)renderContext.slot(22)).renderWith(() -> errorItem);
            for (Integer slot : ALL_RANK_SLOT_NUMBERS) {
                if (slot == 22) continue;
                ((BukkitItemComponentBuilder)renderContext.slot(slot.intValue())).renderWith(() -> this.createBackgroundPane(player));
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render error state", exception);
        }
    }

    private void renderCriticalErrorState(@NotNull RenderContext renderContext, @NotNull Player player) {
        try {
            ItemStack errorItem = UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("error.critical", player).build().component()).setLore(this.i18n("error.critical.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            ((BukkitItemComponentBuilder)renderContext.slot(22)).renderWith(() -> errorItem);
            for (Integer slot : ALL_RANK_SLOT_NUMBERS) {
                if (slot == 22) continue;
                ((BukkitItemComponentBuilder)renderContext.slot(slot.intValue())).renderWith(() -> this.createBackgroundPane(player));
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Critical error state rendering failed", exception);
        }
    }

    @NotNull
    private static Map<GridPosition, Integer> createRankSlotMapping() {
        HashMap<GridPosition, Integer> mapping = new HashMap<GridPosition, Integer>();
        mapping.put(new GridPosition(0, 0), 1);
        mapping.put(new GridPosition(1, 0), 2);
        mapping.put(new GridPosition(2, 0), 3);
        mapping.put(new GridPosition(3, 0), 5);
        mapping.put(new GridPosition(4, 0), 6);
        mapping.put(new GridPosition(5, 0), 7);
        mapping.put(new GridPosition(0, 1), 10);
        mapping.put(new GridPosition(1, 1), 11);
        mapping.put(new GridPosition(2, 1), 12);
        mapping.put(new GridPosition(3, 1), 13);
        mapping.put(new GridPosition(4, 1), 14);
        mapping.put(new GridPosition(5, 1), 15);
        mapping.put(new GridPosition(6, 1), 16);
        mapping.put(new GridPosition(0, 2), 19);
        mapping.put(new GridPosition(1, 2), 20);
        mapping.put(new GridPosition(2, 2), 21);
        mapping.put(new GridPosition(3, 2), 22);
        mapping.put(new GridPosition(4, 2), 23);
        mapping.put(new GridPosition(5, 2), 24);
        mapping.put(new GridPosition(6, 2), 25);
        mapping.put(new GridPosition(0, 3), 28);
        mapping.put(new GridPosition(1, 3), 29);
        mapping.put(new GridPosition(2, 3), 30);
        mapping.put(new GridPosition(3, 3), 31);
        mapping.put(new GridPosition(4, 3), 32);
        mapping.put(new GridPosition(5, 3), 33);
        mapping.put(new GridPosition(6, 3), 34);
        mapping.put(new GridPosition(0, 4), 37);
        mapping.put(new GridPosition(1, 4), 38);
        mapping.put(new GridPosition(2, 4), 39);
        mapping.put(new GridPosition(3, 4), 40);
        mapping.put(new GridPosition(4, 4), 41);
        mapping.put(new GridPosition(5, 4), 42);
        mapping.put(new GridPosition(6, 4), 43);
        return mapping;
    }

    @NotNull
    private static List<Integer> createAllRankSlotNumbers() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.addAll(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
        slots.addAll(List.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(15), Integer.valueOf(16)));
        slots.addAll(List.of(Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(25)));
        slots.addAll(List.of(Integer.valueOf(28), Integer.valueOf(29), Integer.valueOf(30), Integer.valueOf(31), Integer.valueOf(32), Integer.valueOf(33), Integer.valueOf(34)));
        slots.addAll(List.of(Integer.valueOf(37), Integer.valueOf(38), Integer.valueOf(39), Integer.valueOf(40), Integer.valueOf(41), Integer.valueOf(42), Integer.valueOf(43)));
        return slots;
    }

    private static class RankNode {
        public final RRank rank;
        public final List<RankNode> children = new ArrayList<RankNode>();
        public final List<RankNode> parents = new ArrayList<RankNode>();

        public RankNode(@NotNull RRank rank) {
            this.rank = rank;
        }
    }

    private static enum RankStatus {
        OWNED,
        AVAILABLE,
        IN_PROGRESS,
        LOCKED,
        FREE_VERSION_LOCKED;

    }

    private static class GridPosition {
        public final int x;
        public final int y;

        public GridPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GridPosition that = (GridPosition)obj;
            return this.x == that.x && this.y == that.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        public String toString() {
            return "GridPosition{x=" + this.x + ", y=" + this.y + "}";
        }
    }
}

