/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.bounty;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import com.raindropcentral.rdq.view.bounty.BountyCreationView;
import com.raindropcentral.rplatform.utility.heads.view.Proceed;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.APaginatedView;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.CloseContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BountyRewardView
extends APaginatedView<BountyReward> {
    private final State<RDQ> rdq = this.initialState("plugin");
    private final MutableState<Optional<OfflinePlayer>> target = this.initialState("target");
    private final MutableState<List<BountyReward>> rewards = this.initialState("rewards");
    private final State<Optional<Bounty>> bounty = this.initialState("bounty");
    private final State<Map<UUID, Map<Integer, ItemStack>>> insertedItems = this.initialState("insertedItems");
    private boolean isReturning;

    public BountyRewardView() {
        super(BountyCreationView.class);
    }

    @Override
    protected String getKey() {
        return "bounty_reward_ui";
    }

    @Override
    protected String[] getLayout() {
        return new String[]{"    t    ", "< OOOOO >", "         ", " xxxxxxx ", "         ", "b       c"};
    }

    @Override
    protected CompletableFuture<List<BountyReward>> getAsyncPaginationSource(@NotNull Context context) {
        if (((Optional)this.bounty.get((StateValueHost)context)).isEmpty() || ((Bounty)((Optional)this.bounty.get((StateValueHost)context)).get()).getRewards().isEmpty()) {
            BountyReward pseudoItem = new BountyReward(new ItemReward(this.buildPane(Material.GRAY_STAINED_GLASS_PANE, context.getPlayer(), "pseudo.name", "pseudo.lore"), 0.0), UUID.randomUUID());
            return CompletableFuture.completedFuture(List.of(pseudoItem, pseudoItem, pseudoItem, pseudoItem, pseudoItem));
        }
        return CompletableFuture.completedFuture(((Bounty)((Optional)this.bounty.get((StateValueHost)context)).get()).getRewards().stream().filter(bountyReward -> bountyReward.getReward().getType().equals((Object)Reward.Type.ITEM)).toList());
    }

    @Override
    protected void renderEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull BountyReward bountyReward) {
        ItemReward itemReward = (ItemReward)bountyReward.getReward();
        if (((Optional)this.bounty.get((StateValueHost)context)).isEmpty()) {
            builder.renderWith(() -> UnifiedBuilderFactory.item(itemReward.getItem()).build()).updateOnStateChange(this.bounty);
            return;
        }
        this.splitToMaxStacks(itemReward).forEach(item -> builder.renderWith(() -> UnifiedBuilderFactory.item(item.clone()).setName(item.clone().displayName()).setLore(this.i18n("reward_item.lore", context.getPlayer()).build().children()).addLoreLines(item.lore() == null ? new ArrayList() : Objects.requireNonNull(item.lore())).build()).updateOnStateChange(this.bounty));
    }

    @Override
    protected void onPaginatedRender(@NotNull RenderContext render, @NotNull Player player) {
        OfflinePlayer target = ((Optional)this.target.get((StateValueHost)render)).orElse(null);
        render.layoutSlot('x', this.buildPane(Material.GREEN_STAINED_GLASS_PANE, player, "input_slot.name", "input_slot.lore")).onClick(this::handleSlotClick);
        if (((Map)this.insertedItems.get((StateValueHost)render)).containsKey(player.getUniqueId()) && !((Map)((Map)this.insertedItems.get((StateValueHost)render)).get(player.getUniqueId())).isEmpty()) {
            ((Map)((Map)this.insertedItems.get((StateValueHost)render)).get(player.getUniqueId())).forEach((slot, item) -> render.slot(slot.intValue(), item).onClick(this::handleSlotClick));
        }
        render.layoutSlot('t', UnifiedBuilderFactory.unifiedHead(target.getPlayer()).setDisplayName((Component)this.i18n("target.name", player).withPlaceholder("target_name", target.getName() == null ? "" : target.getName()).build().component()).setLore(this.i18n("target.lore", player).withPlaceholders(Map.of("target_name", target.getName() == null ? "" : target.getName())).build().children()).build());
        ((BukkitItemComponentBuilder)render.layoutSlot('c', new Proceed().getHead(player)).updateOnStateChange(this.insertedItems)).onClick(clickContext -> {
            Map playerSlots = (Map)((Map)this.insertedItems.get((StateValueHost)render)).get(player.getUniqueId());
            if (playerSlots != null && !playerSlots.isEmpty()) {
                ArrayList<BountyReward> newRewards = new ArrayList<BountyReward>();
                for (ItemStack stack : playerSlots.values()) {
                    ItemStack template = stack.clone();
                    int originalAmount = template.getAmount();
                    template.setAmount(1);
                    ItemReward itemReward = new ItemReward(template, originalAmount);
                    itemReward.setAmount(originalAmount);
                    newRewards.add(new BountyReward(itemReward, player.getUniqueId()));
                }
                ((List)this.rewards.get((StateValueHost)clickContext)).clear();
                ((List)this.rewards.get((StateValueHost)clickContext)).addAll(newRewards);
                this.isReturning = true;
                clickContext.openForPlayer(BountyCreationView.class, Map.of("plugin", this.rdq.get((StateValueHost)clickContext), "target", this.target.get((StateValueHost)render), "rewards", this.rewards.get((StateValueHost)clickContext), "bounty", this.bounty.get((StateValueHost)clickContext), "insertedItems", this.insertedItems.get((StateValueHost)clickContext)));
            } else {
                this.i18n("no_new_items_inserted", player).includePrefix().build().sendMessage();
            }
        });
    }

    public void onClick(@NotNull SlotClickContext click) {
        if (click.isShiftClick() && click.getClickedContainer().isEntityContainer()) {
            this.handleShiftClick(click);
            return;
        }
        if (!click.isShiftClick() && click.getClickedContainer().isEntityContainer()) {
            click.setCancelled(false);
        }
    }

    public void onClose(@NotNull CloseContext close) {
        if (this.isReturning) {
            return;
        }
        if (((Map)this.insertedItems.get((StateValueHost)close)).containsKey(close.getPlayer().getUniqueId())) {
            this.refundInsertedItems(close.getPlayer(), ((Map)((Map)this.insertedItems.get((StateValueHost)close)).get(close.getPlayer().getUniqueId())).values());
            ((Map)this.insertedItems.get((StateValueHost)close)).remove(close.getPlayer().getUniqueId());
        }
        ((RDQ)this.rdq.get((StateValueHost)close)).getViewFrame().open(BountyCreationView.class, close.getPlayer(), Map.of("plugin", this.rdq.get((StateValueHost)close), "target", this.target.get((StateValueHost)close), "rewards", this.rewards.get((StateValueHost)close), "bounty", this.bounty.get((StateValueHost)close), "insertedItems", this.insertedItems.get((StateValueHost)close)));
    }

    private void handleSlotClick(@NotNull SlotClickContext clickContext) {
        ItemStack cursorItem = clickContext.getClickOrigin().getCursor();
        int clickedSlot = clickContext.getClickedSlot();
        ItemStack currentSlotItem = clickContext.getClickOrigin().getCurrentItem();
        boolean isSlotEmptyOrGreenPane = currentSlotItem == null || currentSlotItem.getType() == Material.AIR || currentSlotItem.getType() == Material.GREEN_STAINED_GLASS_PANE;
        Map playerSlots = ((Map)this.insertedItems.get((StateValueHost)clickContext)).computeIfAbsent(clickContext.getPlayer().getUniqueId(), k -> new HashMap());
        if (clickContext.getClickedContainer().isEntityContainer() && clickContext.isShiftClick()) {
            clickContext.setCancelled(true);
            return;
        }
        if (clickContext.isLeftClick()) {
            if (isSlotEmptyOrGreenPane && cursorItem.getType() != Material.AIR) {
                clickContext.getClickOrigin().setCursor(null);
                playerSlots.put(clickedSlot, cursorItem.clone());
                clickContext.getClickedContainer().renderItem(clickedSlot, (Object)cursorItem);
            }
            return;
        }
        if (clickContext.isRightClick() && !isSlotEmptyOrGreenPane && currentSlotItem.getType() != Material.AIR) {
            ItemStack removed = (ItemStack)playerSlots.remove(clickedSlot);
            if (removed != null) {
                this.refundInsertedItems(clickContext.getPlayer(), List.of(removed));
            }
            clickContext.getClickedContainer().renderItem(clickedSlot, (Object)this.buildPane(Material.GREEN_STAINED_GLASS_PANE, clickContext.getPlayer(), "input_slot.name", "input_slot.lore"));
        }
    }

    private void handleShiftClick(@NotNull SlotClickContext click) {
        Inventory guiInv;
        int targetSlot;
        Player player = click.getPlayer();
        ItemStack clickedItem = click.getClickOrigin().getCurrentItem();
        if (clickedItem != null && clickedItem.getType() != Material.AIR && (targetSlot = this.findFirstPaneSlot(guiInv = player.getOpenInventory().getTopInventory(), Set.of(Material.LIME_STAINED_GLASS_PANE, Material.GREEN_STAINED_GLASS_PANE))) != -1) {
            player.getInventory().removeItem(new ItemStack[]{clickedItem});
            guiInv.setItem(targetSlot, clickedItem.clone());
            ((Map)this.insertedItems.get((StateValueHost)click)).computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(targetSlot, clickedItem.clone());
            click.setCancelled(true);
            return;
        }
        click.setCancelled(true);
    }

    private int findFirstPaneSlot(@NotNull Inventory inv, @NotNull Set<Material> paneTypes) {
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack slotItem = inv.getItem(i);
            if (slotItem == null || !paneTypes.contains(slotItem.getType())) continue;
            return i;
        }
        return -1;
    }

    private ItemStack buildPane(@NotNull Material paneType, @NotNull Player player, @NotNull String nameKey, @NotNull String loreKey) {
        return UnifiedBuilderFactory.item(paneType).setName((Component)new I18n.Builder(nameKey, player).build().component()).setLore(new I18n.Builder(loreKey, player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private List<ItemStack> splitToMaxStacks(@NotNull ItemReward rewardItem) {
        int stackAmount;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack base = rewardItem.getItem();
        int maxStack = base.getMaxStackSize();
        for (int total = rewardItem.getAmount().intValue(); total > 0; total -= stackAmount) {
            stackAmount = Math.min(total, maxStack);
            ItemStack stack = base.clone();
            stack.setAmount(stackAmount);
            result.add(stack);
        }
        return result;
    }

    private void refundInsertedItems(@NotNull Player player, @NotNull Collection<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        player.getInventory().addItem(items.toArray(new ItemStack[0])).forEach((i, item) -> player.getWorld().dropItem(player.getLocation().clone().add(0.0, 0.5, 0.0), item));
        this.i18n("left_overs", player).includePrefix().build().sendMessage();
    }
}

