/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.bounty;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.view.bounty.BountyMainView;
import com.raindropcentral.rdq.view.bounty.BountyOverviewView;
import com.raindropcentral.rdq.view.bounty.BountyRewardView;
import com.raindropcentral.rplatform.utility.heads.view.Cancel;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import com.raindropcentral.rplatform.view.ConfirmationView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BountyPlayerInfoView
extends BaseView {
    private final State<RDQ> rdq = this.initialState("plugin");
    private final MutableState<Optional<OfflinePlayer>> target = this.initialState("target");
    private final MutableState<List<BountyReward>> rewards = this.initialState("rewards");
    private final State<Optional<Bounty>> bounty = this.initialState("bounty");
    private final State<Map<UUID, Map<Integer, ItemStack>>> insertedItems = this.initialState("insertedItems");

    public BountyPlayerInfoView() {
        super(BountyOverviewView.class);
    }

    @Override
    protected String[] getLayout() {
        return new String[]{"  P   R  ", "       D "};
    }

    @Override
    protected int getSize() {
        return 2;
    }

    @Override
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext open) {
        Optional bountyOpt = (Optional)this.bounty.get((StateValueHost)open);
        if (bountyOpt.isEmpty()) {
            return Map.of("target_name", "Unknown");
        }
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((UUID)((Bounty)bountyOpt.get()).getTargetUniqueId());
        String targetName = targetPlayer.getName() != null ? targetPlayer.getName() : "Unknown";
        return Map.of("target_name", targetName);
    }

    @Override
    protected String getKey() {
        return "bounty_player_info_ui";
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        this.renderTargetHead(render, player);
        this.renderRewardsButton(render, player);
        this.renderDeleteButton(render, player);
    }

    private void renderTargetHead(@NotNull RenderContext render, @NotNull Player player) {
        Optional targetOpt = (Optional)this.target.get((StateValueHost)render);
        if (targetOpt.isEmpty()) {
            return;
        }
        OfflinePlayer targetPlayer = (OfflinePlayer)targetOpt.get();
        String targetName = targetPlayer.getName() != null ? targetPlayer.getName() : "Unknown";
        render.layoutSlot('P', UnifiedBuilderFactory.unifiedHead(targetPlayer).setDisplayName((Component)this.i18n("target.name", player).withPlaceholder("target_name", targetName).build().component()).setLore(List.of(Component.empty(), (Component)this.i18n("target.coming_soon", player).build().component())).build());
    }

    private void renderRewardsButton(@NotNull RenderContext render, @NotNull Player player) {
        Optional bountyOpt = (Optional)this.bounty.get((StateValueHost)render);
        int rewardCount = bountyOpt.map(b -> b.getRewards().size()).orElse(0);
        render.layoutSlot('R', UnifiedBuilderFactory.item(Material.CHEST).setName((Component)this.i18n("rewards.name", player).build().component()).setLore(this.i18n("rewards.lore", player).withPlaceholder("reward_count", String.valueOf(rewardCount)).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build()).onClick(ctx -> {
            Optional b = (Optional)this.bounty.get((StateValueHost)ctx);
            if (b.isEmpty()) {
                return;
            }
            ctx.openForPlayer(BountyRewardView.class, Map.of("plugin", this.rdq.get((StateValueHost)ctx), "target", this.target.get((StateValueHost)ctx), "rewards", ((Bounty)b.get()).getRewards(), "bounty", b, "insertedItems", new HashMap()));
        });
    }

    private void renderDeleteButton(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)render.layoutSlot('D', UnifiedBuilderFactory.item(new Cancel().getHead(player)).setName((Component)this.i18n("delete.name", player).build().component()).setLore(this.i18n("delete.lore", player).build().children()).build()).displayIf(ctx -> ctx.getPlayer().isOp())).onClick(ctx -> {
            Optional b = (Optional)this.bounty.get((StateValueHost)ctx);
            if (b.isEmpty()) {
                return;
            }
            new ConfirmationView.Builder().withKey("bounty_player_info_ui").withMessageKey("bounty_player_info_ui.confirm.message").withInitialData(Map.of("plugin", this.rdq.get((StateValueHost)ctx), "target", this.target.get((StateValueHost)render), "rewards", new ArrayList(), "bounty", b, "insertedItems", new HashMap())).withCallback(confirmed -> {
                if (confirmed.booleanValue()) {
                    ((RDQ)this.rdq.get((StateValueHost)ctx)).getBountyFactory().deleteBounty((Bounty)b.get());
                    player.closeInventory();
                }
            }).withParentView(BountyPlayerInfoView.class).openFor((Context)ctx, player);
        });
    }

    @Override
    public void onResume(@NotNull Context origin, @NotNull Context target) {
        Map initialData = (Map)target.getInitialData();
        if (initialData == null || !Boolean.TRUE.equals(initialData.get("confirmed"))) {
            return;
        }
        Optional bountyOpt = (Optional)initialData.get("bounty");
        if (bountyOpt == null || bountyOpt.isEmpty()) {
            return;
        }
        Optional targetPlayer = (Optional)initialData.get("target");
        RDQ rdqPlugin = (RDQ)initialData.get("plugin");
        UUID commissionerUniqueId = ((Bounty)bountyOpt.get()).getCommissionerUniqueId();
        CompletableFuture.supplyAsync(() -> rdqPlugin.getPlayerRepository().findByAttributes(Map.of("uniqueId", commissionerUniqueId)).orElse(null), rdqPlugin.getExecutor()).thenCompose(rdqPlayer -> {
            if (rdqPlayer == null) {
                return null;
            }
            rdqPlugin.getPlayerRepository().updateAsync(rdqPlayer).thenAcceptAsync(p -> rdqPlugin.getBountyRepository().deleteAsync(((Bounty)bountyOpt.get()).getId()).thenAccept(v -> {
                if (targetPlayer != null && targetPlayer.isPresent()) {
                    rdqPlugin.getVisualIndicatorManager().removeIndicators(((OfflinePlayer)targetPlayer.get()).getUniqueId());
                }
                String targetName = targetPlayer != null && targetPlayer.isPresent() && ((OfflinePlayer)targetPlayer.get()).getName() != null ? ((OfflinePlayer)targetPlayer.get()).getName() : "Unknown";
                this.i18n("deleted_bounty_successfully", origin.getPlayer()).includePrefix().withPlaceholders(Map.of("bounty_id", ((Bounty)bountyOpt.get()).getId(), "target_name", targetName)).build().sendMessage();
            }), (Executor)rdqPlugin.getExecutor());
            return null;
        });
        target.openForPlayer(BountyMainView.class, Map.of("plugin", rdqPlugin, "target", targetPlayer, "rewards", this.rewards, "bounty", this.bounty.get((StateValueHost)target), "insertedItems", this.insertedItems));
    }
}

