/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.bounty;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.view.bounty.BountyMainView;
import com.raindropcentral.rdq.view.bounty.BountyPlayerInfoView;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.APaginatedView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BountyOverviewView
extends APaginatedView<Bounty> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm");
    private final State<RDQ> rdq = this.initialState("plugin");

    public BountyOverviewView() {
        super(BountyMainView.class);
    }

    @Override
    protected String getKey() {
        return "bounty_overview_ui";
    }

    @Override
    @NotNull
    protected String[] getLayout() {
        return new String[]{" OOOOOOO ", " OOOOOOO ", "   <p>   "};
    }

    @Override
    protected CompletableFuture<List<Bounty>> getAsyncPaginationSource(@NotNull Context context) {
        return ((RDQ)this.rdq.get((StateValueHost)context)).getBountyRepository().findAllByAttributesAsync(Map.of("active", true));
    }

    @Override
    protected void renderEntry(@NotNull Context context, @NotNull BukkitItemComponentBuilder builder, int index, @NotNull Bounty bounty) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)bounty.getTargetUniqueId());
        OfflinePlayer commissioner = Bukkit.getOfflinePlayer((UUID)bounty.getCommissionerUniqueId());
        Player player = context.getPlayer();
        String targetName = target.getName() != null ? target.getName() : "Unknown";
        String commissionerName = commissioner.getName() != null ? commissioner.getName() : "Unknown";
        String createdAt = bounty.getCreatedAt() != null ? bounty.getCreatedAt().format(DATE_FORMAT) : "Unknown";
        builder.withItem(UnifiedBuilderFactory.unifiedHead(target).setDisplayName((Component)this.i18n("bounty.name", player).withPlaceholder("target_name", targetName).build().component()).setLore(this.i18n("bounty.lore", player).withPlaceholders(Map.of("target_name", targetName, "commissioner_name", commissionerName, "created_at", createdAt)).build().children()).build()).onClick(ctx -> ctx.openForPlayer(BountyPlayerInfoView.class, Map.of("plugin", this.rdq.get((StateValueHost)ctx), "bounty", Optional.of(bounty), "target", Optional.of(target), "rewards", bounty.getRewards(), "insertedItems", new HashMap())));
    }

    @Override
    protected void onPaginatedRender(@NotNull RenderContext render, @NotNull Player player) {
    }
}

