/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.bounty;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import com.raindropcentral.rdq.database.entity.bounty.BountyReward;
import com.raindropcentral.rdq.reward.ItemReward;
import com.raindropcentral.rdq.reward.Reward;
import com.raindropcentral.rdq.view.bounty.BountyPlayerInfoView;
import com.raindropcentral.rdq.view.bounty.BountyRewardView;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import com.raindropcentral.rplatform.view.PaginatedPlayerView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.CloseContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyCreationView
extends BaseView {
    private static final Logger LOGGER = Logger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final MutableState<Optional<OfflinePlayer>> target = this.initialState("target");
    private final MutableState<List<BountyReward>> rewards = this.initialState("rewards");
    private final State<Optional<Bounty>> bounty = this.initialState("bounty");
    private final State<Map<UUID, Map<Integer, ItemStack>>> insertedItems = this.initialState("insertedItems");
    private boolean isReopening;
    private final State<ItemStack> targetSelectorButton = this.computedState(context -> {
        Player player = context.getPlayer();
        Optional targetPlayer = (Optional)this.target.get((StateValueHost)context);
        String targetName = targetPlayer.map(OfflinePlayer::getName).orElse("");
        return UnifiedBuilderFactory.unifiedHead(targetPlayer.orElse(null)).setDisplayName((Component)this.i18n("select_target.name", player).withPlaceholder("target_name", targetName).build().component()).setLore(this.i18n("select_target.lore", player).withPlaceholder("target_name", targetName).build().children()).build();
    });
    private final State<ItemStack> itemAdderButton = this.computedState(context -> {
        Player player = context.getPlayer();
        boolean enabled = ((Optional)this.target.get((StateValueHost)context)).isPresent();
        List<Object> bountyRewards = new ArrayList((Collection)this.rewards.get((StateValueHost)context));
        bountyRewards = bountyRewards.stream().filter(bountyReward -> bountyReward.getReward().getType().equals((Object)Reward.Type.ITEM)).toList();
        return UnifiedBuilderFactory.item(enabled ? Material.CHEST : Material.BARRIER).setName((Component)this.i18n("add_items." + (enabled ? "name" : "name_disabled"), player).build().component()).setLore(this.i18n("add_items." + (enabled ? "description" : "description_disabled"), player).withPlaceholder("count", bountyRewards.size()).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    });
    private final State<ItemStack> currencyAdderButton = this.computedState(context -> {
        Player player = context.getPlayer();
        boolean enabled = ((Optional)this.target.get((StateValueHost)context)).isPresent();
        List<Object> bountyRewards = new ArrayList((Collection)this.rewards.get((StateValueHost)context));
        bountyRewards = bountyRewards.stream().filter(bountyReward -> bountyReward.getReward().getType().equals((Object)Reward.Type.CURRENCY)).toList();
        return UnifiedBuilderFactory.item(enabled ? Material.GOLD_INGOT : Material.BARRIER).setName((Component)this.i18n("add_currency." + (enabled ? "name" : "name_disabled"), player).build().component()).setLore(this.i18n("add_currency." + (enabled ? "description" : "description_disabled"), player).withPlaceholder("count", bountyRewards.size()).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    });
    private final State<ItemStack> confirmButton = this.computedState(context -> {
        Player player = context.getPlayer();
        boolean canConfirm = ((Optional)this.target.get((StateValueHost)context)).isPresent() && !((List)this.rewards.get((StateValueHost)context)).isEmpty();
        return UnifiedBuilderFactory.item(canConfirm ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK).setName((Component)this.i18n("confirm_bounty.name", player).build().component()).setLore(this.i18n("confirm_bounty.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    });

    @Override
    protected int getSize() {
        return 5;
    }

    @Override
    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext open) {
        return Map.of("target_name", ((Optional)this.target.get((StateValueHost)open)).map(OfflinePlayer::getName).orElse("not_defined"));
    }

    @Override
    protected String getKey() {
        return "bounty_creation_ui";
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(11)).watch(new State[]{this.targetSelectorButton})).renderWith(() -> (ItemStack)this.targetSelectorButton.get((StateValueHost)render)).onClick(context -> {
            this.isReopening = true;
            context.openForPlayer(PaginatedPlayerView.class, Map.of("titleKey", "bounty_creation_ui.select_target.title", "parentClazz", ((Object)((Object)this)).getClass(), "initialData", context.getInitialData()));
        });
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(13, (ItemStack)this.itemAdderButton.get((StateValueHost)render)).watch(new State[]{this.itemAdderButton})).renderWith(() -> (ItemStack)this.itemAdderButton.get((StateValueHost)render)).updateOnStateChange(this.itemAdderButton)).displayIf(() -> ((Optional)this.target.get((StateValueHost)render)).isPresent())).onClick(context -> {
            if (((Optional)this.target.get((StateValueHost)context)).isEmpty()) {
                this.i18n("add_items.disabled", player).includePrefix().build().sendMessage();
                return;
            }
            this.isReopening = true;
            if (((Optional)this.bounty.get((StateValueHost)context)).isPresent()) {
                context.openForPlayer(BountyPlayerInfoView.class, Map.of("plugin", this.rdq.get((StateValueHost)context), "bounty", this.bounty.get((StateValueHost)context), "target", this.target.get((StateValueHost)context), "rewards", this.rewards.get((StateValueHost)context), "insertedItems", this.insertedItems.get((StateValueHost)context)));
                return;
            }
            Optional foundBounty = ((RDQ)this.rdq.get((StateValueHost)context)).getBountyRepository().findByAttributes(Map.of("targetUniqueId", ((OfflinePlayer)((Optional)this.target.get((StateValueHost)context)).get()).getUniqueId()));
            if (foundBounty.isPresent()) {
                context.openForPlayer(BountyPlayerInfoView.class, Map.of("plugin", this.rdq.get((StateValueHost)context), "bounty", foundBounty, "target", this.target.get((StateValueHost)context), "rewards", this.rewards.get((StateValueHost)context), "insertedItems", this.insertedItems.get((StateValueHost)context)));
            } else {
                context.openForPlayer(BountyRewardView.class, Map.of("plugin", this.rdq.get((StateValueHost)context), "bounty", this.bounty.get((StateValueHost)context), "target", this.target.get((StateValueHost)context), "rewards", this.rewards.get((StateValueHost)context), "insertedItems", this.insertedItems.get((StateValueHost)context)));
            }
        });
        ((BukkitItemComponentBuilder)render.slot(15, (ItemStack)this.currencyAdderButton.get((StateValueHost)render)).watch(new State[]{this.currencyAdderButton})).renderWith(() -> (ItemStack)this.currencyAdderButton.get((StateValueHost)render)).displayIf(() -> ((Optional)this.target.get((StateValueHost)render)).isPresent());
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(31)).watch(new State[]{this.confirmButton})).renderWith(() -> (ItemStack)this.confirmButton.get((StateValueHost)render)).displayIf(() -> ((Optional)this.target.get((StateValueHost)render)).isPresent() && !((List)this.rewards.get((StateValueHost)render)).isEmpty())).onClick(clickContext -> {
            if (((Optional)this.target.get((StateValueHost)clickContext)).isEmpty()) {
                this.i18n("confirm.no_player_selected", player).includePrefix().build().sendMessage();
                return;
            }
            if (((List)this.rewards.get((StateValueHost)clickContext)).isEmpty()) {
                this.i18n("confirm.no_rewards_selected", player).includePrefix().build().sendMessage();
                return;
            }
            this.i18n("confirm.confirmation", player).includePrefix().withPlaceholder("target_name", ((Optional)this.target.get((StateValueHost)clickContext)).map(OfflinePlayer::getName).orElse("not_defined")).build().sendMessage();
            RDQ rdq = (RDQ)this.rdq.get((StateValueHost)clickContext);
            Optional target = (Optional)this.target.get((StateValueHost)clickContext);
            if (target.isEmpty()) {
                this.i18n("confirm.error", player).includePrefix().withPlaceholder("target_name", "not_defined").build().sendMessage();
                return;
            }
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> rdq.getBountyRepository().findByAttributes(Map.of("targetUniqueId", ((OfflinePlayer)target.get()).getUniqueId())).orElse(null), rdq.getExecutor()).thenAcceptAsync(bounty -> {
                if (bounty != null) {
                    rdq.getPlatform().getScheduler().runSync(() -> {
                        LOGGER.info("=== BOUNTY UPDATE START ===");
                        LOGGER.info("Found existing bounty with " + bounty.getRewards().size() + " rewards");
                        LOGGER.info("UI rewards list has " + ((List)this.rewards.get((StateValueHost)clickContext)).size() + " rewards");
                        for (int i = 0; i < ((List)this.rewards.get((StateValueHost)clickContext)).size(); ++i) {
                            BountyReward reward = (BountyReward)((List)this.rewards.get((StateValueHost)clickContext)).get(i);
                            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
                            ItemReward itemReward = (ItemReward)reward.getReward();
                            LOGGER.info("UI reward [" + i + "] BEFORE merge: " + String.valueOf(itemReward.getItem().getType()) + " x" + itemReward.getAmount() + " (ItemStack: " + itemReward.getItem().getAmount() + ")");
                        }
                        LOGGER.info("About to call mergeSimilarRewardItems with " + ((List)this.rewards.get((StateValueHost)clickContext)).size() + " rewards");
                        List<BountyReward> newRewards = this.mergeSimilarRewardItems((List)this.rewards.get((StateValueHost)clickContext));
                        LOGGER.info("mergeSimilarRewardItems returned " + newRewards.size() + " rewards");
                        LOGGER.info("Updating existing bounty for " + ((OfflinePlayer)target.get()).getName() + " with " + newRewards.size() + " new rewards");
                        LOGGER.info("Current bounty has " + bounty.getRewards().size() + " existing rewards");
                        for (int i = 0; i < newRewards.size(); ++i) {
                            BountyReward reward = newRewards.get(i);
                            if (reward.getReward().getType() != Reward.Type.ITEM) continue;
                            ItemReward itemReward = (ItemReward)reward.getReward();
                            LOGGER.info("Sending to BountyFactory [" + i + "]: " + String.valueOf(itemReward.getItem().getType()) + " x" + itemReward.getAmount() + " (ItemStack amount: " + itemReward.getItem().getAmount() + ")");
                        }
                        this.i18n("bounty_creation.processing", player).includePrefix().build().sendMessage();
                        LOGGER.info("Calling addRewardsToBounty on BountyFactory...");
                        ((CompletableFuture)rdq.getBountyFactory().addRewardsToBounty(bounty.getTargetUniqueId(), newRewards).thenAccept(updatedBounty -> {
                            LOGGER.info("AddRewardsToBounty completed successfully for " + ((OfflinePlayer)target.get()).getName());
                            rdq.getPlatform().getScheduler().runSync(() -> {
                                LOGGER.info("Running success callback on main thread for " + player.getName());
                                Player targetPlayer = Bukkit.getPlayer((UUID)((OfflinePlayer)target.get()).getUniqueId());
                                if (targetPlayer != null && targetPlayer.isOnline()) {
                                    rdq.getVisualIndicatorManager().forceRefreshIndicators(targetPlayer);
                                    LOGGER.info("Refreshed visual indicators for " + targetPlayer.getName() + " after bounty update");
                                }
                                this.i18n("bounty_creation.confirm.success", player).includePrefix().withPlaceholder("target_name", target.map(OfflinePlayer::getName).orElse("not_defined")).build().sendMessage();
                                LOGGER.info("Sent success message to " + player.getName() + " for bounty update");
                            });
                        })).exceptionally(throwable -> {
                            LOGGER.log(Level.SEVERE, "Failed to add rewards to bounty for " + ((OfflinePlayer)target.get()).getName(), (Throwable)throwable);
                            rdq.getPlatform().getScheduler().runSync(() -> this.i18n("bounty_creation.confirm.error", player).includePrefix().withPlaceholder("error_message", "Failed to add rewards to bounty: " + throwable.getMessage()).build().sendMessage());
                            return null;
                        });
                    });
                } else {
                    ((CompletableFuture)rdq.getBountyFactory().createBounty(((OfflinePlayer)target.get()).getUniqueId(), player.getUniqueId(), this.mergeSimilarRewardItems((List)this.rewards.get((StateValueHost)clickContext))).thenAccept(createdBounty -> rdq.getPlatform().getScheduler().runSync(() -> {
                        Player targetPlayer = Bukkit.getPlayer((UUID)((OfflinePlayer)target.get()).getUniqueId());
                        if (targetPlayer != null && targetPlayer.isOnline()) {
                            rdq.getVisualIndicatorManager().applyIndicators(targetPlayer);
                            rdq.getVisualIndicatorManager().updatePlayerDisplay(targetPlayer);
                        }
                        this.i18n("bounty_creation.confirm.success", player).includePrefix().withPlaceholder("target_name", target.map(OfflinePlayer::getName).orElse("not_defined")).build().sendMessage();
                    }))).exceptionally(ex -> {
                        this.i18n("confirm.error", player).includePrefix().withPlaceholder("error_message", "Failed to create bounty: " + ex.getMessage()).build().sendMessage();
                        return null;
                    });
                    ((Map)this.insertedItems.get((StateValueHost)clickContext)).remove(clickContext.getPlayer().getUniqueId());
                    this.isReopening = false;
                }
                ((Map)this.insertedItems.get((StateValueHost)clickContext)).remove(clickContext.getPlayer().getUniqueId());
                this.isReopening = false;
            }, (Executor)rdq.getExecutor())).exceptionally(throwable -> {
                LOGGER.log(Level.WARNING, "Error occurred when trying to search for an existing bounty: " + throwable.getMessage());
                rdq.getPlatform().getScheduler().runSync(() -> ((SlotClickContext)clickContext).closeForPlayer());
                return null;
            });
        }).closeOnClick();
    }

    public void onClose(@NotNull CloseContext close) {
        if (this.isReopening) {
            return;
        }
        this.refundInsertedItems(close.getPlayer(), ((Map)this.insertedItems.get((StateValueHost)close)).containsKey(close.getPlayer().getUniqueId()) ? ((Map)((Map)this.insertedItems.get((StateValueHost)close)).get(close.getPlayer().getUniqueId())).values() : new ArrayList<ItemStack>());
    }

    private void refundInsertedItems(@NotNull Player player, @Nullable Collection<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        player.getInventory().addItem(items.toArray(new ItemStack[0])).forEach((i, item) -> player.getWorld().dropItem(player.getLocation().clone().add(0.0, 0.5, 0.0), item));
        this.i18n("left_overs", player).includePrefix().build().sendMessage();
    }

    private List<BountyReward> mergeSimilarRewardItems(@NotNull List<BountyReward> items) {
        LOGGER.info("[BountyCreationView] mergeSimilarRewardItems called with " + items.size() + " items");
        for (int i = 0; i < items.size(); ++i) {
            BountyReward item = items.get(i);
            if (item.getReward().getType() != Reward.Type.ITEM) continue;
            ItemReward itemReward = (ItemReward)item.getReward();
            LOGGER.info("[BountyCreationView] Input item " + i + ": " + String.valueOf(itemReward.getItem().getType()) + " x" + itemReward.getAmount());
        }
        ArrayList<BountyReward> merged = new ArrayList<BountyReward>();
        block1: for (BountyReward bountyReward : items) {
            if (!bountyReward.getReward().getType().equals((Object)Reward.Type.ITEM)) {
                merged.add(bountyReward);
                continue;
            }
            ItemReward currentItemReward = (ItemReward)bountyReward.getReward();
            ItemStack currentItem = currentItemReward.getItem();
            LOGGER.info("[BountyCreationView] Processing item: " + String.valueOf(currentItem.getType()) + " with ItemReward.getAmount()=" + currentItemReward.getAmount() + " and ItemStack.getAmount()=" + currentItem.getAmount());
            for (BountyReward existing : merged) {
                ItemReward existingItemReward;
                ItemStack existingItem;
                if (!existing.getReward().getType().equals((Object)Reward.Type.ITEM) || !(existingItem = (existingItemReward = (ItemReward)existing.getReward()).getItem()).isSimilar(currentItem)) continue;
                int existingAmount = existingItemReward.getAmount();
                int currentAmount = currentItemReward.getAmount();
                int totalAmount = existingAmount + currentAmount;
                LOGGER.info("[BountyCreationView] Merging in UI: " + existingAmount + " (existing) + " + currentAmount + " (current) = " + totalAmount);
                existingItemReward.setAmount(totalAmount);
                LOGGER.info("[BountyCreationView] Final UI merge amount: " + existingItemReward.getAmount());
                continue block1;
            }
            merged.add(bountyReward);
        }
        return new ArrayList<BountyReward>(merged);
    }
}

