/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.admin;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.view.admin.AdminOverviewView;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.heads.view.Next;
import com.raindropcentral.rplatform.utility.heads.view.Previous;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AdminPermissionsView
extends BaseView {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final State<RDQ> rdq = this.initialState("plugin");
    private final MutableState<String> selectedPlugin = this.mutableState(null);
    private final MutableState<Integer> pluginPage = this.mutableState(0);
    private final MutableState<Integer> permissionPage = this.mutableState(0);
    private final MutableState<Long> dataRefreshTimestamp = this.mutableState(System.currentTimeMillis());
    private final MutableState<List<String>> cachedPlugins = this.mutableState(new ArrayList());
    private final MutableState<Map<String, List<String>>> cachedPermissions = this.mutableState(Map.of());
    private static final int PLUGINS_PER_PAGE = 7;
    private static final int PERMISSIONS_PER_PAGE = 7;
    private static final int[] PLUGIN_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16};
    private static final int[] PERMISSION_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34};
    private static final int PLUGIN_PREV_SLOT = 9;
    private static final int PLUGIN_NEXT_SLOT = 17;
    private static final int PERM_PREV_SLOT = 27;
    private static final int PERM_NEXT_SLOT = 35;
    private static final int STATUS_INDICATOR_SLOT = 22;
    private static final int CLEAR_SELECTION_SLOT = 21;
    private static final int ASSIGN_SELECTED_SLOT = 23;
    private static final int REFRESH_DATA_SLOT = 49;
    private static final int ASSIGN_ALL_SLOT = 52;

    public AdminPermissionsView() {
        super(AdminOverviewView.class);
    }

    @Override
    protected String getKey() {
        return "admin_permissions_overview_ui";
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        try {
            LOGGER.log(Level.INFO, "Starting enhanced AdminPermissionsView render for player: " + player.getName());
            this.initializeData((Context)render);
            this.renderHeaderSection(render, player);
            this.renderPluginSection(render, player);
            this.renderActionBar(render, player);
            this.renderPermissionSection(render, player);
            this.renderControlBar(render, player);
            this.renderDecorations(render, player);
            LOGGER.log(Level.INFO, "Enhanced AdminPermissionsView rendered successfully for player: " + player.getName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render enhanced AdminPermissionsView", exception);
            this.renderErrorState(render, player);
        }
    }

    private void initializeData(@NotNull Context render) {
        try {
            Map<String, List<String>> permissionsMap = ((RDQ)this.rdq.get((StateValueHost)render)).getPermissionsService().getPermissions();
            this.cachedPermissions.set(permissionsMap, (StateValueHost)render);
            this.cachedPlugins.set(new ArrayList<String>(permissionsMap.keySet()), (StateValueHost)render);
            this.dataRefreshTimestamp.set((Object)System.currentTimeMillis(), (StateValueHost)render);
            LOGGER.log(Level.FINE, "Data initialization completed with " + permissionsMap.size() + " plugins");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to initialize data", exception);
            this.cachedPermissions.set(Map.of(), (StateValueHost)render);
            this.cachedPlugins.set(new ArrayList(), (StateValueHost)render);
        }
    }

    @NotNull
    private ItemStack createAssignSelectedItem(@NotNull RenderContext render, @NotNull Player player) {
        String selectedPlugin = (String)this.selectedPlugin.get((StateValueHost)render);
        if (selectedPlugin != null) {
            Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)render);
            int permissionCount = permissionsMap.getOrDefault(selectedPlugin, List.of()).size();
            return UnifiedBuilderFactory.item(Material.EMERALD).setName((Component)this.i18n("actions.assign_selected.name", player).withPlaceholder("plugin_name", selectedPlugin).build().component()).setLore(this.i18n("actions.assign_selected.lore", player).withPlaceholders(Map.of("plugin_name", selectedPlugin, "permission_count", permissionCount)).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        return UnifiedBuilderFactory.item(Material.GRAY_STAINED_GLASS_PANE).setName((Component)this.i18n("actions.no_selection.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void handleAssignSelectedClick(@NotNull SlotClickContext clickContext) {
        String selectedPlugin = (String)this.selectedPlugin.get((StateValueHost)clickContext);
        if (selectedPlugin != null) {
            Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)clickContext);
            List permissions = (List)permissionsMap.get(selectedPlugin);
            if (permissions != null && !permissions.isEmpty()) {
                if (!((RDQ)this.rdq.get((StateValueHost)clickContext)).getPermissionsService().addPermissionSet(clickContext.getPlayer(), selectedPlugin, selectedPlugin.toLowerCase(), permissions, true)) {
                    return;
                }
                this.i18n("feedback.permissions_assigned.plugin_all", clickContext.getPlayer()).withPlaceholders(Map.of("plugin_name", selectedPlugin, "permission_count", permissions.size())).includePrefix().build().sendMessage();
                LOGGER.log(Level.INFO, "Assigned " + permissions.size() + " permissions from " + selectedPlugin + " to player: " + clickContext.getPlayer().getName());
            } else {
                this.i18n("errors.no_permissions_available", clickContext.getPlayer()).includePrefix().build().sendMessage();
                LOGGER.log(Level.WARNING, "No permissions found for plugin: " + selectedPlugin);
            }
        } else {
            this.i18n("errors.plugin_not_found", clickContext.getPlayer()).withPlaceholder("plugin_name", "Unknown").includePrefix().build().sendMessage();
            LOGGER.log(Level.WARNING, "Attempted to assign permissions for null plugin selection");
        }
    }

    private void renderHeaderSection(@NotNull RenderContext render, @NotNull Player player) {
        for (int slot : new int[]{1, 2, 3, 4, 5, 6, 7}) {
            ((BukkitItemComponentBuilder)render.slot(slot)).renderWith(() -> this.createHeaderDecorationItem(player));
        }
    }

    private void renderPluginSection(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(9)).renderWith(() -> this.createNavigationItem(new Previous(), "plugins.navigation.previous", player)).updateOnStateChange(this.pluginPage, new State[]{this.cachedPlugins})).displayIf(() -> this.canNavigatePlugins(render, -1))).onClick(clickContext -> this.handlePluginPageChange((SlotClickContext)clickContext, -1));
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(17)).renderWith(() -> this.createNavigationItem(new Next(), "plugins.navigation.next", player)).updateOnStateChange(this.pluginPage, new State[]{this.cachedPlugins})).displayIf(() -> this.canNavigatePlugins(render, 1))).onClick(clickContext -> this.handlePluginPageChange((SlotClickContext)clickContext, 1));
        for (int i = 0; i < PLUGIN_SLOTS.length; ++i) {
            int slotIndex = i;
            int slotNumber = PLUGIN_SLOTS[i];
            ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(slotNumber)).renderWith(() -> this.createPluginSlotContent(render, slotIndex, player)).updateOnStateChange(this.selectedPlugin, new State[]{this.pluginPage, this.dataRefreshTimestamp})).onClick(clickContext -> this.handlePluginSlotClick((SlotClickContext)clickContext, slotIndex));
        }
    }

    private void renderActionBar(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)render.slot(22)).renderWith(() -> this.createStatusIndicatorItem(render, player)).updateOnStateChange(this.selectedPlugin, new State[]{this.cachedPlugins, this.cachedPermissions});
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(21)).renderWith(() -> this.createClearSelectionItem(player)).updateOnStateChange(this.selectedPlugin)).displayIf(() -> this.selectedPlugin.get((StateValueHost)render) != null)).onClick(this::handleClearSelection);
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(23)).renderWith(() -> this.createAssignSelectedItem(render, player)).updateOnStateChange(this.selectedPlugin, new State[]{this.cachedPermissions})).displayIf(() -> this.selectedPlugin.get((StateValueHost)render) != null)).onClick(this::handleAssignSelectedClick);
    }

    private void renderPermissionSection(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(27)).renderWith(() -> this.createNavigationItem(new Previous(), "permissions.navigation.previous", player)).updateOnStateChange(this.permissionPage, new State[]{this.selectedPlugin, this.cachedPermissions})).displayIf(() -> this.canNavigatePermissions(render, -1))).onClick(clickContext -> this.handlePermissionPageChange((SlotClickContext)clickContext, -1));
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(35)).renderWith(() -> this.createNavigationItem(new Next(), "permissions.navigation.next", player)).updateOnStateChange(this.permissionPage, new State[]{this.selectedPlugin, this.cachedPermissions})).displayIf(() -> this.canNavigatePermissions(render, 1))).onClick(clickContext -> this.handlePermissionPageChange((SlotClickContext)clickContext, 1));
        for (int i = 0; i < PERMISSION_SLOTS.length; ++i) {
            int slotIndex = i;
            int slotNumber = PERMISSION_SLOTS[i];
            ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(slotNumber)).renderWith(() -> this.createPermissionSlotContent(render, slotIndex, player)).updateOnStateChange(this.selectedPlugin, new State[]{this.permissionPage, this.dataRefreshTimestamp})).onClick(clickContext -> this.handlePermissionSlotClick((SlotClickContext)clickContext, slotIndex));
        }
    }

    private void renderControlBar(@NotNull RenderContext render, @NotNull Player player) {
        ((BukkitItemComponentBuilder)render.slot(49)).renderWith(() -> this.createRefreshDataItem(player)).onClick(this::handleRefreshData);
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.slot(52)).renderWith(() -> this.createAssignAllItem(render, player)).updateOnStateChange(this.cachedPlugins)).onClick(this::handleAssignAllClick);
    }

    private void renderDecorations(@NotNull RenderContext render, @NotNull Player player) {
        for (int slot : new int[]{0, 8, 18, 19, 20, 24, 25, 26, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 50, 51, 53}) {
            ((BukkitItemComponentBuilder)render.slot(slot)).renderWith(() -> this.createDecorationItem(player));
        }
    }

    @NotNull
    private ItemStack createPluginSlotContent(@NotNull RenderContext render, int slotIndex, @NotNull Player player) {
        List allPlugins = (List)this.cachedPlugins.get((StateValueHost)render);
        int currentPage = (Integer)this.pluginPage.get((StateValueHost)render);
        String currentSelection = (String)this.selectedPlugin.get((StateValueHost)render);
        Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)render);
        int pluginIndex = currentPage * 7 + slotIndex;
        if (pluginIndex < allPlugins.size()) {
            String pluginName = (String)allPlugins.get(pluginIndex);
            boolean isSelected = pluginName.equals(currentSelection);
            int permissionCount = permissionsMap.getOrDefault(pluginName, List.of()).size();
            return this.createPluginItem(pluginName, isSelected, permissionCount, player);
        }
        return this.createEmptyPluginSlotItem(player);
    }

    @NotNull
    private ItemStack createPermissionSlotContent(@NotNull RenderContext render, int slotIndex, @NotNull Player player) {
        String selectedPluginName = (String)this.selectedPlugin.get((StateValueHost)render);
        Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)render);
        int currentPage = (Integer)this.permissionPage.get((StateValueHost)render);
        ArrayList permissions = selectedPluginName != null ? (List)permissionsMap.getOrDefault(selectedPluginName, new ArrayList()) : new ArrayList();
        int permIndex = currentPage * 7 + slotIndex;
        if (selectedPluginName == null) {
            return this.createNoSelectionItem(player);
        }
        if (permIndex < permissions.size()) {
            return this.createPermissionItem((String)permissions.get(permIndex), selectedPluginName, player);
        }
        return this.createEmptyPermissionSlotItem(player);
    }

    @NotNull
    private ItemStack createPluginItem(@NotNull String pluginName, boolean isSelected, int permissionCount, @NotNull Player player) {
        Material material = isSelected ? Material.ENCHANTED_BOOK : Material.BOOK;
        ArrayList<Component> lore = new ArrayList<Component>(this.i18n("plugins.entry.lore", player).withPlaceholders(Map.of("plugin_name", pluginName, "permission_count", permissionCount, "status", isSelected ? "selected" : "available")).build().children());
        lore.add((Component)Component.empty());
        lore.addAll(this.i18n("plugins.entry.click_instructions", player).build().children());
        return UnifiedBuilderFactory.item(material).setName((Component)this.i18n("plugins.entry.name", player).withPlaceholder("plugin_name", pluginName).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createPermissionItem(@NotNull String permission, @NotNull String pluginName, @NotNull Player player) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)this.i18n("permissions.entry.plugin", player).withPlaceholder("plugin_name", pluginName).build().component());
        lore.add((Component)this.i18n("permissions.entry.node", player).withPlaceholder("permission", permission).build().component());
        lore.add((Component)Component.empty());
        lore.addAll(this.i18n("permissions.entry.click_instructions", player).build().children());
        return UnifiedBuilderFactory.item(Material.PAPER).setName((Component)this.i18n("permissions.entry.name", player).withPlaceholder("permission", permission).build().component()).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createStatusIndicatorItem(@NotNull RenderContext render, @NotNull Player player) {
        String selectedPlugin = (String)this.selectedPlugin.get((StateValueHost)render);
        int totalPlugins = ((List)this.cachedPlugins.get((StateValueHost)render)).size();
        if (selectedPlugin != null) {
            Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)render);
            int permissionCount = permissionsMap.getOrDefault(selectedPlugin, List.of()).size();
            return UnifiedBuilderFactory.item(Material.COMPASS).setName((Component)this.i18n("status.selected_plugin.name", player).withPlaceholder("plugin_name", selectedPlugin).build().component()).setLore(this.i18n("status.selected_plugin.lore", player).withPlaceholders(Map.of("plugin_name", selectedPlugin, "permission_count", permissionCount, "total_plugins", totalPlugins)).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        return UnifiedBuilderFactory.item(Material.CLOCK).setName((Component)this.i18n("status.overview.name", player).build().component()).setLore(this.i18n("status.overview.lore", player).withPlaceholder("total_plugins", totalPlugins).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createNoSelectionItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("permissions.no_selection.name", player).build().component()).setLore(this.i18n("permissions.no_selection.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createEmptyPluginSlotItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setName((Component)this.i18n("plugins.empty_slot.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createEmptyPermissionSlotItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.LIGHT_GRAY_STAINED_GLASS_PANE).setName((Component)this.i18n("permissions.empty_slot.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createHeaderDecorationItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.PURPLE_STAINED_GLASS_PANE).setName((Component)this.i18n("decoration.header.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createDecorationItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.GRAY_STAINED_GLASS_PANE).setName((Component)this.i18n("decoration.border.name", player).build().component()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createRefreshDataItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.EMERALD).setName((Component)this.i18n("controls.refresh.name", player).build().component()).setLore(this.i18n("controls.refresh.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createClearSelectionItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("clear_selection.name", player).build().component()).setLore(this.i18n("clear_selection.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createAssignAllItem(@NotNull RenderContext render, @NotNull Player player) {
        String selected = (String)this.selectedPlugin.get((StateValueHost)render);
        if (selected != null) {
            return UnifiedBuilderFactory.item(Material.EMERALD).setName((Component)this.i18n("assign_selected_plugin_permissions.name", player).withPlaceholder("plugin_name", selected).build().component()).setLore(this.i18n("assign_selected_plugin_permissions.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        int totalPlugins = ((List)this.cachedPlugins.get((StateValueHost)render)).size();
        return UnifiedBuilderFactory.item(Material.DIAMOND).setName((Component)this.i18n("assign_all_permissions.name", player).build().component()).setLore(this.i18n("assign_all_permissions.lore", player).withPlaceholder("total_plugins", totalPlugins).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    @NotNull
    private ItemStack createNavigationItem(@NotNull Object headProvider, @NotNull String name, @NotNull Player player) {
        try {
            ItemStack headItem = this.extractHeadFromProvider(headProvider, player);
            return UnifiedBuilderFactory.item(headItem).setName((Component)Component.text((String)name)).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to create navigation item", exception);
            return UnifiedBuilderFactory.item(Material.ARROW).setName((Component)Component.text((String)name)).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
        }
    }

    @NotNull
    private ItemStack extractHeadFromProvider(@NotNull Object headProvider, @NotNull Player player) {
        if (headProvider instanceof Previous) {
            return ((Previous)headProvider).getHead(player);
        }
        if (headProvider instanceof Next) {
            return ((Next)headProvider).getHead(player);
        }
        return UnifiedBuilderFactory.item(Material.ARROW).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
    }

    private void handleRefreshData(@NotNull SlotClickContext clickContext) {
        this.initializeData((Context)clickContext);
        this.selectedPlugin.set(null, (StateValueHost)clickContext);
        this.pluginPage.set((Object)0, (StateValueHost)clickContext);
        this.permissionPage.set((Object)0, (StateValueHost)clickContext);
        this.i18n("feedback.data_refreshed", clickContext.getPlayer()).includePrefix().build().sendMessage();
    }

    private boolean canNavigatePlugins(@NotNull RenderContext render, int delta) {
        int currentPage = (Integer)this.pluginPage.get((StateValueHost)render);
        List allPlugins = (List)this.cachedPlugins.get((StateValueHost)render);
        int maxPage = Math.max(0, (allPlugins.size() - 1) / 7);
        int newPage = currentPage + delta;
        return newPage >= 0 && newPage <= maxPage && !allPlugins.isEmpty();
    }

    private boolean canNavigatePermissions(@NotNull RenderContext render, int delta) {
        String selectedPluginName = (String)this.selectedPlugin.get((StateValueHost)render);
        if (selectedPluginName == null) {
            return false;
        }
        Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)render);
        List permissions = permissionsMap.getOrDefault(selectedPluginName, new ArrayList());
        int currentPage = (Integer)this.permissionPage.get((StateValueHost)render);
        int maxPage = Math.max(0, (permissions.size() - 1) / 7);
        int newPage = currentPage + delta;
        return newPage >= 0 && newPage <= maxPage && !permissions.isEmpty();
    }

    private void handlePluginSlotClick(@NotNull SlotClickContext clickContext, int slotIndex) {
        clickContext.getPlayer().setItemOnCursor(null);
        List allPlugins = (List)this.cachedPlugins.get((StateValueHost)clickContext);
        int currentPage = (Integer)this.pluginPage.get((StateValueHost)clickContext);
        int pluginIndex = currentPage * 7 + slotIndex;
        if (pluginIndex < allPlugins.size()) {
            this.handlePluginSelection(clickContext, (String)allPlugins.get(pluginIndex));
        }
    }

    private void handlePermissionSlotClick(@NotNull SlotClickContext clickContext, int slotIndex) {
        clickContext.getPlayer().setItemOnCursor(null);
        String selectedPluginName = (String)this.selectedPlugin.get((StateValueHost)clickContext);
        if (selectedPluginName == null) {
            return;
        }
        Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)clickContext);
        List permissions = permissionsMap.getOrDefault(selectedPluginName, new ArrayList());
        int currentPage = (Integer)this.permissionPage.get((StateValueHost)clickContext);
        int permIndex = currentPage * 7 + slotIndex;
        if (permIndex < permissions.size()) {
            this.handlePermissionClick(clickContext, selectedPluginName, (String)permissions.get(permIndex));
        }
    }

    private void handlePluginSelection(@NotNull SlotClickContext clickContext, @NotNull String pluginName) {
        String currentSelection = (String)this.selectedPlugin.get((StateValueHost)clickContext);
        LOGGER.info("handlePluginSelection called - plugin: " + pluginName + ", current: " + currentSelection);
        if (clickContext.getClickOrigin().getClick().isLeftClick()) {
            if (pluginName.equals(currentSelection)) {
                this.selectedPlugin.set(null, (StateValueHost)clickContext);
                this.permissionPage.set((Object)0, (StateValueHost)clickContext);
                LOGGER.info("Deselected plugin: " + pluginName);
                clickContext.getPlayer().sendMessage("\u00a7a[RDQ] \u00a77Deselected plugin \u00a7e" + pluginName);
            } else {
                this.selectedPlugin.set((Object)pluginName, (StateValueHost)clickContext);
                this.permissionPage.set((Object)0, (StateValueHost)clickContext);
                LOGGER.info("Selected plugin: " + pluginName);
                clickContext.getPlayer().sendMessage("\u00a7a[RDQ] \u00a77Selected plugin \u00a7e" + pluginName);
            }
        } else if (clickContext.getClickOrigin().getClick().isRightClick()) {
            LOGGER.info("Right-click on plugin: " + pluginName + " - assigning all permissions");
            Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)clickContext);
            List permissions = (List)permissionsMap.get(pluginName);
            if (permissions != null && !permissions.isEmpty()) {
                boolean success = ((RDQ)this.rdq.get((StateValueHost)clickContext)).getPermissionsService().addPermissionSet(clickContext.getPlayer(), pluginName, pluginName.toLowerCase(), permissions, true);
                if (!success) {
                    LOGGER.warning("Failed to assign permissions for plugin: " + pluginName);
                    return;
                }
                clickContext.getPlayer().sendMessage("\u00a7a[RDQ] \u00a77Assigned \u00a7e" + permissions.size() + " \u00a77permissions to group \u00a7e" + pluginName.toLowerCase());
            } else {
                clickContext.getPlayer().sendMessage("\u00a7c[RDQ] \u00a77No permissions found for plugin \u00a7e" + pluginName);
            }
        }
    }

    private void handlePermissionClick(@NotNull SlotClickContext clickContext, @NotNull String pluginName, @NotNull String permission) {
        LOGGER.info("handlePermissionClick called - plugin: " + pluginName + ", permission: " + permission);
        boolean success = ((RDQ)this.rdq.get((StateValueHost)clickContext)).getPermissionsService().addPermissionSet(clickContext.getPlayer(), pluginName, pluginName.toLowerCase(), List.of(permission), true);
        LOGGER.info("addPermissionSet returned: " + success);
        if (!success) {
            LOGGER.warning("Permission assignment failed for: " + permission);
            return;
        }
        LOGGER.info("Sending feedback message to player: " + clickContext.getPlayer().getName());
        clickContext.getPlayer().sendMessage("\u00a7a[RDQ] \u00a77Assigned permission \u00a7e" + permission + " \u00a77to group \u00a7e" + pluginName.toLowerCase());
    }

    private void handleClearSelection(@NotNull SlotClickContext clickContext) {
        this.selectedPlugin.set(null, (StateValueHost)clickContext);
        this.permissionPage.set((Object)0, (StateValueHost)clickContext);
        this.i18n("selection_cleared", clickContext.getPlayer()).includePrefix().build().sendMessage();
    }

    private void handleAssignAllClick(@NotNull SlotClickContext clickContext) {
        String selected = (String)this.selectedPlugin.get((StateValueHost)clickContext);
        if (selected != null) {
            Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)clickContext);
            List permissions = (List)permissionsMap.get(selected);
            if (permissions != null && !permissions.isEmpty()) {
                if (!((RDQ)this.rdq.get((StateValueHost)clickContext)).getPermissionsService().addPermissionSet(clickContext.getPlayer(), selected, selected.toLowerCase(), permissions, true)) {
                    return;
                }
                this.i18n("selected_plugin_all_assigned", clickContext.getPlayer()).withPlaceholders(Map.of("plugin_name", selected, "permission_count", permissions.size())).includePrefix().build().sendMessage();
            }
        } else {
            ((RDQ)this.rdq.get((StateValueHost)clickContext)).getPermissionsService().addAllPermissionSets(clickContext.getPlayer());
            int totalPlugins = ((List)this.cachedPlugins.get((StateValueHost)clickContext)).size();
            this.i18n("all_plugins_assigned", clickContext.getPlayer()).withPlaceholder("plugin_count", totalPlugins).includePrefix().build().sendMessage();
        }
    }

    private void handlePluginPageChange(@NotNull SlotClickContext clickContext, int delta) {
        int currentPage = (Integer)this.pluginPage.get((StateValueHost)clickContext);
        List allPlugins = (List)this.cachedPlugins.get((StateValueHost)clickContext);
        int maxPage = Math.max(0, (allPlugins.size() - 1) / 7);
        int newPage = Math.max(0, Math.min(maxPage, currentPage + delta));
        this.pluginPage.set((Object)newPage, (StateValueHost)clickContext);
        LOGGER.log(Level.FINE, "Plugin page changed to: " + newPage);
    }

    private void handlePermissionPageChange(@NotNull SlotClickContext clickContext, int delta) {
        String selectedPluginName = (String)this.selectedPlugin.get((StateValueHost)clickContext);
        if (selectedPluginName == null) {
            return;
        }
        Map permissionsMap = (Map)this.cachedPermissions.get((StateValueHost)clickContext);
        List permissions = permissionsMap.getOrDefault(selectedPluginName, new ArrayList());
        int currentPage = (Integer)this.permissionPage.get((StateValueHost)clickContext);
        int maxPage = Math.max(0, (permissions.size() - 1) / 7);
        int newPage = Math.max(0, Math.min(maxPage, currentPage + delta));
        this.permissionPage.set((Object)newPage, (StateValueHost)clickContext);
        LOGGER.log(Level.FINE, "Permission page changed to: " + newPage);
    }

    private void renderErrorState(@NotNull RenderContext render, @NotNull Player player) {
        try {
            ItemStack errorItem = UnifiedBuilderFactory.item(Material.BARRIER).setName((Component)this.i18n("error.general.name", player).build().component()).setLore(this.i18n("error.general.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
            ((BukkitItemComponentBuilder)render.slot(22)).renderWith(() -> errorItem);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to render error state", exception);
        }
    }
}

