/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.view.admin;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.view.admin.AdminPermissionsView;
import com.raindropcentral.rdq.view.admin.IRRank;
import com.raindropcentral.rplatform.api.luckperms.IRank;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;

public class AdminOverviewView
extends BaseView {
    private final State<RDQ> rdq = this.initialState("plugin");

    @Override
    protected String getKey() {
        return "admin_overview_ui";
    }

    @Override
    protected int getSize() {
        return 3;
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        this.initializePermissionsViewButton(render, player);
        this.initializeGroupCreationButton(render, player);
    }

    private void initializePermissionsViewButton(@NotNull RenderContext context, @NotNull Player player) {
        Map<String, List<String>> permissionsMap = ((RDQ)this.rdq.get((StateValueHost)context)).getPermissionsService().getPermissions();
        int totalPlugins = permissionsMap.size();
        int totalPermissions = permissionsMap.values().stream().mapToInt(List::size).sum();
        ((BukkitItemComponentBuilder)context.slot(1, 1)).withItem(UnifiedBuilderFactory.item(Material.DIAMOND).setName((Component)this.i18n("view_permissions.name", player).build().component()).setLore(this.i18n("view_permissions.lore", player).withPlaceholder("total_plugins", totalPlugins).withPlaceholder("total_permissions", totalPermissions).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build()).onClick(clickContext -> {
            try {
                clickContext.openForPlayer(AdminPermissionsView.class, Map.of("plugin", (RDQ)this.rdq.get((StateValueHost)clickContext)));
            }
            catch (Exception exception) {
                CentralLogger.getLogger(AdminOverviewView.class).log(Level.SEVERE, "Failed to open permissions view for player: " + player.getName(), exception);
                this.i18n("view_permissions.error", player).includePrefix().build().sendMessage();
            }
        });
    }

    private void initializeGroupCreationButton(@NotNull RenderContext context, @NotNull Player player) {
        ((BukkitItemComponentBuilder)context.slot(1, 2)).withItem(UnifiedBuilderFactory.item(Material.REDSTONE).setName((Component)this.i18n("create_ranks.name", player).build().component()).setLore(this.i18n("create_ranks.lore", player).build().children()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build()).onClick(clickContext -> {
            try {
                if (((RDQ)this.rdq.get((StateValueHost)clickContext)).getLuckPermsService() == null) {
                    this.i18n("create_ranks.no_luckperms", player).includePrefix().build().sendMessage();
                    return;
                }
                HashMap<String, List<IRank>> groups = new HashMap<String, List<IRank>>();
                ((RDQ)this.rdq.get((StateValueHost)clickContext)).getRankSystemFactory().getRanks().forEach((key, value) -> value.forEach((rankPathIdentifier, rank) -> {
                    if (!groups.containsKey(rank.getAssignedLuckPermsGroup())) {
                        groups.put(rank.getAssignedLuckPermsGroup(), new ArrayList());
                    }
                    ((List)groups.get(rank.getAssignedLuckPermsGroup())).add(new IRRank(rank.getIdentifier(), rank.getDisplayNameKey(), rank.getWeight()));
                }));
                if (groups.isEmpty()) {
                    this.i18n("create_ranks.no_ranks_found", player).includePrefix().build().sendMessage();
                    return;
                }
                int created = ((RDQ)this.rdq.get((StateValueHost)clickContext)).getLuckPermsService().createOrUpdateGroups(groups);
                if (created > 0) {
                    this.i18n("create_ranks.created", player).withPlaceholder("groups_created", created).includePrefix().build().sendMessage();
                } else {
                    this.i18n("create_ranks.no_changes", player).includePrefix().build().sendMessage();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                CentralLogger.getLogger(AdminOverviewView.class).log(Level.SEVERE, "Failed to create/update groups for player: " + player.getName(), exception);
                this.i18n("create_ranks.error", player).includePrefix().build().sendMessage();
            }
        });
    }
}

