/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.utility.requirement;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.config.requirement.AchievementRequirementSection;
import com.raindropcentral.rdq.config.requirement.BaseRequirementSection;
import com.raindropcentral.rdq.config.requirement.ChoiceRequirementSection;
import com.raindropcentral.rdq.config.requirement.CompositeRequirementSection;
import com.raindropcentral.rdq.config.requirement.CurrencyRequirementSection;
import com.raindropcentral.rdq.config.requirement.ExperienceLevelRequirementSection;
import com.raindropcentral.rdq.config.requirement.ItemRequirementSection;
import com.raindropcentral.rdq.config.requirement.JobRequirementSection;
import com.raindropcentral.rdq.config.requirement.LocationRequirementSection;
import com.raindropcentral.rdq.config.requirement.PermissionRequirementSection;
import com.raindropcentral.rdq.config.requirement.PlaytimeRequirementSection;
import com.raindropcentral.rdq.config.requirement.SkillRequirementSection;
import com.raindropcentral.rdq.config.requirement.TimeBasedRequirementSection;
import com.raindropcentral.rdq.database.entity.RRequirement;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.json.requirement.RequirementParser;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.configmapper.sections.AConfigSection;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequirementFactory {
    private final Logger LOGGER = CentralLogger.getLogger(RequirementFactory.class);
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RDQ rdq;

    public RequirementFactory(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    public List<RRankUpgradeRequirement> parseRequirements(@NotNull RRank rank, @NotNull Map<String, ? extends BaseRequirementSection> requirements) {
        ArrayList<RRankUpgradeRequirement> upgradeRequirements = new ArrayList<RRankUpgradeRequirement>();
        if (requirements.isEmpty()) {
            this.LOGGER.info("No requirements configured for rank: " + rank.getIdentifier());
            return upgradeRequirements;
        }
        AtomicInteger displayOrder = new AtomicInteger(0);
        requirements.forEach((requirementKey, baseRequirementSection) -> {
            if (baseRequirementSection == null) {
                this.LOGGER.warning("Null requirement section found for key: " + requirementKey);
                return;
            }
            AConfigSection specificRequirement = this.getSpecificRequirementSection((BaseRequirementSection)baseRequirementSection);
            if (specificRequirement == null) {
                this.LOGGER.warning("No valid requirement section found for key: " + requirementKey + " in rank: " + rank.getIdentifier());
                return;
            }
            try {
                if (this.isInvalidRequirement(specificRequirement)) {
                    this.LOGGER.info("Skipping invalid requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") for rank '" + rank.getIdentifier() + "' - missing required data");
                    return;
                }
                AbstractRequirement abstractRequirement = this.createRequirementFromSection(specificRequirement);
                RRequirement rRequirement = new RRequirement(abstractRequirement, baseRequirementSection.getIcon());
                RRankUpgradeRequirement upgradeRequirement = new RRankUpgradeRequirement(rank, rRequirement, rRequirement.getShowcase());
                Integer configuredOrder = baseRequirementSection.getDisplayOrder();
                if (configuredOrder != null && configuredOrder > 0) {
                    upgradeRequirement.setDisplayOrder(configuredOrder);
                } else {
                    upgradeRequirement.setDisplayOrder(displayOrder.getAndIncrement());
                }
                upgradeRequirements.add(upgradeRequirement);
                this.LOGGER.info("Successfully parsed requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") for rank '" + rank.getIdentifier() + "'");
            }
            catch (Exception exception) {
                this.LOGGER.log(Level.SEVERE, "Failed to parse requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") for rank '" + rank.getIdentifier() + "'", exception);
            }
        });
        return upgradeRequirements;
    }

    public void parseAndAssignRequirements(RRank rank, Map<String, ? extends BaseRequirementSection> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            this.LOGGER.info("No requirements configured for rank: " + rank.getIdentifier());
            return;
        }
        AtomicInteger displayOrder = new AtomicInteger(0);
        requirements.forEach((requirementKey, baseRequirementSection) -> {
            if (baseRequirementSection == null) {
                this.LOGGER.warning("Null requirement section found for key: " + requirementKey);
                return;
            }
            this.LOGGER.info("Processing requirement: " + requirementKey + " for rank: " + rank.getIdentifier());
            this.LOGGER.info("BaseRequirementSection type: " + baseRequirementSection.getType());
            AConfigSection specificRequirement = this.getSpecificRequirementSection((BaseRequirementSection)baseRequirementSection);
            if (specificRequirement == null) {
                this.LOGGER.warning("No valid requirement section found for key: " + requirementKey + " in rank: " + rank.getIdentifier());
                return;
            }
            this.LOGGER.info("Found specific requirement of type: " + specificRequirement.getClass().getSimpleName());
            try {
                if (this.isInvalidRequirement(specificRequirement)) {
                    this.LOGGER.warning("Skipping invalid requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") for rank '" + rank.getIdentifier() + "' - missing required data");
                    return;
                }
                AbstractRequirement abstractRequirement = this.createRequirementFromSection(specificRequirement);
                RRequirement rRequirement = new RRequirement(abstractRequirement, baseRequirementSection.getIcon());
                try {
                    rRequirement = this.rdq.getRequirementRepository().createAsync(rRequirement).join();
                    this.LOGGER.info("Successfully persisted RRequirement with ID: " + rRequirement.getId() + " for requirement: " + requirementKey);
                }
                catch (Exception e) {
                    this.LOGGER.log(Level.SEVERE, "Failed to persist RRequirement for requirement '" + requirementKey + "'", e);
                    return;
                }
                RRankUpgradeRequirement upgradeRequirement = new RRankUpgradeRequirement(rank, rRequirement, rRequirement.getShowcase());
                Integer configuredOrder = baseRequirementSection.getDisplayOrder();
                if (configuredOrder != null && configuredOrder > 0) {
                    upgradeRequirement.setDisplayOrder(configuredOrder);
                } else {
                    upgradeRequirement.setDisplayOrder(displayOrder.getAndIncrement());
                }
                rank.addUpgradeRequirement(upgradeRequirement);
                this.LOGGER.info("Successfully parsed and added requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") to rank '" + rank.getIdentifier() + "'");
            }
            catch (Exception exception) {
                this.LOGGER.log(Level.SEVERE, "Failed to parse requirement '" + requirementKey + "' (type: " + specificRequirement.getClass().getSimpleName() + ") for rank '" + rank.getIdentifier() + "'", exception);
            }
        });
        this.LOGGER.info("Finished processing requirements for rank: " + rank.getIdentifier() + ". Total requirements added: " + rank.getUpgradeRequirements().size());
    }

    private AConfigSection getSpecificRequirementSection(BaseRequirementSection baseRequirementSection) {
        String type = baseRequirementSection.getType();
        this.LOGGER.info("getSpecificRequirementSection: type=" + type);
        if (type == null || type.equals("not_defined") || type.equals("UNKNOWN")) {
            this.LOGGER.info("Auto-detecting requirement type...");
            if (this.hasValidItemRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected ITEM requirement");
                return baseRequirementSection.getItemRequirement();
            }
            if (this.hasValidCurrencyRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected CURRENCY requirement");
                return baseRequirementSection.getCurrencyRequirement();
            }
            if (this.hasValidExperienceRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected EXPERIENCE_LEVEL requirement");
                return baseRequirementSection.getExperienceRequirement();
            }
            if (this.hasValidPlaytimeRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected PLAYTIME requirement");
                return baseRequirementSection.getPlaytimeRequirement();
            }
            if (this.hasValidPermissionRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected PERMISSION requirement");
                return baseRequirementSection.getPermissionRequirement();
            }
            if (this.hasValidLocationRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected LOCATION requirement");
                return baseRequirementSection.getLocationRequirement();
            }
            if (this.hasValidCompositeRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected COMPOSITE requirement");
                return baseRequirementSection.getCompositeRequirement();
            }
            if (this.hasValidChoiceRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected CHOICE requirement");
                return baseRequirementSection.getChoiceRequirement();
            }
            if (this.hasValidAchievementRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected ACHIEVEMENT requirement");
                return baseRequirementSection.getAchievementRequirement();
            }
            if (this.hasValidSkillRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected SKILLS requirement");
                return baseRequirementSection.getSkillRequirement();
            }
            if (this.hasValidJobRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected JOBS requirement");
                return baseRequirementSection.getJobRequirement();
            }
            if (this.hasValidTimeBasedRequirement(baseRequirementSection)) {
                this.LOGGER.info("  -> Detected TIME_BASED requirement");
                return baseRequirementSection.getTimeBasedRequirement();
            }
        } else {
            ItemRequirementSection result;
            switch (type.toUpperCase()) {
                case "ITEM": {
                    AConfigSection aConfigSection;
                    if (this.hasValidItemRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getItemRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "CURRENCY": {
                    AConfigSection aConfigSection;
                    if (this.hasValidCurrencyRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getCurrencyRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "EXPERIENCE_LEVEL": {
                    AConfigSection aConfigSection;
                    if (this.hasValidExperienceRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getExperienceRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "PLAYTIME": {
                    AConfigSection aConfigSection;
                    if (this.hasValidPlaytimeRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getPlaytimeRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "TIME_BASED": {
                    AConfigSection aConfigSection;
                    if (this.hasValidTimeBasedRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getTimeBasedRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "PERMISSION": {
                    AConfigSection aConfigSection;
                    if (this.hasValidPermissionRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getPermissionRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "LOCATION": {
                    AConfigSection aConfigSection;
                    if (this.hasValidLocationRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getLocationRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "COMPOSITE": {
                    AConfigSection aConfigSection;
                    if (this.hasValidCompositeRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getCompositeRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "CHOICE": {
                    AConfigSection aConfigSection;
                    if (this.hasValidChoiceRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getChoiceRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "ACHIEVEMENT": 
                case "CUSTOM": {
                    AConfigSection aConfigSection;
                    if (this.hasValidAchievementRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getAchievementRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "SKILLS": {
                    AConfigSection aConfigSection;
                    if (this.hasValidSkillRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getSkillRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                case "JOBS": {
                    AConfigSection aConfigSection;
                    if (this.hasValidJobRequirement(baseRequirementSection)) {
                        aConfigSection = baseRequirementSection.getJobRequirement();
                        break;
                    }
                    aConfigSection = null;
                    break;
                }
                default: {
                    AConfigSection aConfigSection = result = null;
                }
            }
            if (result == null) {
                this.LOGGER.warning("Type '" + type + "' specified but no valid data found for that type");
                this.debugLogRequirementSections(baseRequirementSection);
            } else {
                this.LOGGER.info("Found valid " + type + " requirement section");
            }
            return result;
        }
        this.LOGGER.warning("  -> No valid requirement section detected!");
        return null;
    }

    private boolean hasValidItemRequirement(BaseRequirementSection section) {
        ItemRequirementSection req = section.getItemRequirement();
        return req != null && req.getRequiredItemsList() != null && !req.getRequiredItemsList().isEmpty();
    }

    private boolean hasValidCurrencyRequirement(BaseRequirementSection section) {
        CurrencyRequirementSection req = section.getCurrencyRequirement();
        return req != null && req.getRequiredCurrencies() != null && !req.getRequiredCurrencies().isEmpty();
    }

    private boolean hasValidExperienceRequirement(BaseRequirementSection section) {
        ExperienceLevelRequirementSection req = section.getExperienceRequirement();
        return req != null && req.getRequiredLevel() > 0;
    }

    private boolean hasValidPlaytimeRequirement(BaseRequirementSection section) {
        PlaytimeRequirementSection req = section.getPlaytimeRequirement();
        return req != null && req.getRequiredPlaytimeSeconds() > 0L;
    }

    private boolean hasValidPermissionRequirement(BaseRequirementSection section) {
        PermissionRequirementSection req = section.getPermissionRequirement();
        return req != null && req.getRequiredPermissions() != null && !req.getRequiredPermissions().isEmpty();
    }

    private boolean hasValidLocationRequirement(BaseRequirementSection section) {
        LocationRequirementSection req = section.getLocationRequirement();
        if (req == null) {
            return false;
        }
        return req.getRequiredWorld() != null && !req.getRequiredWorld().trim().isEmpty() || req.getRequiredRegion() != null && !req.getRequiredRegion().trim().isEmpty() || req.getRequiredCoordinates() != null && !req.getRequiredCoordinates().isEmpty() || req.getRequiredDistance() > 0.0;
    }

    private boolean hasValidCompositeRequirement(BaseRequirementSection section) {
        CompositeRequirementSection req = section.getCompositeRequirement();
        return req != null && req.getCompositeRequirements() != null && !req.getCompositeRequirements().isEmpty();
    }

    private boolean hasValidChoiceRequirement(BaseRequirementSection section) {
        ChoiceRequirementSection req = section.getChoiceRequirement();
        return req != null && req.getChoices() != null && !req.getChoices().isEmpty();
    }

    private boolean hasValidAchievementRequirement(BaseRequirementSection section) {
        AchievementRequirementSection req = section.getAchievementRequirement();
        return req != null && req.getRequiredAchievements() != null && !req.getRequiredAchievements().isEmpty();
    }

    private boolean hasValidSkillRequirement(BaseRequirementSection section) {
        SkillRequirementSection req = section.getSkillRequirement();
        return req != null && req.getRequiredSkills() != null && !req.getRequiredSkills().isEmpty();
    }

    private boolean hasValidJobRequirement(BaseRequirementSection section) {
        JobRequirementSection req = section.getJobRequirement();
        return req != null && req.getRequiredJobs() != null && !req.getRequiredJobs().isEmpty();
    }

    private boolean hasValidTimeBasedRequirement(BaseRequirementSection section) {
        TimeBasedRequirementSection req = section.getTimeBasedRequirement();
        return req != null && req.getTimeConstraintSeconds() > 0L;
    }

    private void debugLogRequirementSections(BaseRequirementSection section) {
        this.LOGGER.info("Debug - Requirement sections state:");
        this.LOGGER.info("  itemRequirement: items=" + String.valueOf(section.getItemRequirement() != null ? Integer.valueOf(section.getItemRequirement().getRequiredItemsList().size()) : "null"));
        this.LOGGER.info("  currencyRequirement: currencies=" + String.valueOf(section.getCurrencyRequirement() != null && section.getCurrencyRequirement().getRequiredCurrencies() != null ? Integer.valueOf(section.getCurrencyRequirement().getRequiredCurrencies().size()) : "null"));
        this.LOGGER.info("  experienceRequirement: level=" + String.valueOf(section.getExperienceRequirement() != null ? section.getExperienceRequirement().getRequiredLevel() : "null"));
        this.LOGGER.info("  playtimeRequirement: seconds=" + String.valueOf(section.getPlaytimeRequirement() != null ? section.getPlaytimeRequirement().getRequiredPlaytimeSeconds() : "null"));
        this.LOGGER.info("  compositeRequirement: reqs=" + String.valueOf(section.getCompositeRequirement() != null && section.getCompositeRequirement().getCompositeRequirements() != null ? Integer.valueOf(section.getCompositeRequirement().getCompositeRequirements().size()) : "null"));
        this.LOGGER.info("  choiceRequirement: choices=" + String.valueOf(section.getChoiceRequirement() != null && section.getChoiceRequirement().getChoices() != null ? Integer.valueOf(section.getChoiceRequirement().getChoices().size()) : "null"));
    }

    private boolean isInvalidRequirement(@NotNull AConfigSection requirementSection) {
        boolean bl;
        block15: {
            block14: {
                AConfigSection aConfigSection = requirementSection;
                Objects.requireNonNull(aConfigSection);
                AConfigSection aConfigSection2 = aConfigSection;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemRequirementSection.class, CurrencyRequirementSection.class, ExperienceLevelRequirementSection.class, PlaytimeRequirementSection.class, PermissionRequirementSection.class, LocationRequirementSection.class, CompositeRequirementSection.class, ChoiceRequirementSection.class, AchievementRequirementSection.class, SkillRequirementSection.class, JobRequirementSection.class, TimeBasedRequirementSection.class}, (Object)aConfigSection2, n)) {
                    case 0: {
                        ItemRequirementSection itemSection = (ItemRequirementSection)aConfigSection2;
                        if (itemSection.getRequiredItemsList() == null || itemSection.getRequiredItemsList().isEmpty()) break;
                        break block14;
                    }
                    case 1: {
                        CurrencyRequirementSection currencySection = (CurrencyRequirementSection)aConfigSection2;
                        if (currencySection.getRequiredCurrencies() == null || currencySection.getRequiredCurrencies().isEmpty()) break;
                        break block14;
                    }
                    case 2: {
                        ExperienceLevelRequirementSection expSection = (ExperienceLevelRequirementSection)aConfigSection2;
                        if (expSection.getRequiredLevel() <= 0) break;
                        break block14;
                    }
                    case 3: {
                        PlaytimeRequirementSection playtimeSection = (PlaytimeRequirementSection)aConfigSection2;
                        if (playtimeSection.getRequiredPlaytimeSeconds() <= 0L && (playtimeSection.getTime() == null || playtimeSection.getTime() <= 0L)) break;
                        break block14;
                    }
                    case 4: {
                        PermissionRequirementSection permissionSection = (PermissionRequirementSection)aConfigSection2;
                        if (permissionSection.getRequiredPermissions() == null || permissionSection.getRequiredPermissions().isEmpty()) break;
                        break block14;
                    }
                    case 5: {
                        LocationRequirementSection locationSection = (LocationRequirementSection)aConfigSection2;
                        if (!(locationSection.getRequiredWorld() != null && !locationSection.getRequiredWorld().trim().isEmpty() || locationSection.getRequiredRegion() != null && !locationSection.getRequiredRegion().trim().isEmpty() || locationSection.getRequiredCoordinates() != null && !locationSection.getRequiredCoordinates().isEmpty()) && !(locationSection.getRequiredDistance() > 0.0)) break;
                        break block14;
                    }
                    case 6: {
                        CompositeRequirementSection compositeSection = (CompositeRequirementSection)aConfigSection2;
                        if (compositeSection.getCompositeRequirements() == null || compositeSection.getCompositeRequirements().isEmpty()) break;
                        break block14;
                    }
                    case 7: {
                        ChoiceRequirementSection choiceSection = (ChoiceRequirementSection)aConfigSection2;
                        if (choiceSection.getChoices() == null || choiceSection.getChoices().isEmpty()) break;
                        break block14;
                    }
                    case 8: {
                        AchievementRequirementSection achievementSection = (AchievementRequirementSection)aConfigSection2;
                        if (achievementSection.getRequiredAchievements() == null || achievementSection.getRequiredAchievements().isEmpty()) break;
                        break block14;
                    }
                    case 9: {
                        SkillRequirementSection skillSection = (SkillRequirementSection)aConfigSection2;
                        if (skillSection.getRequiredSkills() == null || skillSection.getRequiredSkills().isEmpty()) break;
                        break block14;
                    }
                    case 10: {
                        JobRequirementSection jobSection = (JobRequirementSection)aConfigSection2;
                        if (jobSection.getRequiredJobs() == null || jobSection.getRequiredJobs().isEmpty()) break;
                        break block14;
                    }
                    case 11: {
                        TimeBasedRequirementSection timeSection = (TimeBasedRequirementSection)aConfigSection2;
                        if (!(timeSection.getTimeConstraintSeconds() > 0L || timeSection.getStartTime() != null && timeSection.getEndTime() != null || timeSection.getActiveDays() != null && !timeSection.getActiveDays().isEmpty()) && (timeSection.getActiveDates() == null || timeSection.getActiveDates().isEmpty())) break;
                        break block14;
                    }
                    default: {
                        this.LOGGER.warning("Unknown requirement section type for validation: " + requirementSection.getClass().getSimpleName());
                        break;
                    }
                }
                bl = true;
                break block15;
            }
            bl = false;
        }
        return bl;
    }

    public AbstractRequirement createRequirementFromSection(AConfigSection requirementSection) throws IOException {
        String requirementJson = this.convertSectionToJson(requirementSection);
        this.LOGGER.info("Generated JSON for requirement: " + requirementJson);
        return RequirementParser.parse(requirementJson);
    }

    private String convertSectionToJson(@NotNull AConfigSection requirementSection) throws IOException {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String type = this.determineRequirementType(requirementSection);
        jsonMap.put("type", type);
        AConfigSection aConfigSection = requirementSection;
        Objects.requireNonNull(aConfigSection);
        AConfigSection aConfigSection2 = aConfigSection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemRequirementSection.class, CurrencyRequirementSection.class, ExperienceLevelRequirementSection.class, PlaytimeRequirementSection.class, PermissionRequirementSection.class, LocationRequirementSection.class, CompositeRequirementSection.class, ChoiceRequirementSection.class, AchievementRequirementSection.class, SkillRequirementSection.class, JobRequirementSection.class, TimeBasedRequirementSection.class}, (Object)aConfigSection2, n)) {
            case 0: {
                ItemRequirementSection itemSection = (ItemRequirementSection)aConfigSection2;
                this.addItemProperties(jsonMap, itemSection);
                break;
            }
            case 1: {
                CurrencyRequirementSection currencySection = (CurrencyRequirementSection)aConfigSection2;
                this.addCurrencyProperties(jsonMap, currencySection);
                break;
            }
            case 2: {
                ExperienceLevelRequirementSection expSection = (ExperienceLevelRequirementSection)aConfigSection2;
                this.addExperienceProperties(jsonMap, expSection);
                break;
            }
            case 3: {
                PlaytimeRequirementSection playtimeSection = (PlaytimeRequirementSection)aConfigSection2;
                this.addPlaytimeProperties(jsonMap, playtimeSection);
                break;
            }
            case 4: {
                PermissionRequirementSection permissionSection = (PermissionRequirementSection)aConfigSection2;
                this.addPermissionProperties(jsonMap, permissionSection);
                break;
            }
            case 5: {
                LocationRequirementSection locationSection = (LocationRequirementSection)aConfigSection2;
                this.addLocationProperties(jsonMap, locationSection);
                break;
            }
            case 6: {
                CompositeRequirementSection compositeSection = (CompositeRequirementSection)aConfigSection2;
                this.addCompositeProperties(jsonMap, compositeSection);
                break;
            }
            case 7: {
                ChoiceRequirementSection choiceSection = (ChoiceRequirementSection)aConfigSection2;
                this.addChoiceProperties(jsonMap, choiceSection);
                break;
            }
            case 8: {
                AchievementRequirementSection achievementSection = (AchievementRequirementSection)aConfigSection2;
                this.addAchievementProperties(jsonMap, achievementSection);
                break;
            }
            case 9: {
                SkillRequirementSection skillSection = (SkillRequirementSection)aConfigSection2;
                this.addSkillProperties(jsonMap, skillSection);
                break;
            }
            case 10: {
                JobRequirementSection jobSection = (JobRequirementSection)aConfigSection2;
                this.addJobProperties(jsonMap, jobSection);
                break;
            }
            case 11: {
                TimeBasedRequirementSection timeSection = (TimeBasedRequirementSection)aConfigSection2;
                this.addTimeBasedProperties(jsonMap, timeSection);
                break;
            }
            default: {
                this.LOGGER.warning("Unknown requirement section type: " + requirementSection.getClass().getSimpleName());
            }
        }
        return this.OBJECT_MAPPER.writeValueAsString(jsonMap);
    }

    private String determineRequirementType(AConfigSection requirementSection) {
        AConfigSection aConfigSection = requirementSection;
        Objects.requireNonNull(aConfigSection);
        AConfigSection aConfigSection2 = aConfigSection;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemRequirementSection.class, CurrencyRequirementSection.class, ExperienceLevelRequirementSection.class, PlaytimeRequirementSection.class, PermissionRequirementSection.class, LocationRequirementSection.class, CompositeRequirementSection.class, ChoiceRequirementSection.class, AchievementRequirementSection.class, SkillRequirementSection.class, JobRequirementSection.class, TimeBasedRequirementSection.class}, (Object)aConfigSection2, n)) {
            case 0 -> {
                ItemRequirementSection ignored = (ItemRequirementSection)aConfigSection2;
                yield "ITEM";
            }
            case 1 -> {
                CurrencyRequirementSection ignored = (CurrencyRequirementSection)aConfigSection2;
                yield "CURRENCY";
            }
            case 2 -> {
                ExperienceLevelRequirementSection ignored = (ExperienceLevelRequirementSection)aConfigSection2;
                yield "EXPERIENCE_LEVEL";
            }
            case 3 -> {
                PlaytimeRequirementSection ignored = (PlaytimeRequirementSection)aConfigSection2;
                yield "PLAYTIME";
            }
            case 4 -> {
                PermissionRequirementSection ignored = (PermissionRequirementSection)aConfigSection2;
                yield "PERMISSION";
            }
            case 5 -> {
                LocationRequirementSection ignored = (LocationRequirementSection)aConfigSection2;
                yield "LOCATION";
            }
            case 6 -> {
                CompositeRequirementSection ignored = (CompositeRequirementSection)aConfigSection2;
                yield "COMPOSITE";
            }
            case 7 -> {
                ChoiceRequirementSection ignored = (ChoiceRequirementSection)aConfigSection2;
                yield "CHOICE";
            }
            case 8 -> {
                AchievementRequirementSection ignored = (AchievementRequirementSection)aConfigSection2;
                yield "CUSTOM";
            }
            case 9 -> {
                SkillRequirementSection ignored = (SkillRequirementSection)aConfigSection2;
                yield "SKILLS";
            }
            case 10 -> {
                JobRequirementSection ignored = (JobRequirementSection)aConfigSection2;
                yield "JOBS";
            }
            case 11 -> {
                TimeBasedRequirementSection ignored = (TimeBasedRequirementSection)aConfigSection2;
                yield "TIME_BASED";
            }
            default -> "UNKNOWN";
        };
    }

    private void addItemProperties(@NotNull Map<String, Object> jsonMap, @NotNull ItemRequirementSection section) {
        jsonMap.put("consumeOnComplete", section.getConsumeOnComplete());
        jsonMap.put("exactMatch", false);
        jsonMap.put("description", "Item requirement");
        if (section.getRequiredItemsList() != null && !section.getRequiredItemsList().isEmpty()) {
            ArrayList itemStackList = new ArrayList();
            for (ItemStack itemStack : section.getRequiredItemsList()) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("type", itemStack.getType().name());
                itemMap.put("amount", itemStack.getAmount());
                if (itemStack.hasItemMeta()) {
                    HashMap<String, Object> metaMap = new HashMap<String, Object>();
                    if (itemStack.getItemMeta().hasDisplayName()) {
                        metaMap.put("displayName", itemStack.getItemMeta().getDisplayName());
                    }
                    if (itemStack.getItemMeta().hasLore()) {
                        metaMap.put("lore", itemStack.getItemMeta().getLore());
                    }
                    if (!metaMap.isEmpty()) {
                        itemMap.put("meta", metaMap);
                    }
                }
                itemStackList.add(itemMap);
            }
            jsonMap.put("requiredItems", itemStackList);
            jsonMap.put("itemBuilders", new ArrayList());
            this.LOGGER.info("Added " + itemStackList.size() + " items to requirement JSON:");
            for (int i = 0; i < itemStackList.size(); ++i) {
                Map item = (Map)itemStackList.get(i);
                this.LOGGER.info("  Item " + i + ": " + String.valueOf(item.get("type")) + " x" + String.valueOf(item.get("amount")));
            }
        }
    }

    private void addCurrencyProperties(Map<String, Object> jsonMap, CurrencyRequirementSection section) {
        jsonMap.put("consumeOnComplete", section.getConsumeOnComplete());
        String currencyPlugin = section.getCurrencyPlugin();
        if (currencyPlugin == null || currencyPlugin.trim().isEmpty()) {
            currencyPlugin = "vault";
        }
        jsonMap.put("currencyPlugin", currencyPlugin);
        Map<String, Double> requiredCurrencies = section.getRequiredCurrencies();
        if (requiredCurrencies != null && !requiredCurrencies.isEmpty()) {
            jsonMap.put("requiredCurrencies", requiredCurrencies);
        } else {
            HashMap<String, Double> defaultCurrency = new HashMap<String, Double>();
            defaultCurrency.put("default", 100.0);
            jsonMap.put("requiredCurrencies", defaultCurrency);
        }
    }

    private void addExperienceProperties(Map<String, Object> jsonMap, ExperienceLevelRequirementSection section) {
        jsonMap.put("consumeOnComplete", section.getConsumeOnComplete());
        jsonMap.put("requiredLevel", Math.max(1, section.getRequiredLevel()));
        String experienceType = section.getExperienceType();
        if (experienceType == null || experienceType.trim().isEmpty()) {
            experienceType = "LEVEL";
        }
        jsonMap.put("experienceType", experienceType);
        if (section.getDescription() != null && !section.getDescription().trim().isEmpty()) {
            jsonMap.put("description", section.getDescription());
        }
    }

    private void addPlaytimeProperties(Map<String, Object> jsonMap, PlaytimeRequirementSection section) {
        long minutes;
        long requiredPlaytimeSeconds = section.getRequiredPlaytimeSeconds();
        if (requiredPlaytimeSeconds <= 0L) {
            requiredPlaytimeSeconds = 3600L;
            this.LOGGER.warning("No valid playtime requirement found, defaulting to 1 hour (3600 seconds)");
        }
        jsonMap.put("requiredPlaytimeSeconds", requiredPlaytimeSeconds);
        Boolean useTotalPlaytime = section.getUseTotalPlaytime();
        if (useTotalPlaytime == null) {
            useTotalPlaytime = !section.hasWorldSpecificConfiguration();
        }
        jsonMap.put("useTotalPlaytime", useTotalPlaytime);
        Map<String, Long> worldPlaytimeRequirements = section.getWorldPlaytimeRequirements();
        if (!worldPlaytimeRequirements.isEmpty()) {
            jsonMap.put("worldPlaytimeRequirements", worldPlaytimeRequirements);
            this.LOGGER.info("Added world-specific playtime requirements:");
            for (Map.Entry<String, Long> entry : worldPlaytimeRequirements.entrySet()) {
                long hours = entry.getValue() / 3600L;
                long minutes2 = entry.getValue() % 3600L / 60L;
                long seconds = entry.getValue() % 60L;
                this.LOGGER.info("  " + entry.getKey() + ": " + (String)(hours > 0L ? hours + "h " : "") + (String)(minutes2 > 0L ? minutes2 + "m " : "") + (String)(seconds > 0L ? seconds + "s" : ""));
            }
        } else {
            jsonMap.put("worldPlaytimeRequirements", new HashMap());
        }
        Object description = section.getDescription();
        if (description != null && !((String)description).trim().isEmpty()) {
            jsonMap.put("description", description);
        } else {
            if (useTotalPlaytime.booleanValue()) {
                long hours = requiredPlaytimeSeconds / 3600L;
                minutes = requiredPlaytimeSeconds % 3600L / 60L;
                Object timeDesc = "";
                if (hours > 0L) {
                    timeDesc = (String)timeDesc + hours + " hour" + (hours > 1L ? "s" : "");
                    if (minutes > 0L) {
                        timeDesc = (String)timeDesc + " and " + minutes + " minute" + (minutes > 1L ? "s" : "");
                    }
                } else {
                    timeDesc = minutes > 0L ? minutes + " minute" + (minutes > 1L ? "s" : "") : requiredPlaytimeSeconds + " second" + (requiredPlaytimeSeconds > 1L ? "s" : "");
                }
                description = "Play for a total of " + (String)timeDesc;
            } else {
                description = "Meet world-specific playtime requirements";
            }
            jsonMap.put("description", description);
        }
        if (useTotalPlaytime.booleanValue()) {
            long hours = requiredPlaytimeSeconds / 3600L;
            minutes = requiredPlaytimeSeconds % 3600L / 60L;
            this.LOGGER.info("Configured total playtime requirement: " + (String)(hours > 0L ? hours + "h " : "") + (String)(minutes > 0L ? minutes + "m " : "") + (String)(requiredPlaytimeSeconds % 60L > 0L ? requiredPlaytimeSeconds % 60L + "s" : ""));
        } else {
            this.LOGGER.info("Configured world-specific playtime requirements for " + worldPlaytimeRequirements.size() + " world(s)");
        }
    }

    private void addPermissionProperties(Map<String, Object> jsonMap, PermissionRequirementSection section) {
        jsonMap.put("requireAll", section.getRequireAll());
        jsonMap.put("checkNegation", section.getCheckNegation());
        List<String> requiredPermissions = section.getRequiredPermissions();
        if (requiredPermissions != null && !requiredPermissions.isEmpty()) {
            jsonMap.put("requiredPermissions", requiredPermissions);
        } else {
            jsonMap.put("requiredPermissions", List.of("default.permission"));
        }
    }

    private void addLocationProperties(Map<String, Object> jsonMap, LocationRequirementSection section) {
        jsonMap.put("exactLocation", section.getExactLocation());
        if (section.getRequiredWorld() != null && !section.getRequiredWorld().trim().isEmpty()) {
            jsonMap.put("requiredWorld", section.getRequiredWorld());
        }
        if (section.getRequiredRegion() != null && !section.getRequiredRegion().trim().isEmpty()) {
            jsonMap.put("requiredRegion", section.getRequiredRegion());
        }
        if (section.getRequiredCoordinates() != null && !section.getRequiredCoordinates().isEmpty()) {
            jsonMap.put("requiredCoordinates", section.getRequiredCoordinates());
        }
        if (section.getRequiredDistance() > 0.0) {
            jsonMap.put("requiredDistance", section.getRequiredDistance());
        }
        if ((section.getRequiredWorld() == null || section.getRequiredWorld().trim().isEmpty()) && (section.getRequiredRegion() == null || section.getRequiredRegion().trim().isEmpty()) && (section.getRequiredCoordinates() == null || section.getRequiredCoordinates().isEmpty()) && section.getRequiredDistance() <= 0.0) {
            jsonMap.put("requiredWorld", "world");
        }
    }

    private void addCompositeProperties(Map<String, Object> jsonMap, CompositeRequirementSection section) throws IOException {
        List<BaseRequirementSection> compositeRequirements;
        jsonMap.put("operator", section.getOperator());
        jsonMap.put("minimumRequired", Math.max(0, section.getMinimumRequired()));
        jsonMap.put("maximumRequired", Math.max(0, section.getMaximumRequired()));
        jsonMap.put("allowPartialProgress", section.getAllowPartialProgress());
        if (section.getDescription() != null && !section.getDescription().trim().isEmpty()) {
            jsonMap.put("description", section.getDescription());
        }
        if ((compositeRequirements = section.getCompositeRequirements()) != null && !compositeRequirements.isEmpty()) {
            ArrayList<Map> subRequirements = new ArrayList<Map>();
            for (BaseRequirementSection subReq : compositeRequirements) {
                AConfigSection specificSection = this.getSpecificRequirementSection(subReq);
                if (specificSection != null) {
                    String subJson = this.convertSectionToJson(specificSection);
                    Map subMap = (Map)this.OBJECT_MAPPER.readValue(subJson, Map.class);
                    subRequirements.add(subMap);
                    continue;
                }
                this.LOGGER.warning("Could not determine specific requirement type for sub-requirement in composite");
            }
            jsonMap.put("requirements", subRequirements);
        } else {
            jsonMap.put("requirements", new ArrayList());
        }
    }

    private void addChoiceProperties(Map<String, Object> jsonMap, ChoiceRequirementSection section) throws IOException {
        List<BaseRequirementSection> choices;
        jsonMap.put("minimumRequired", Math.max(1, section.getMinimumRequired()));
        jsonMap.put("maximumRequired", Math.max(0, section.getMaximumRequired()));
        jsonMap.put("allowPartialProgress", section.getAllowPartialProgress());
        jsonMap.put("mutuallyExclusive", section.getMutuallyExclusive());
        jsonMap.put("allowChoiceChange", section.getAllowChoiceChange());
        if (section.getDescription() != null && !section.getDescription().trim().isEmpty()) {
            jsonMap.put("description", section.getDescription());
        }
        if ((choices = section.getChoices()) != null && !choices.isEmpty()) {
            ArrayList<Map> choicesList = new ArrayList<Map>();
            for (BaseRequirementSection choice : choices) {
                AConfigSection specificSection = this.getSpecificRequirementSection(choice);
                if (specificSection != null) {
                    String choiceJson = this.convertSectionToJson(specificSection);
                    Map choiceMap = (Map)this.OBJECT_MAPPER.readValue(choiceJson, Map.class);
                    choicesList.add(choiceMap);
                    continue;
                }
                this.LOGGER.warning("Could not determine specific requirement type for choice in choice requirement");
            }
            jsonMap.put("choices", choicesList);
        } else {
            jsonMap.put("choices", new ArrayList());
        }
    }

    private void addAchievementProperties(Map<String, Object> jsonMap, AchievementRequirementSection section) {
        jsonMap.put("requireAll", section.getRequireAll());
        String achievementPlugin = section.getAchievementPlugin();
        if (achievementPlugin == null || achievementPlugin.trim().isEmpty()) {
            achievementPlugin = "advancedachievements";
        }
        jsonMap.put("achievementPlugin", achievementPlugin);
        List<String> requiredAchievements = section.getRequiredAchievements();
        if (requiredAchievements != null && !requiredAchievements.isEmpty()) {
            jsonMap.put("requiredAchievements", requiredAchievements);
        } else {
            jsonMap.put("requiredAchievements", List.of("default_achievement"));
        }
    }

    private void addSkillProperties(Map<String, Object> jsonMap, SkillRequirementSection section) {
        jsonMap.put("consumeOnComplete", section.getConsumeOnComplete());
        String skillPlugin = section.getSkillPlugin();
        if (skillPlugin != null) {
            switch (skillPlugin = skillPlugin.toUpperCase()) {
                case "MCMMO": {
                    skillPlugin = "MCMMO";
                    break;
                }
                case "ECO_SKILLS": 
                case "ECOSKILLS": {
                    skillPlugin = "ECO_SKILLS";
                    break;
                }
                case "AURA_SKILLS": 
                case "AURASKILLS": {
                    skillPlugin = "AURA_SKILLS";
                    break;
                }
                default: {
                    skillPlugin = "AUTO";
                    break;
                }
            }
        } else {
            skillPlugin = "AUTO";
        }
        jsonMap.put("skillPlugin", skillPlugin);
        Map<String, Integer> requiredSkills = section.getRequiredSkills();
        if (requiredSkills != null && !requiredSkills.isEmpty()) {
            jsonMap.put("requiredSkills", requiredSkills);
        } else {
            HashMap<String, Integer> defaultSkills = new HashMap<String, Integer>();
            defaultSkills.put("mining", 10);
            jsonMap.put("requiredSkills", defaultSkills);
        }
    }

    private void addJobProperties(Map<String, Object> jsonMap, JobRequirementSection section) {
        jsonMap.put("consumeOnComplete", section.getConsumeOnComplete());
        jsonMap.put("requireAll", section.getRequireAll());
        String jobPlugin = section.getJobPlugin();
        if (jobPlugin != null) {
            switch (jobPlugin = jobPlugin.toUpperCase()) {
                case "JOBS": 
                case "JOBS_REBORN": 
                case "JOBSREBORN": {
                    jobPlugin = "JOBS_REBORN";
                    break;
                }
                case "ECO_JOBS": 
                case "ECOJOBS": {
                    jobPlugin = "ECO_JOBS";
                    break;
                }
                default: {
                    jobPlugin = "AUTO";
                    break;
                }
            }
        } else {
            jobPlugin = "AUTO";
        }
        jsonMap.put("jobPlugin", jobPlugin);
        Map<String, Integer> requiredJobs = section.getRequiredJobs();
        if (requiredJobs != null && !requiredJobs.isEmpty()) {
            jsonMap.put("requiredJobs", requiredJobs);
        } else {
            HashMap<String, Integer> defaultJobs = new HashMap<String, Integer>();
            defaultJobs.put("miner", 10);
            jsonMap.put("requiredJobs", defaultJobs);
        }
    }

    private void addTimeBasedProperties(Map<String, Object> jsonMap, TimeBasedRequirementSection section) {
        long timeConstraint = Math.max(1L, section.getTimeConstraintSeconds());
        jsonMap.put("timeConstraintSeconds", timeConstraint);
        jsonMap.put("cooldownSeconds", Math.max(0L, section.getCooldownSeconds()));
        String timeZone = section.getTimeZone();
        if (timeZone == null || timeZone.trim().isEmpty()) {
            timeZone = "UTC";
        }
        jsonMap.put("timeZone", timeZone);
        jsonMap.put("recurring", section.getRecurring());
        jsonMap.put("useRealTime", section.getUseRealTime());
        if (section.getStartTime() != null) {
            jsonMap.put("startTime", section.getStartTime());
        }
        if (section.getEndTime() != null) {
            jsonMap.put("endTime", section.getEndTime());
        }
        if (section.getActiveDays() != null && !section.getActiveDays().isEmpty()) {
            jsonMap.put("activeDays", section.getActiveDays());
        }
        if (section.getActiveDates() != null && !section.getActiveDates().isEmpty()) {
            jsonMap.put("activeDates", section.getActiveDates());
        }
    }

    private Material determineShowcaseMaterial(BaseRequirementSection requirementSection) {
        try {
            return Material.valueOf((String)requirementSection.getIcon().getMaterial());
        }
        catch (Exception exception) {
            String type = requirementSection.getType();
            if (type != null) {
                return switch (type.toUpperCase()) {
                    case "ITEM" -> Material.CHEST;
                    case "CURRENCY" -> Material.GOLD_INGOT;
                    case "EXPERIENCE_LEVEL" -> Material.EXPERIENCE_BOTTLE;
                    case "PERMISSION" -> Material.NAME_TAG;
                    case "LOCATION" -> Material.COMPASS;
                    case "CUSTOM" -> Material.COMMAND_BLOCK;
                    case "COMPOSITE" -> Material.REDSTONE;
                    case "CHOICE" -> Material.CROSSBOW;
                    case "TIME_BASED" -> Material.CLOCK;
                    case "JOBS" -> Material.IRON_PICKAXE;
                    case "SKILLS" -> Material.ENCHANTED_BOOK;
                    case "ACHIEVEMENT" -> Material.DIAMOND;
                    case "PLAYTIME" -> Material.CLOCK;
                    case "PREVIOUS_LEVEL" -> Material.LADDER;
                    default -> Material.PAPER;
                };
            }
            return Material.PAPER;
        }
    }
}

