/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.utility;

import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryExecutor {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long RETRY_DELAY_MS = 1000L;
    private static final Logger LOGGER = CentralLogger.getLogger(RetryExecutor.class);

    public <T> T executeWithRetry(Supplier<T> operation, String operationName) {
        Exception lastException = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                return operation.get();
            }
            catch (Exception exception) {
                lastException = exception;
                LOGGER.log(Level.WARNING, "Attempt " + attempt + "/3 failed for " + operationName + ": " + exception.getMessage());
                if (attempt >= 3) continue;
                try {
                    Thread.sleep(1000L * (long)attempt);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted during retry delay", ie);
                }
            }
        }
        throw new RuntimeException("Failed to " + operationName + " after 3 attempts", lastException);
    }
}

