/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.utility;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {
    private final Map<String, Long> cooldowns = new ConcurrentHashMap<String, Long>();

    public boolean isOnCooldown(String key, long cooldownMillis) {
        Long lastUsed = this.cooldowns.get(key);
        if (lastUsed == null) {
            return false;
        }
        return System.currentTimeMillis() - lastUsed < cooldownMillis;
    }

    public long getRemainingCooldown(String key, long cooldownMillis) {
        Long lastUsed = this.cooldowns.get(key);
        if (lastUsed == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - lastUsed;
        long remaining = cooldownMillis - elapsed;
        return Math.max(0L, remaining);
    }

    public void resetCooldown(String key) {
        this.cooldowns.put(key, System.currentTimeMillis());
    }

    public void clearCooldown(String key) {
        this.cooldowns.remove(key);
    }
}

