/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.type;

import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public enum EPerkState {
    LOCKED("locked", "Locked", Material.BARRIER, "\u00a7c", false, false),
    AVAILABLE("available", "Available", Material.LIME_DYE, "\u00a7a", true, false),
    ACTIVE("active", "Active", Material.GREEN_DYE, "\u00a72", true, true),
    COOLDOWN("cooldown", "On Cooldown", Material.CLOCK, "\u00a76", true, false),
    DISABLED("disabled", "Disabled", Material.REDSTONE, "\u00a78", false, false);

    private final String identifier;
    private final String displayName;
    private final Material iconMaterial;
    private final String colorCode;
    private final boolean isUsable;
    private final boolean isActive;

    private EPerkState(@NotNull String identifier, @NotNull String displayName, Material iconMaterial, String colorCode, boolean isUsable, boolean isActive) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.iconMaterial = iconMaterial;
        this.colorCode = colorCode;
        this.isUsable = isUsable;
        this.isActive = isActive;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Material getIconMaterial() {
        return this.iconMaterial;
    }

    @NotNull
    public String getColorCode() {
        return this.colorCode;
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @NotNull
    public String getDisplayNameKey() {
        return "perk.state." + this.identifier + ".name";
    }

    @NotNull
    public String getDescriptionKey() {
        return "perk.state." + this.identifier + ".description";
    }

    @NotNull
    public String getColoredDisplayName() {
        return this.colorCode + this.displayName;
    }

    public static EPerkState fromIdentifier(@NotNull String identifier) {
        for (EPerkState state : EPerkState.values()) {
            if (!state.getIdentifier().equalsIgnoreCase(identifier)) continue;
            return state;
        }
        return null;
    }
}

