/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.type;

import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public enum EPerkCategory {
    COMBAT("combat", "Combat", Material.DIAMOND_SWORD, 0),
    MOVEMENT("movement", "Movement", Material.FEATHER, 1),
    UTILITY("utility", "Utility", Material.COMPASS, 2),
    SURVIVAL("survival", "Survival", Material.GOLDEN_APPLE, 3),
    ECONOMY("economy", "Economy", Material.EMERALD, 4),
    SOCIAL("social", "Social", Material.PLAYER_HEAD, 5),
    COSMETIC("cosmetic", "Cosmetic", Material.FIREWORK_ROCKET, 6),
    SPECIAL("special", "Special", Material.NETHER_STAR, 7);

    private final String identifier;
    private final String displayName;
    private final Material iconMaterial;
    private final int sortOrder;

    private EPerkCategory(@NotNull String identifier, String displayName, Material iconMaterial, int sortOrder) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.iconMaterial = iconMaterial;
        this.sortOrder = sortOrder;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Material getIconMaterial() {
        return this.iconMaterial;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    @NotNull
    public String getDisplayNameKey() {
        return "perk.category." + this.identifier + ".name";
    }

    @NotNull
    public String getDescriptionKey() {
        return "perk.category." + this.identifier + ".description";
    }

    public static EPerkCategory fromIdentifier(@NotNull String identifier) {
        for (EPerkCategory category : EPerkCategory.values()) {
            if (!category.getIdentifier().equalsIgnoreCase(identifier)) continue;
            return category;
        }
        return null;
    }
}

