/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.service;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class RankUpgradeProgressService {
    private static final Logger LOGGER = CentralLogger.getLogger(RankUpgradeProgressService.class.getName());
    private final RDQ rdq;

    public RankUpgradeProgressService(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    public void initializeProgressForRank(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = targetRank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                LOGGER.log(Level.FINE, "No upgrade requirements found for rank " + targetRank.getIdentifier());
                return;
            }
            for (RRankUpgradeRequirement upgradeRequirement : upgradeRequirements) {
                this.initializeProgressForRequirement(player, upgradeRequirement);
            }
            LOGGER.log(Level.INFO, "Initialized progress tracking for " + upgradeRequirements.size() + " requirements for rank " + targetRank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize progress for rank " + targetRank.getIdentifier(), exception);
        }
    }

    private void initializeProgressForRequirement(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        try {
            List existingProgress = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", upgradeRequirement.getId()));
            if (existingProgress.isEmpty()) {
                RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(player, upgradeRequirement);
                this.rdq.getPlayerRankUpgradeProgressRepository().create(newProgress);
                LOGGER.log(Level.FINE, "Created progress tracking for requirement " + upgradeRequirement.getId());
            } else {
                LOGGER.log(Level.FINE, "Progress tracking already exists for requirement " + upgradeRequirement.getId());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to initialize progress for requirement " + upgradeRequirement.getId(), exception);
        }
    }

    public List<RPlayerRankUpgradeProgress> getProgressForRank(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = targetRank.getUpgradeRequirements();
            return this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId())).stream().filter(progress -> upgradeRequirements.contains(progress.getUpgradeRequirement())).toList();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get progress for rank " + targetRank.getIdentifier(), exception);
            return List.of();
        }
    }

    public boolean hasCompletedAllUpgradeRequirements(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = targetRank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                return true;
            }
            for (RRankUpgradeRequirement upgradeRequirement : upgradeRequirements) {
                if (this.hasCompletedUpgradeRequirement(player, upgradeRequirement)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check completion for rank " + targetRank.getIdentifier(), exception);
            return false;
        }
    }

    public boolean hasCompletedUpgradeRequirement(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        try {
            List progressList = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", upgradeRequirement.getId()));
            return !progressList.isEmpty() && ((RPlayerRankUpgradeProgress)progressList.get(0)).isCompleted();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check completion for requirement " + upgradeRequirement.getId(), exception);
            return false;
        }
    }

    public void updateProgress(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement, double newProgress) {
        try {
            RPlayerRankUpgradeProgress progress = this.getOrCreateProgress(player, upgradeRequirement);
            double oldProgress = progress.getProgress();
            progress.setProgress(newProgress);
            this.rdq.getPlayerRankUpgradeProgressRepository().update(progress);
            LOGGER.log(Level.FINE, "Updated progress for requirement " + upgradeRequirement.getId() + " from " + oldProgress + " to " + newProgress);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to update progress for requirement " + upgradeRequirement.getId(), exception);
        }
    }

    public void incrementProgress(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement, double incrementAmount) {
        try {
            RPlayerRankUpgradeProgress progress = this.getOrCreateProgress(player, upgradeRequirement);
            double oldProgress = progress.getProgress();
            double newProgress = progress.incrementProgress(incrementAmount);
            this.rdq.getPlayerRankUpgradeProgressRepository().update(progress);
            LOGGER.log(Level.FINE, "Incremented progress for requirement " + upgradeRequirement.getId() + " from " + oldProgress + " to " + newProgress + " (+" + incrementAmount + ")");
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to increment progress for requirement " + upgradeRequirement.getId(), exception);
        }
    }

    private RPlayerRankUpgradeProgress getOrCreateProgress(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        List progressList = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", upgradeRequirement.getId()));
        if (!progressList.isEmpty()) {
            return (RPlayerRankUpgradeProgress)progressList.get(0);
        }
        RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(player, upgradeRequirement);
        this.rdq.getPlayerRankUpgradeProgressRepository().create(newProgress);
        return newProgress;
    }

    public RPlayerRankUpgradeProgress getProgressForRequirement(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        try {
            List progressList = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId(), "upgradeRequirement.id", upgradeRequirement.getId()));
            return progressList.isEmpty() ? null : (RPlayerRankUpgradeProgress)progressList.get(0);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get progress for requirement " + upgradeRequirement.getId(), exception);
            return null;
        }
    }

    public void clearProgressForRank(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        try {
            List<RPlayerRankUpgradeProgress> progressEntries = this.getProgressForRank(player, targetRank);
            for (RPlayerRankUpgradeProgress progress : progressEntries) {
                this.rdq.getPlayerRankUpgradeProgressRepository().delete(progress.getId());
            }
            LOGGER.log(Level.INFO, "Cleared " + progressEntries.size() + " progress entries for rank " + targetRank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to clear progress for rank " + targetRank.getIdentifier(), exception);
        }
    }

    public void resetProgressForRequirement(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        try {
            RPlayerRankUpgradeProgress progress = this.getProgressForRequirement(player, upgradeRequirement);
            if (progress != null) {
                progress.resetProgress();
                this.rdq.getPlayerRankUpgradeProgressRepository().update(progress);
                LOGGER.log(Level.FINE, "Reset progress for requirement " + upgradeRequirement.getId());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to reset progress for requirement " + upgradeRequirement.getId(), exception);
        }
    }

    public double getOverallCompletionPercentage(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        try {
            Set<RRankUpgradeRequirement> upgradeRequirements = targetRank.getUpgradeRequirements();
            if (upgradeRequirements.isEmpty()) {
                return 1.0;
            }
            double totalProgress = 0.0;
            for (RRankUpgradeRequirement upgradeRequirement : upgradeRequirements) {
                RPlayerRankUpgradeProgress progress = this.getProgressForRequirement(player, upgradeRequirement);
                if (progress == null) continue;
                totalProgress += progress.getProgress();
            }
            return totalProgress / (double)upgradeRequirements.size();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to calculate completion percentage for rank " + targetRank.getIdentifier(), exception);
            return 0.0;
        }
    }

    public CompletableFuture<Void> initializeProgressForRankAsync(@NotNull RDQPlayer player, @NotNull RRank targetRank) {
        return CompletableFuture.runAsync(() -> this.initializeProgressForRank(player, targetRank), this.rdq.getExecutor());
    }

    public CompletableFuture<Void> updateProgressAsync(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement, double newProgress) {
        return CompletableFuture.runAsync(() -> this.updateProgress(player, upgradeRequirement, newProgress), this.rdq.getExecutor());
    }
}

