/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.service;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankPath;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.view.ranks.interaction.RankProgressionManager;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankPathService {
    private static final Logger LOGGER = CentralLogger.getLogger(RankPathService.class.getName());
    private final RDQ rdq;
    private final RankProgressionManager progressionManager;

    public RankPathService(@NotNull RDQ rdq) {
        this.rdq = rdq;
        this.progressionManager = new RankProgressionManager(rdq);
    }

    public void assignDefaultRank(@NotNull RDQPlayer player, @NotNull RRank defaultRank) {
        try {
            RPlayerRank defaultPlayerRank = new RPlayerRank(player, defaultRank);
            player.addPlayerRank(defaultPlayerRank);
            this.rdq.getPlayerRepository().update(player);
            this.rdq.getPlayerRankRepository().create(defaultPlayerRank);
            LOGGER.log(Level.INFO, "Assigned default rank " + defaultRank.getIdentifier() + " to player " + player.getPlayerName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to assign default rank to player " + player.getPlayerName(), exception);
            throw new RuntimeException("Failed to assign default rank", exception);
        }
    }

    public boolean selectRankPath(@NotNull RDQPlayer player, @NotNull RRankTree selectedRankTree, @NotNull RRank startingRank) {
        try {
            if (!selectedRankTree.isEnabled()) {
                LOGGER.log(Level.WARNING, "Attempted to select disabled rank tree: {}", selectedRankTree.getIdentifier());
                return false;
            }
            if (!this.checkRankTreePrerequisites(player, selectedRankTree)) {
                LOGGER.log(Level.INFO, "Player " + player.getPlayerName() + " does not meet prerequisites for rank tree: " + selectedRankTree.getIdentifier());
                return false;
            }
            this.deactivateAllRankPaths(player);
            RPlayerRankPath existingRankPath = this.getRankPathForTree(player, selectedRankTree);
            if (existingRankPath != null) {
                RPlayerRankPath freshRankPath = this.rdq.getPlayerRankPathRepository().findById(existingRankPath.getId()).orElse(null);
                if (freshRankPath != null) {
                    freshRankPath.setActive(true);
                    this.rdq.getPlayerRankPathRepository().update(freshRankPath);
                }
            } else {
                RPlayerRankPath newRankPath = new RPlayerRankPath(player, selectedRankTree);
                newRankPath.setActive(true);
                this.rdq.getPlayerRankPathRepository().create(newRankPath);
            }
            this.handleRankAssignmentForTree(player, selectedRankTree, startingRank);
            this.progressionManager.assignInitialRankForPath(player, selectedRankTree);
            this.progressionManager.processAutoCompletableRanks(player, selectedRankTree);
            LOGGER.log(Level.INFO, "Successfully selected rank path " + selectedRankTree.getIdentifier() + " for player " + player.getPlayerName());
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to select rank path for player " + player.getPlayerName(), exception);
            return false;
        }
    }

    public boolean switchRankPath(@NotNull RDQPlayer player, @NotNull RRankTree newRankTree, @NotNull RRank startingRank) {
        try {
            if (!this.checkRankTreePrerequisites(player, newRankTree)) {
                LOGGER.log(Level.INFO, "Player " + player.getPlayerName() + " cannot switch to rank tree " + newRankTree.getIdentifier() + " - prerequisites not met");
                return false;
            }
            return this.selectRankPath(player, newRankTree, startingRank);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to switch rank path for player " + player.getPlayerName(), exception);
            return false;
        }
    }

    private void deactivateAllRankPaths(@NotNull RDQPlayer player) {
        try {
            List allRankPaths = this.rdq.getPlayerRankPathRepository().findAllByAttributes(Map.of("player", player));
            for (RPlayerRankPath rankPath : allRankPaths) {
                RPlayerRankPath freshRankPath;
                if (!rankPath.isActive() || (freshRankPath = (RPlayerRankPath)this.rdq.getPlayerRankPathRepository().findById(rankPath.getId()).orElse(null)) == null || !freshRankPath.isActive()) continue;
                freshRankPath.setActive(false);
                this.rdq.getPlayerRankPathRepository().update(freshRankPath);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to deactivate all rank paths for player " + player.getPlayerName(), exception);
        }
    }

    @Nullable
    private RPlayerRankPath getRankPathForTree(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        return this.rdq.getPlayerRankPathRepository().findByAttributes(Map.of("player", player, "selectedRankPath", rankTree)).orElse(null);
    }

    private void handleRankAssignmentForTree(@NotNull RDQPlayer player, @NotNull RRankTree rankTree, @NotNull RRank startingRank) {
        try {
            this.deactivateAllPlayerRanks(player);
            RPlayerRank existingRankInTree = this.getPlayerRankForTree(player, rankTree);
            if (existingRankInTree != null) {
                RPlayerRank freshRank = this.rdq.getPlayerRankRepository().findById(existingRankInTree.getId()).orElse(null);
                if (freshRank != null) {
                    freshRank.setActive(true);
                    this.rdq.getPlayerRankRepository().update(freshRank);
                    LOGGER.log(Level.INFO, "Reactivated existing rank for player " + player.getPlayerName() + " in tree " + rankTree.getIdentifier());
                }
            } else {
                RDQPlayer freshPlayer = this.rdq.getPlayerRepository().findById(player.getId()).orElse(player);
                RPlayerRank newPlayerRank = new RPlayerRank(freshPlayer, startingRank, rankTree);
                this.rdq.getPlayerRankRepository().create(newPlayerRank);
                LOGGER.log(Level.INFO, "Created new rank assignment for player " + freshPlayer.getPlayerName() + " in tree " + rankTree.getIdentifier());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to handle rank assignment for tree", exception);
            throw new RuntimeException("Rank assignment failed", exception);
        }
    }

    private void deactivateAllPlayerRanks(@NotNull RDQPlayer player) {
        try {
            List allPlayerRanks = this.rdq.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId()));
            for (RPlayerRank playerRank : allPlayerRanks) {
                RPlayerRank freshRank;
                if (!playerRank.isActive() || (freshRank = (RPlayerRank)this.rdq.getPlayerRankRepository().findById(playerRank.getId()).orElse(null)) == null || !freshRank.isActive()) continue;
                freshRank.setActive(false);
                this.rdq.getPlayerRankRepository().update(freshRank);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to deactivate all player ranks for player " + player.getPlayerName(), exception);
        }
    }

    @Nullable
    private RPlayerRank getPlayerRankForTree(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        try {
            List playerRanks = this.rdq.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId()));
            return playerRanks.stream().filter(rank -> {
                RRankTree playerRankTree = rank.getRankTree();
                return playerRankTree != null && Objects.equals(playerRankTree, rankTree);
            }).findFirst().orElse(null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get player rank for tree", exception);
            return null;
        }
    }

    private boolean checkRankTreePrerequisites(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        try {
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check rank tree prerequisites", exception);
            return false;
        }
    }

    @Nullable
    private RPlayerRankPath getCurrentRankPath(@NotNull RDQPlayer player) {
        try {
            List rankPaths = this.rdq.getPlayerRankPathRepository().findAllByAttributes(Map.of("player", player));
            return rankPaths.stream().filter(RPlayerRankPath::isActive).findFirst().orElse(null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get current rank path", exception);
            return null;
        }
    }

    private int getCompletedRankTreesCount(@NotNull RDQPlayer player) {
        try {
            return 0;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get completed rank trees count", exception);
            return 0;
        }
    }

    private boolean isRankTreeCompleted(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        try {
            return false;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if rank tree is completed", exception);
            return false;
        }
    }

    public boolean hasSelectedRankPath(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        try {
            RPlayerRankPath rankPath = this.getRankPathForTree(player, rankTree);
            return rankPath != null && rankPath.isActive();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if player has selected rank path", exception);
            return false;
        }
    }

    public void cleanupLegacyRanks(@NotNull RDQPlayer player) {
        try {
            LOGGER.log(Level.FINE, "Cleaned up legacy ranks for player {}", player.getPlayerName());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to cleanup legacy ranks", exception);
        }
    }

    public List<RPlayerRank> getPlayerRanksForTree(@NotNull RDQPlayer player, @Nullable RRankTree rankTree) {
        try {
            List<RPlayerRank> allPlayerRanks = this.rdq.getPlayerRankRepository().findAllByAttributes(Map.of("player.uniqueId", player.getUniqueId()));
            if (rankTree == null) {
                return allPlayerRanks;
            }
            return allPlayerRanks.stream().filter(rank -> Objects.equals(rank.getRankTree(), rankTree)).toList();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get player ranks for tree", exception);
            return List.of();
        }
    }
}

