/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.reward;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.reward.AbstractReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ItemReward
extends AbstractReward {
    @JsonProperty(value="item")
    private final ItemStack item;
    @JsonProperty(value="estimatedValue")
    private final double estimatedValue;
    @JsonProperty(value="amount")
    private Integer amount;

    @JsonCreator
    public ItemReward(@JsonProperty(value="item") @NotNull ItemStack item, @JsonProperty(value="estimatedValue") double estimatedValue) {
        super(Reward.Type.ITEM, "reward.item");
        this.amount = item.getAmount();
        this.item = item.clone();
        this.item.setAmount(1);
        this.estimatedValue = estimatedValue;
        if (this.item.getAmount() != 1) {
            throw new IllegalStateException("ItemReward item field must have amount=1 for serialization, but was: " + this.item.getAmount());
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> grant(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            ItemStack itemToGive = this.getItem();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{itemToGive});
            if (!leftover.isEmpty()) {
                leftover.values().forEach(i -> player.getWorld().dropItem(player.getLocation(), i));
            }
            return true;
        });
    }

    @Override
    public double getEstimatedValue() {
        return this.estimatedValue;
    }

    @JsonIgnore
    public ItemStack getItem() {
        ItemStack result = this.item.clone();
        result.setAmount(this.amount != null ? this.amount : 1);
        return result;
    }

    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @Generated
    public void setAmount(Integer amount) {
        this.amount = amount;
    }
}

