/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.reward;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.reward.AbstractReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExperienceReward
extends AbstractReward {
    @JsonProperty(value="amount")
    private final int amount;
    @JsonProperty(value="experienceType")
    private final ExperienceType experienceType;

    public ExperienceReward(int levels) {
        this(levels, ExperienceType.LEVELS);
    }

    @JsonCreator
    public ExperienceReward(@JsonProperty(value="amount") int amount, @JsonProperty(value="experienceType") @Nullable ExperienceType experienceType) {
        super(Reward.Type.EXPERIENCE, "reward.experience");
        if (amount <= 0) {
            throw new IllegalArgumentException("Experience amount must be positive: " + amount);
        }
        this.amount = amount;
        this.experienceType = experienceType != null ? experienceType : ExperienceType.LEVELS;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> grant(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            switch (this.experienceType.ordinal()) {
                case 0: {
                    player.giveExpLevels(this.amount);
                    break;
                }
                case 1: {
                    player.giveExp(this.amount);
                }
            }
            return true;
        });
    }

    @Override
    public double getEstimatedValue() {
        return this.experienceType == ExperienceType.LEVELS ? (double)this.amount * 10.0 : (double)this.amount * 0.1;
    }

    public int getAmount() {
        return this.amount;
    }

    @NotNull
    public ExperienceType getExperienceType() {
        return this.experienceType;
    }

    public static enum ExperienceType {
        LEVELS,
        POINTS;

    }
}

