/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.reward;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.reward.AbstractReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class CompositeReward
extends AbstractReward {
    private static final Logger LOGGER = Logger.getLogger(CompositeReward.class.getName());
    @JsonProperty(value="rewards")
    private final List<AbstractReward> rewards;
    @JsonProperty(value="continueOnError")
    private final boolean continueOnError;

    public CompositeReward(@NotNull List<AbstractReward> rewards) {
        this(rewards, true);
    }

    @JsonCreator
    public CompositeReward(@JsonProperty(value="rewards") @NotNull List<AbstractReward> rewards, @JsonProperty(value="continueOnError") boolean continueOnError) {
        super(Reward.Type.COMPOSITE, "reward.composite");
        if (rewards.isEmpty()) {
            throw new IllegalArgumentException("Rewards list cannot be null or empty");
        }
        this.rewards = new ArrayList<AbstractReward>(rewards);
        this.continueOnError = continueOnError;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> grant(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            for (AbstractReward reward : this.rewards) {
                try {
                    reward.grant(player).join();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to apply sub-reward in composite reward", exception);
                    if (this.continueOnError) continue;
                    return false;
                }
            }
            return true;
        });
    }

    @Override
    public double getEstimatedValue() {
        return this.rewards.stream().mapToDouble(Reward::getEstimatedValue).sum();
    }

    @NotNull
    public List<AbstractReward> getRewards() {
        return new ArrayList<AbstractReward>(this.rewards);
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    @JsonIgnore
    public int getRewardCount() {
        return this.rewards.size();
    }

    @JsonIgnore
    public void validate() {
        if (this.rewards.isEmpty()) {
            throw new IllegalStateException("CompositeReward must have at least one sub-reward");
        }
        for (int i = 0; i < this.rewards.size(); ++i) {
            AbstractReward reward = this.rewards.get(i);
            if (reward != null) continue;
            throw new IllegalStateException("Sub-reward at index " + i + " is null");
        }
    }
}

