/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.reward;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.reward.AbstractReward;
import com.raindropcentral.rdq.reward.Reward;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class CommandReward
extends AbstractReward {
    private static final Logger LOGGER = Logger.getLogger(CommandReward.class.getName());
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%([a-zA-Z_]+)%");
    @JsonProperty(value="command")
    private final String command;
    @JsonProperty(value="executeAsPlayer")
    private final boolean executeAsPlayer;
    @JsonProperty(value="delay")
    private final long delayTicks;

    public CommandReward(@NotNull String command) {
        this(command, false, 0L);
    }

    @JsonCreator
    public CommandReward(@JsonProperty(value="command") @NotNull String command, @JsonProperty(value="executeAsPlayer") boolean executeAsPlayer, @JsonProperty(value="delay") long delayTicks) {
        super(Reward.Type.COMMAND, "reward.command");
        if (command == null || command.trim().isEmpty()) {
            throw new IllegalArgumentException("Command cannot be null or empty");
        }
        this.command = command;
        this.executeAsPlayer = executeAsPlayer;
        this.delayTicks = Math.max(0L, delayTicks);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> grant(@NotNull Player player) {
        return CompletableFuture.supplyAsync(() -> {
            String processedCommand = this.replacePlaceholders(this.command, player);
            if (this.delayTicks > 0L) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin("RaindropQuests");
                if (plugin instanceof RDQ) {
                    RDQ rdq = (RDQ)plugin;
                    rdq.getPlatform().getScheduler().runDelayed(() -> this.executeCommand(player, processedCommand), this.delayTicks);
                } else {
                    this.executeCommand(player, processedCommand);
                }
            } else {
                this.executeCommand(player, processedCommand);
            }
            return true;
        });
    }

    @Override
    public double getEstimatedValue() {
        return 0.0;
    }

    @NotNull
    public String getCommand() {
        return this.command;
    }

    public boolean isExecuteAsPlayer() {
        return this.executeAsPlayer;
    }

    public long getDelayTicks() {
        return this.delayTicks;
    }

    private void executeCommand(@NotNull Player player, @NotNull String command) {
        try {
            if (this.executeAsPlayer) {
                player.performCommand(command);
            } else {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to execute command reward: " + command, exception);
        }
    }

    @NotNull
    private String replacePlaceholders(@NotNull String input, @NotNull Player player) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Location location = player.getLocation();
        placeholders.put("player", player.getName());
        placeholders.put("player_name", player.getName());
        placeholders.put("uniqueId", player.getUniqueId().toString());
        placeholders.put("world", player.getWorld().getName());
        placeholders.put("x", String.valueOf(location.getBlockX()));
        placeholders.put("y", String.valueOf(location.getBlockY()));
        placeholders.put("z", String.valueOf(location.getBlockZ()));
        placeholders.put("level", String.valueOf(player.getLevel()));
        placeholders.put("health", String.valueOf(player.getHealth()));
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group(1).toLowerCase();
            String replacement = placeholders.getOrDefault(placeholder, matcher.group(0));
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

