/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement.plugins;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillsRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = Logger.getLogger(SkillsRequirement.class.getName());
    @JsonProperty(value="skillPlugin")
    private final SkillPlugin skillPlugin;
    @JsonProperty(value="skill")
    private final String skill;
    @JsonProperty(value="level")
    private final int level;
    @JsonProperty(value="skills")
    private final Map<String, Integer> skills;
    @JsonProperty(value="description")
    private final String description;
    @JsonIgnore
    private transient Object skillService;

    public SkillsRequirement(@Nullable String skill, int level) {
        this(SkillPlugin.AUTO, skill, level, null, null);
    }

    public SkillsRequirement(@NotNull SkillPlugin skillPlugin, @Nullable String skill, int level) {
        this(skillPlugin, skill, level, null, null);
    }

    public SkillsRequirement(@NotNull SkillPlugin skillPlugin, @NotNull Map<String, Integer> skills) {
        this(skillPlugin, null, 0, skills, null);
    }

    @JsonCreator
    public SkillsRequirement(@JsonProperty(value="skillPlugin") @Nullable SkillPlugin skillPlugin, @JsonProperty(value="skill") @Nullable String skill, @JsonProperty(value="level") int level, @JsonProperty(value="skills") @Nullable Map<String, Integer> skills, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.SKILLS);
        boolean hasMultipleSkills;
        boolean hasSingleSkill = skill != null && level > 0;
        boolean bl = hasMultipleSkills = skills != null && !skills.isEmpty();
        if (!hasSingleSkill && !hasMultipleSkills) {
            throw new IllegalArgumentException("Either a single skill with level or multiple skills must be specified.");
        }
        if (hasMultipleSkills) {
            for (Map.Entry<String, Integer> entry : skills.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                    throw new IllegalArgumentException("Skill name cannot be null or empty.");
                }
                if (entry.getValue() != null && entry.getValue() > 0) continue;
                throw new IllegalArgumentException("Skill level must be positive for skill: " + entry.getKey());
            }
        }
        this.skillPlugin = skillPlugin != null ? skillPlugin : SkillPlugin.AUTO;
        this.skill = skill;
        this.level = level;
        this.skills = skills != null ? new HashMap<String, Integer>(skills) : new HashMap();
        this.description = description;
    }

    @JsonIgnore
    @NotNull
    public static SkillsRequirement fromPluginString(@Nullable String pluginIdentifier, @Nullable String skill, int level) {
        SkillPlugin plugin = SkillPlugin.fromIdentifier(pluginIdentifier);
        return new SkillsRequirement(plugin, skill, level, null, null);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        Object service = this.getSkillService();
        if (service == null) {
            LOGGER.log(Level.WARNING, "Skill service not available for plugin: " + String.valueOf((Object)this.skillPlugin));
            return false;
        }
        if (!this.skills.isEmpty()) {
            return this.skills.entrySet().stream().allMatch(entry -> this.checkSingleSkill(player, service, (String)entry.getKey(), (Integer)entry.getValue()));
        }
        if (this.skill != null) {
            return this.checkSingleSkill(player, service, this.skill, this.level);
        }
        return false;
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        Object service = this.getSkillService();
        if (service == null) {
            LOGGER.log(Level.WARNING, "Skill service not available for plugin: " + String.valueOf((Object)this.skillPlugin));
            return 0.0;
        }
        if (!this.skills.isEmpty()) {
            double totalProgress = 0.0;
            for (Map.Entry<String, Integer> entry : this.skills.entrySet()) {
                double skillProgress = this.calculateSingleSkillProgress(player, service, entry.getKey(), entry.getValue());
                totalProgress += skillProgress;
            }
            return Math.min(1.0, totalProgress / (double)this.skills.size());
        }
        if (this.skill != null) {
            return this.calculateSingleSkillProgress(player, service, this.skill, this.level);
        }
        return 0.0;
    }

    @Override
    public void consume(@NotNull Player player) {
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.skills." + this.skillPlugin.getIdentifier();
    }

    @NotNull
    public SkillPlugin getSkillPlugin() {
        return this.skillPlugin;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public String getSkill() {
        return this.skill;
    }

    @NotNull
    public Map<String, Integer> getSkills() {
        return Collections.unmodifiableMap(this.skills);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    @NotNull
    public Map<String, Integer> getCurrentSkillLevels(@NotNull Player player) {
        Object service = this.getSkillService();
        if (service == null) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> currentLevels = new HashMap<String, Integer>();
        if (!this.skills.isEmpty()) {
            for (String skillName : this.skills.keySet()) {
                int currentLevel = this.getCurrentSkillLevel(player, service, skillName);
                currentLevels.put(skillName, currentLevel);
            }
        }
        if (this.skill != null) {
            int currentLevel = this.getCurrentSkillLevel(player, service, this.skill);
            currentLevels.put(this.skill, currentLevel);
        }
        return currentLevels;
    }

    @JsonIgnore
    public boolean isMultipleSkills() {
        return !this.skills.isEmpty();
    }

    @JsonIgnore
    public boolean isTotalSkillLevel() {
        return this.skill != null && this.skill.equalsIgnoreCase("total");
    }

    @JsonIgnore
    @Nullable
    public SkillPlugin getDetectedSkillPlugin() {
        if (this.skillPlugin != SkillPlugin.AUTO) {
            return this.skillPlugin;
        }
        if (Bukkit.getPluginManager().getPlugin("EcoSkills") != null) {
            return SkillPlugin.ECO_SKILLS;
        }
        if (Bukkit.getPluginManager().getPlugin("mcMMO") != null) {
            return SkillPlugin.MCMMO;
        }
        return null;
    }

    @JsonIgnore
    public void validate() {
        SkillPlugin detectedPlugin;
        boolean hasMultipleSkills;
        boolean hasSingleSkill = this.skill != null && this.level > 0;
        boolean bl = hasMultipleSkills = !this.skills.isEmpty();
        if (!hasSingleSkill && !hasMultipleSkills) {
            throw new IllegalStateException("Either a single skill or multiple skills must be specified.");
        }
        if (hasMultipleSkills) {
            for (Map.Entry<String, Integer> entry : this.skills.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                    throw new IllegalStateException("Skill name cannot be null or empty.");
                }
                if (entry.getValue() != null && entry.getValue() > 0) continue;
                throw new IllegalStateException("Skill level must be positive for skill: " + entry.getKey());
            }
        }
        if ((detectedPlugin = this.getDetectedSkillPlugin()) == null) {
            throw new IllegalStateException("No supported skill plugin found. Available plugins: EcoSkills, mcMMO");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Object getSkillService() {
        SkillPlugin targetPlugin;
        if (this.skillService != null) return this.skillService;
        SkillPlugin skillPlugin = targetPlugin = this.skillPlugin == SkillPlugin.AUTO ? this.getDetectedSkillPlugin() : this.skillPlugin;
        if (targetPlugin == null) {
            return null;
        }
        switch (targetPlugin.ordinal()) {
            case 0: {
                Plugin ecoSkillsPlugin = Bukkit.getPluginManager().getPlugin("EcoSkills");
                if (ecoSkillsPlugin != null && !ecoSkillsPlugin.isEnabled()) return this.skillService;
            }
            case 2: {
                Plugin mcmmoPlugin = Bukkit.getPluginManager().getPlugin("mcMMO");
                if (mcmmoPlugin != null && !mcmmoPlugin.isEnabled()) return this.skillService;
            }
        }
        return this.skillService;
    }

    private boolean checkSingleSkill(@NotNull Player player, @NotNull Object service, @NotNull String skillName, int requiredLevel) {
        if (skillName.equalsIgnoreCase("total")) {
            // empty if block
        }
        return false;
    }

    private double calculateSingleSkillProgress(@NotNull Player player, @NotNull Object service, @NotNull String skillName, int requiredLevel) {
        if (requiredLevel <= 0) {
            return 1.0;
        }
        int currentLevel = this.getCurrentSkillLevel(player, service, skillName);
        return Math.min(1.0, (double)currentLevel / (double)requiredLevel);
    }

    private int getCurrentSkillLevel(@NotNull Player player, @NotNull Object service, @NotNull String skillName) {
        if (skillName.equalsIgnoreCase("total")) {
            // empty if block
        }
        return 0;
    }

    public static enum SkillPlugin {
        ECO_SKILLS("EcoSkills", "ecoskills"),
        AURA_SKILLS("AuraSkills", "auraskills"),
        MCMMO("mcMMO", "mcmmo"),
        AUTO("Auto", "auto");

        private final String pluginName;
        private final String identifier;

        private SkillPlugin(String pluginName, String identifier) {
            this.pluginName = pluginName;
            this.identifier = identifier;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public static SkillPlugin fromIdentifier(String identifier) {
            if (identifier == null) {
                return AUTO;
            }
            for (SkillPlugin plugin : SkillPlugin.values()) {
                if (!plugin.identifier.equalsIgnoreCase(identifier)) continue;
                return plugin;
            }
            return AUTO;
        }
    }
}

