/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement.plugins;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobsRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = Logger.getLogger(JobsRequirement.class.getName());
    @JsonProperty(value="jobPlugin")
    private final JobPlugin jobPlugin;
    @JsonProperty(value="job")
    private final String job;
    @JsonProperty(value="level")
    private final int level;
    @JsonProperty(value="jobs")
    private final Map<String, Integer> jobs;
    @JsonProperty(value="description")
    private final String description;
    @JsonIgnore
    private transient Object jobService;

    public JobsRequirement(@Nullable String job, int level) {
        this(JobPlugin.AUTO, job, level, null, null);
    }

    public JobsRequirement(@NotNull JobPlugin jobPlugin, @Nullable String job, int level) {
        this(jobPlugin, job, level, null, null);
    }

    public JobsRequirement(@NotNull JobPlugin jobPlugin, @NotNull Map<String, Integer> jobs) {
        this(jobPlugin, null, 0, jobs, null);
    }

    @JsonCreator
    public JobsRequirement(@JsonProperty(value="jobPlugin") @Nullable JobPlugin jobPlugin, @JsonProperty(value="job") @Nullable String job, @JsonProperty(value="level") int level, @JsonProperty(value="jobs") @Nullable Map<String, Integer> jobs, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.JOBS);
        boolean hasMultipleJobs;
        boolean hasSingleJob = job != null && level > 0;
        boolean bl = hasMultipleJobs = jobs != null && !jobs.isEmpty();
        if (!hasSingleJob && !hasMultipleJobs) {
            throw new IllegalArgumentException("Either a single job with level or multiple jobs must be specified.");
        }
        if (hasMultipleJobs) {
            for (Map.Entry<String, Integer> entry : jobs.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                    throw new IllegalArgumentException("Job name cannot be null or empty.");
                }
                if (entry.getValue() != null && entry.getValue() > 0) continue;
                throw new IllegalArgumentException("Job level must be positive for job: " + entry.getKey());
            }
        }
        this.jobPlugin = jobPlugin != null ? jobPlugin : JobPlugin.AUTO;
        this.job = job;
        this.level = level;
        this.jobs = jobs != null ? new HashMap<String, Integer>(jobs) : new HashMap();
        this.description = description;
    }

    @JsonIgnore
    @NotNull
    public static JobsRequirement fromPluginString(@Nullable String pluginIdentifier, @Nullable String job, int level) {
        JobPlugin plugin = JobPlugin.fromIdentifier(pluginIdentifier);
        return new JobsRequirement(plugin, job, level, null, null);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        Object service = this.getJobService();
        if (service == null) {
            LOGGER.log(Level.WARNING, "Job service not available for plugin: " + String.valueOf((Object)this.jobPlugin));
            return false;
        }
        if (!this.jobs.isEmpty()) {
            return this.jobs.entrySet().stream().allMatch(entry -> this.checkSingleJob(player, service, (String)entry.getKey(), (Integer)entry.getValue()));
        }
        if (this.job != null) {
            return this.checkSingleJob(player, service, this.job, this.level);
        }
        return false;
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        Object service = this.getJobService();
        if (service == null) {
            LOGGER.log(Level.WARNING, "Job service not available for plugin: " + String.valueOf((Object)this.jobPlugin));
            return 0.0;
        }
        if (!this.jobs.isEmpty()) {
            double totalProgress = 0.0;
            for (Map.Entry<String, Integer> entry : this.jobs.entrySet()) {
                double jobProgress = this.calculateSingleJobProgress(player, service, entry.getKey(), entry.getValue());
                totalProgress += jobProgress;
            }
            return Math.min(1.0, totalProgress / (double)this.jobs.size());
        }
        if (this.job != null) {
            return this.calculateSingleJobProgress(player, service, this.job, this.level);
        }
        return 0.0;
    }

    @Override
    public void consume(@NotNull Player player) {
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.jobs." + this.jobPlugin.getIdentifier();
    }

    @NotNull
    public JobPlugin getJobPlugin() {
        return this.jobPlugin;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public String getJob() {
        return this.job;
    }

    @NotNull
    public Map<String, Integer> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    @NotNull
    public Map<String, Integer> getCurrentJobLevels(@NotNull Player player) {
        Object service = this.getJobService();
        if (service == null) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> currentLevels = new HashMap<String, Integer>();
        if (!this.jobs.isEmpty()) {
            for (String jobName : this.jobs.keySet()) {
                int currentLevel = this.getCurrentJobLevel(player, service, jobName);
                currentLevels.put(jobName, currentLevel);
            }
        }
        if (this.job != null) {
            int currentLevel = this.getCurrentJobLevel(player, service, this.job);
            currentLevels.put(this.job, currentLevel);
        }
        return currentLevels;
    }

    @JsonIgnore
    public boolean isMultipleJobs() {
        return !this.jobs.isEmpty();
    }

    @JsonIgnore
    public boolean isTotalJobLevel() {
        return this.job != null && this.job.equalsIgnoreCase("total");
    }

    @JsonIgnore
    @Nullable
    public JobPlugin getDetectedJobPlugin() {
        if (this.jobPlugin != JobPlugin.AUTO) {
            return this.jobPlugin;
        }
        if (Bukkit.getPluginManager().getPlugin("EcoJobs") != null) {
            return JobPlugin.ECO_JOBS;
        }
        if (Bukkit.getPluginManager().getPlugin("Jobs") != null) {
            return JobPlugin.JOBS_REBORN;
        }
        return null;
    }

    @JsonIgnore
    public void validate() {
        JobPlugin detectedPlugin;
        boolean hasMultipleJobs;
        boolean hasSingleJob = this.job != null && this.level > 0;
        boolean bl = hasMultipleJobs = !this.jobs.isEmpty();
        if (!hasSingleJob && !hasMultipleJobs) {
            throw new IllegalStateException("Either a single job or multiple jobs must be specified.");
        }
        if (hasMultipleJobs) {
            for (Map.Entry<String, Integer> entry : this.jobs.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                    throw new IllegalStateException("Job name cannot be null or empty.");
                }
                if (entry.getValue() != null && entry.getValue() > 0) continue;
                throw new IllegalStateException("Job level must be positive for job: " + entry.getKey());
            }
        }
        if ((detectedPlugin = this.getDetectedJobPlugin()) == null) {
            throw new IllegalStateException("No supported job plugin found. Available plugins: EcoJobs, JobsReborn");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Object getJobService() {
        JobPlugin targetPlugin;
        if (this.jobService != null) return this.jobService;
        JobPlugin jobPlugin = targetPlugin = this.jobPlugin == JobPlugin.AUTO ? this.getDetectedJobPlugin() : this.jobPlugin;
        if (targetPlugin == null) {
            return null;
        }
        switch (targetPlugin.ordinal()) {
            case 0: {
                Plugin ecoJobsPlugin = Bukkit.getPluginManager().getPlugin("EcoJobs");
                if (ecoJobsPlugin != null && !ecoJobsPlugin.isEnabled()) return this.jobService;
            }
            case 1: {
                Plugin jobsPlugin = Bukkit.getPluginManager().getPlugin("Jobs");
                if (jobsPlugin != null && !jobsPlugin.isEnabled()) return this.jobService;
            }
        }
        return this.jobService;
    }

    private boolean checkSingleJob(@NotNull Player player, @NotNull Object service, @NotNull String jobName, int requiredLevel) {
        if (jobName.equalsIgnoreCase("total")) {
            // empty if block
        }
        return false;
    }

    private double calculateSingleJobProgress(@NotNull Player player, @NotNull Object service, @NotNull String jobName, int requiredLevel) {
        if (requiredLevel <= 0) {
            return 1.0;
        }
        int currentLevel = this.getCurrentJobLevel(player, service, jobName);
        return Math.min(1.0, (double)currentLevel / (double)requiredLevel);
    }

    private int getCurrentJobLevel(@NotNull Player player, @NotNull Object service, @NotNull String jobName) {
        if (jobName.equalsIgnoreCase("total")) {
            // empty if block
        }
        return 0;
    }

    public static enum JobPlugin {
        ECO_JOBS("EcoJobs", "ecojobs"),
        JOBS_REBORN("Jobs", "jobsreborn"),
        AUTO("Auto", "auto");

        private final String pluginName;
        private final String identifier;

        private JobPlugin(String pluginName, String identifier) {
            this.pluginName = pluginName;
            this.identifier = identifier;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public static JobPlugin fromIdentifier(String identifier) {
            if (identifier == null) {
                return AUTO;
            }
            for (JobPlugin plugin : JobPlugin.values()) {
                if (!plugin.identifier.equalsIgnoreCase(identifier)) continue;
                return plugin;
            }
            return AUTO;
        }
    }
}

