/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TimedRequirement
extends AbstractRequirement {
    @JsonProperty(value="delegate")
    private final AbstractRequirement delegate;
    @JsonProperty(value="timeLimitMillis")
    private final long timeLimitMillis;
    @JsonProperty(value="autoStart")
    private final boolean autoStart;
    @JsonProperty(value="description")
    private final String description;
    @JsonIgnore
    private final AtomicLong startTimeMillis = new AtomicLong(-1L);

    public TimedRequirement(@NotNull AbstractRequirement delegate, long timeLimitSeconds) {
        this(delegate, timeLimitSeconds * 1000L, true, null);
    }

    @JsonCreator
    public TimedRequirement(@JsonProperty(value="delegate") @NotNull AbstractRequirement delegate, @JsonProperty(value="timeLimitMillis") long timeLimitMillis, @JsonProperty(value="autoStart") @Nullable Boolean autoStart, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.TIME_BASED);
        if (timeLimitMillis <= 0L) {
            throw new IllegalArgumentException("Time limit must be positive: " + timeLimitMillis);
        }
        this.delegate = delegate;
        this.timeLimitMillis = timeLimitMillis;
        this.autoStart = autoStart != null ? autoStart : true;
        this.description = description;
    }

    @JsonIgnore
    @NotNull
    public static TimedRequirement fromTimeConfig(@NotNull AbstractRequirement delegate, @Nullable Long timeSeconds, @Nullable Long timeMinutes, @Nullable Long timeHours, @Nullable Long timeDays, @Nullable Boolean autoStart, @Nullable String description) {
        int timeValuesCount = 0;
        long timeLimitMillis = 0L;
        if (timeSeconds != null && timeSeconds > 0L) {
            ++timeValuesCount;
            timeLimitMillis = TimeUnit.SECONDS.toMillis(timeSeconds);
        }
        if (timeMinutes != null && timeMinutes > 0L) {
            ++timeValuesCount;
            timeLimitMillis = TimeUnit.MINUTES.toMillis(timeMinutes);
        }
        if (timeHours != null && timeHours > 0L) {
            ++timeValuesCount;
            timeLimitMillis = TimeUnit.HOURS.toMillis(timeHours);
        }
        if (timeDays != null && timeDays > 0L) {
            ++timeValuesCount;
            timeLimitMillis = TimeUnit.DAYS.toMillis(timeDays);
        }
        if (timeValuesCount == 0) {
            throw new IllegalArgumentException("At least one time limit must be specified (seconds, minutes, hours, or days).");
        }
        if (timeValuesCount > 1) {
            throw new IllegalArgumentException("Only one time limit can be specified at a time.");
        }
        return new TimedRequirement(delegate, timeLimitMillis, autoStart, description);
    }

    public void start() {
        this.startTimeMillis.compareAndSet(-1L, System.currentTimeMillis());
    }

    public void reset() {
        this.startTimeMillis.set(-1L);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        long startTime;
        if (this.autoStart && this.startTimeMillis.get() < 0L) {
            this.start();
        }
        if ((startTime = this.startTimeMillis.get()) < 0L) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed > this.timeLimitMillis) {
            return false;
        }
        return this.delegate.isMet(player);
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        long startTime;
        if (this.autoStart && this.startTimeMillis.get() < 0L) {
            this.start();
        }
        if ((startTime = this.startTimeMillis.get()) < 0L) {
            return 0.0;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed >= this.timeLimitMillis) {
            return 0.0;
        }
        double timeFactor = (double)(this.timeLimitMillis - elapsed) / (double)this.timeLimitMillis;
        return this.delegate.calculateProgress(player) * timeFactor;
    }

    @Override
    public void consume(@NotNull Player player) {
        if (this.isMet(player)) {
            this.delegate.consume(player);
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.timed";
    }

    @NotNull
    public AbstractRequirement getDelegate() {
        return this.delegate;
    }

    public long getTimeLimitMillis() {
        return this.timeLimitMillis;
    }

    @JsonIgnore
    public long getTimeLimitSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.timeLimitMillis);
    }

    @JsonIgnore
    public long getTimeLimitMinutes() {
        return TimeUnit.MILLISECONDS.toMinutes(this.timeLimitMillis);
    }

    @JsonIgnore
    public long getTimeLimitHours() {
        return TimeUnit.MILLISECONDS.toHours(this.timeLimitMillis);
    }

    @JsonIgnore
    public long getTimeLimitDays() {
        return TimeUnit.MILLISECONDS.toDays(this.timeLimitMillis);
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis.get();
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public boolean isStarted() {
        return this.startTimeMillis.get() >= 0L;
    }

    @JsonIgnore
    public boolean isExpired() {
        long startTime = this.startTimeMillis.get();
        if (startTime < 0L) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        return elapsed > this.timeLimitMillis;
    }

    @JsonIgnore
    public long getRemainingTimeMillis() {
        long startTime = this.startTimeMillis.get();
        if (startTime < 0L) {
            return this.timeLimitMillis;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        return Math.max(0L, this.timeLimitMillis - elapsed);
    }

    @JsonIgnore
    public long getRemainingTimeSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getRemainingTimeMillis());
    }

    @JsonIgnore
    public long getElapsedTimeMillis() {
        long startTime = this.startTimeMillis.get();
        if (startTime < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    @JsonIgnore
    public long getElapsedTimeSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getElapsedTimeMillis());
    }

    @JsonIgnore
    @NotNull
    public String getFormattedStartTime() {
        long startTime = this.startTimeMillis.get();
        if (startTime < 0L) {
            return "Not started";
        }
        LocalDateTime startDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault());
        return startDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    @JsonIgnore
    @NotNull
    public String getFormattedRemainingTime() {
        long remainingMillis = this.getRemainingTimeMillis();
        if (remainingMillis <= 0L) {
            return "Expired";
        }
        Duration duration = Duration.ofMillis(remainingMillis);
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L && days == 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    @JsonIgnore
    public void validate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Delegate requirement cannot be null.");
        }
        if (this.timeLimitMillis <= 0L) {
            throw new IllegalStateException("Time limit must be positive: " + this.timeLimitMillis);
        }
        AbstractRequirement abstractRequirement = this.delegate;
        if (abstractRequirement instanceof TimedRequirement) {
            TimedRequirement timedDelegate = (TimedRequirement)abstractRequirement;
            timedDelegate.validate();
        }
    }
}

