/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.core.api.RCoreAdapter;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.statistic.StatisticType;
import com.raindropcentral.rplatform.type.EStatisticType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RStatisticRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = CentralLogger.getLogger(RStatisticRequirement.class);
    private static final long DEFAULT_TIMEOUT_MS = 75L;
    @Nullable
    private static volatile @Nullable Supplier<@Nullable RCoreAdapter> ADAPTER_SUPPLIER;
    @JsonProperty(value="plugin")
    private final String plugin;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="required_amount")
    private final double requiredAmount;
    @JsonProperty(value="mode")
    private final RequirementMode mode;
    @JsonProperty(value="starting_value")
    private volatile Double startingValue;
    @JsonProperty(value="qualifier")
    private final String qualifier;
    @JsonProperty(value="statistic_type")
    private final StatisticType.DataType statisticType;
    @JsonProperty(value="timeoutMillis")
    private final long timeoutMillis;

    public static void setAdapterSupplier(@NotNull Supplier<@Nullable RCoreAdapter> supplier) {
        ADAPTER_SUPPLIER = supplier;
    }

    public static void clearAdapterSupplier() {
        ADAPTER_SUPPLIER = null;
    }

    @JsonCreator
    public RStatisticRequirement(@JsonProperty(value="plugin") @NotNull String plugin, @JsonProperty(value="identifier") @NotNull String identifier, @JsonProperty(value="required_amount") double requiredAmount, @JsonProperty(value="mode") @NotNull RequirementMode mode, @JsonProperty(value="qualifier") @Nullable String qualifier, @JsonProperty(value="statistic_type") @NotNull StatisticType.DataType statisticType, @JsonProperty(value="starting_value") @Nullable Double startingValue, @JsonProperty(value="timeoutMillis") @Nullable Long timeoutMillis) {
        super(Requirement.Type.CUSTOM);
        this.plugin = plugin;
        this.identifier = identifier;
        this.requiredAmount = requiredAmount;
        this.mode = mode;
        this.qualifier = qualifier;
        this.statisticType = statisticType;
        this.startingValue = startingValue;
        this.timeoutMillis = timeoutMillis != null && timeoutMillis > 0L ? timeoutMillis : 75L;
    }

    public RStatisticRequirement(@NotNull String plugin, @NotNull String identifier, double requiredAmount, @NotNull StatisticType.DataType statisticType) {
        this(plugin, identifier, requiredAmount, RequirementMode.ABSOLUTE, null, statisticType, null, 75L);
    }

    public RStatisticRequirement(@NotNull String plugin, @NotNull String identifier, double requiredAmount, @NotNull StatisticType.DataType statisticType, double startingValue) {
        this(plugin, identifier, requiredAmount, RequirementMode.RELATIVE, null, statisticType, startingValue, 75L);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        try {
            double currentValue = this.getCurrentStatisticValue(player);
            double targetValue = this.getTargetValue(player);
            boolean met = currentValue >= targetValue;
            LOGGER.log(Level.FINER, String.format("Checking statistic requirement for player %s: current=%.4f, target=%.4f, met=%s [id=%s, plugin=%s, mode=%s]", new Object[]{player.getName(), currentValue, targetValue, met, this.identifier, this.plugin, this.mode}));
            return met;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check statistic requirement for player " + player.getName(), exception);
            return false;
        }
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        try {
            double progress;
            double currentValue = this.getCurrentStatisticValue(player);
            double targetValue = this.getTargetValue(player);
            if (targetValue <= 0.0) {
                return 1.0;
            }
            if (this.mode == RequirementMode.ABSOLUTE) {
                progress = currentValue / targetValue;
            } else {
                double startValue = this.getStartingValue(player);
                double gained = currentValue - startValue;
                progress = gained / this.requiredAmount;
            }
            return Math.max(0.0, Math.min(1.0, progress));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to calculate progress for statistic requirement", exception);
            return 0.0;
        }
    }

    @Override
    public void consume(@NotNull Player player) {
        try {
            if (this.mode == RequirementMode.RELATIVE) {
                double currentValue = this.getCurrentStatisticValue(player);
                this.startingValue = currentValue;
                LOGGER.log(Level.FINER, String.format("Updated starting value for relative statistic requirement to %.4f for player %s", currentValue, player.getName()));
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to consume statistic requirement", exception);
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        StringBuilder keyBuilder = new StringBuilder("requirement.statistic.");
        keyBuilder.append(this.mode.name().toLowerCase()).append(".");
        keyBuilder.append(this.statisticType.name().toLowerCase()).append(".");
        keyBuilder.append(this.identifier.toLowerCase().replaceAll("[^a-z0-9_]", "_"));
        if (this.qualifier != null && !this.qualifier.isEmpty()) {
            keyBuilder.append(".").append(this.qualifier.toLowerCase().replaceAll("[^a-z0-9_]", "_"));
        }
        return keyBuilder.toString();
    }

    @NotNull
    public String getPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public double getRequiredAmount() {
        return this.requiredAmount;
    }

    @NotNull
    public RequirementMode getMode() {
        return this.mode;
    }

    @Nullable
    public String getQualifier() {
        return this.qualifier;
    }

    @NotNull
    public StatisticType.DataType getStatisticType() {
        return this.statisticType;
    }

    @Nullable
    public Double getStartingValue() {
        return this.startingValue;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void initializeForPlayer(@NotNull Player player) {
        if (this.mode == RequirementMode.RELATIVE && this.startingValue == null) {
            this.getStartingValue(player);
        }
    }

    @NotNull
    public static RStatisticRequirement createKillRequirement(@NotNull String entityType, int requiredKills, @NotNull RequirementMode mode) {
        return new RStatisticRequirement(EStatisticType.StatisticCategory.RDQ.name(), "kills_" + entityType.toLowerCase(), requiredKills, mode, entityType, StatisticType.DataType.NUMBER, null, 75L);
    }

    @NotNull
    public static RStatisticRequirement createBlockBreakRequirement(@NotNull String blockType, int requiredBlocks, @NotNull RequirementMode mode) {
        return new RStatisticRequirement(EStatisticType.StatisticCategory.RDQ.name(), "blocks_broken_" + blockType.toLowerCase(), requiredBlocks, mode, blockType, StatisticType.DataType.NUMBER, null, 75L);
    }

    @NotNull
    public static RStatisticRequirement createPlaytimeRequirement(int requiredMinutes, @NotNull RequirementMode mode) {
        return new RStatisticRequirement(EStatisticType.StatisticCategory.RDQ.name(), "playtime_minutes", requiredMinutes, mode, null, StatisticType.DataType.NUMBER, null, 75L);
    }

    private double getCurrentStatisticValue(@NotNull Player player) {
        try {
            RCoreAdapter adapter = this.resolveAdapter();
            if (adapter == null) {
                LOGGER.log(Level.FINE, "RCoreAdapter not available");
                return 0.0;
            }
            CompletableFuture future = adapter.findStatisticValueAsync(player.getUniqueId(), this.identifier, this.plugin);
            Optional<Object> opt = future.completeOnTimeout(Optional.empty(), this.timeoutMillis, TimeUnit.MILLISECONDS).join();
            Object value = opt.orElse(null);
            return this.convertToDouble(value);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get current statistic value", exception);
            return 0.0;
        }
    }

    private double getTargetValue(@NotNull Player player) {
        if (this.mode == RequirementMode.ABSOLUTE) {
            return this.requiredAmount;
        }
        double startValue = this.getStartingValue(player);
        return startValue + this.requiredAmount;
    }

    private double getStartingValue(@NotNull Player player) {
        if (this.startingValue != null) {
            return this.startingValue;
        }
        double currentValue = this.getCurrentStatisticValue(player);
        this.startingValue = currentValue;
        LOGGER.log(Level.FINER, String.format("Initialized starting value for relative requirement to %.4f for player %s", currentValue, player.getName()));
        return currentValue;
    }

    private double convertToDouble(@Nullable Object value) {
        if (value == null) {
            return 0.0;
        }
        try {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Boolean.class, String.class}, (Object)object2, n)) {
                case 0 -> {
                    double var4_6;
                    Number number = (Number)object2;
                    yield var4_6 = number.doubleValue();
                }
                case 1 -> {
                    double var4_7;
                    Boolean bool = (Boolean)object2;
                    yield var4_7 = bool != false ? 1.0 : 0.0;
                }
                case 2 -> {
                    String str = (String)object2;
                    try {
                        double var4_8;
                        yield var4_8 = Double.parseDouble(str);
                    }
                    catch (NumberFormatException e) {
                        double var4_9;
                        yield var4_9 = str.isEmpty() ? 0.0 : 1.0;
                    }
                }
                default -> {
                    double var4_10;
                    yield var4_10 = 1.0;
                }
            };
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to convert statistic value to double: " + String.valueOf(value), exception);
            return 0.0;
        }
    }

    @Nullable
    private RCoreAdapter resolveAdapter() {
        Supplier<RCoreAdapter> s = ADAPTER_SUPPLIER;
        return s != null ? s.get() : null;
    }

    public static enum RequirementMode {
        ABSOLUTE,
        RELATIVE;

    }
}

