/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaytimeRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = CentralLogger.getLogger(PlaytimeRequirement.class.getName());
    @JsonProperty(value="requiredPlaytimeSeconds")
    private final long requiredPlaytimeSeconds;
    @JsonProperty(value="worldPlaytimeRequirements")
    private final Map<String, Long> worldPlaytimeRequirements;
    @JsonProperty(value="useTotalPlaytime")
    private final boolean useTotalPlaytime;
    @JsonProperty(value="description")
    private final String description;
    @JsonIgnore
    private final transient Map<String, World> worldCache = new ConcurrentHashMap<String, World>();

    public PlaytimeRequirement(long requiredPlaytimeSeconds) {
        this(requiredPlaytimeSeconds, null, true, null);
    }

    @JsonCreator
    public PlaytimeRequirement(@JsonProperty(value="requiredPlaytimeSeconds") long requiredPlaytimeSeconds, @JsonProperty(value="worldPlaytimeRequirements") @Nullable Map<String, Long> worldPlaytimeRequirements, @JsonProperty(value="useTotalPlaytime") @Nullable Boolean useTotalPlaytime, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.PLAYTIME);
        if (requiredPlaytimeSeconds < 0L) {
            throw new IllegalArgumentException("Required playtime cannot be negative: " + requiredPlaytimeSeconds);
        }
        this.requiredPlaytimeSeconds = requiredPlaytimeSeconds;
        this.worldPlaytimeRequirements = worldPlaytimeRequirements != null ? new HashMap<String, Long>(worldPlaytimeRequirements) : new HashMap();
        this.useTotalPlaytime = useTotalPlaytime != null ? useTotalPlaytime : true;
        this.description = description;
        if (!this.useTotalPlaytime && this.worldPlaytimeRequirements.isEmpty()) {
            throw new IllegalArgumentException("World playtime requirements cannot be empty when not using total playtime");
        }
    }

    @JsonIgnore
    @NotNull
    public static PlaytimeRequirement fromTimeConfig(@Nullable Long requiredSeconds, @Nullable Long requiredMinutes, @Nullable Long requiredHours, @Nullable Long requiredDays, @Nullable Map<String, Long> worldRequirements, @Nullable Boolean useTotalPlaytime, @Nullable String description) {
        int timeValuesCount = 0;
        long requiredPlaytimeSeconds = 0L;
        if (requiredSeconds != null && requiredSeconds > 0L) {
            ++timeValuesCount;
            requiredPlaytimeSeconds = requiredSeconds;
        }
        if (requiredMinutes != null && requiredMinutes > 0L) {
            ++timeValuesCount;
            requiredPlaytimeSeconds = TimeUnit.MINUTES.toSeconds(requiredMinutes);
        }
        if (requiredHours != null && requiredHours > 0L) {
            ++timeValuesCount;
            requiredPlaytimeSeconds = TimeUnit.HOURS.toSeconds(requiredHours);
        }
        if (requiredDays != null && requiredDays > 0L) {
            ++timeValuesCount;
            requiredPlaytimeSeconds = TimeUnit.DAYS.toSeconds(requiredDays);
        }
        if (timeValuesCount == 0 && (worldRequirements == null || worldRequirements.isEmpty())) {
            throw new IllegalArgumentException("At least one playtime requirement must be specified.");
        }
        if (timeValuesCount > 1) {
            throw new IllegalArgumentException("Only one global playtime requirement can be specified at a time.");
        }
        return new PlaytimeRequirement(requiredPlaytimeSeconds, worldRequirements, useTotalPlaytime, description);
    }

    @JsonIgnore
    @NotNull
    public static PlaytimeRequirement forWorlds(@NotNull Map<String, Long> worldPlaytimeMap, @Nullable String description) {
        return new PlaytimeRequirement(0L, worldPlaytimeMap, false, description);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        if (this.useTotalPlaytime) {
            return this.getTotalPlaytimeSeconds(player) >= this.requiredPlaytimeSeconds;
        }
        return this.checkWorldPlaytimeRequirements(player);
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        if (this.useTotalPlaytime) {
            if (this.requiredPlaytimeSeconds <= 0L) {
                return 1.0;
            }
            long currentPlaytime = this.getTotalPlaytimeSeconds(player);
            return Math.min(1.0, (double)currentPlaytime / (double)this.requiredPlaytimeSeconds);
        }
        return this.calculateWorldPlaytimeProgress(player);
    }

    @Override
    public void consume(@NotNull Player player) {
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.playtime";
    }

    @JsonIgnore
    public long getTotalPlaytimeSeconds(@NotNull Player player) {
        int playtimeTicks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        return playtimeTicks / 20;
    }

    @JsonIgnore
    public long getWorldPlaytimeSeconds(@NotNull Player player, @NotNull String worldName) {
        World world = this.getCachedWorld(worldName);
        if (world == null) {
            return 0L;
        }
        try {
            int playtimeTicks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
            return playtimeTicks / 20;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getRequiredPlaytimeSeconds() {
        return this.requiredPlaytimeSeconds;
    }

    @JsonIgnore
    public long getRequiredPlaytimeMinutes() {
        return TimeUnit.SECONDS.toMinutes(this.requiredPlaytimeSeconds);
    }

    @JsonIgnore
    public long getRequiredPlaytimeHours() {
        return TimeUnit.SECONDS.toHours(this.requiredPlaytimeSeconds);
    }

    @JsonIgnore
    public long getRequiredPlaytimeDays() {
        return TimeUnit.SECONDS.toDays(this.requiredPlaytimeSeconds);
    }

    @NotNull
    public Map<String, Long> getWorldPlaytimeRequirements() {
        return new HashMap<String, Long>(this.worldPlaytimeRequirements);
    }

    public boolean isUseTotalPlaytime() {
        return this.useTotalPlaytime;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    @NotNull
    public String getFormattedRequiredPlaytime() {
        if (!this.useTotalPlaytime) {
            return this.formatWorldRequirements();
        }
        return PlaytimeRequirement.formatDuration(this.requiredPlaytimeSeconds);
    }

    @JsonIgnore
    @NotNull
    public String getFormattedCurrentPlaytime(@NotNull Player player) {
        if (!this.useTotalPlaytime) {
            return this.formatCurrentWorldPlaytime(player);
        }
        long currentSeconds = this.getTotalPlaytimeSeconds(player);
        return PlaytimeRequirement.formatDuration(currentSeconds);
    }

    @JsonIgnore
    @NotNull
    public static String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long days = TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) % 24L;
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) % 60L;
        long remainingSeconds = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (remainingSeconds > 0L && days == 0L) {
            sb.append(remainingSeconds).append("s");
        }
        return sb.toString().trim();
    }

    @JsonIgnore
    public void validate() {
        if (this.requiredPlaytimeSeconds < 0L) {
            throw new IllegalStateException("Required playtime cannot be negative: " + this.requiredPlaytimeSeconds);
        }
        if (!this.useTotalPlaytime && this.worldPlaytimeRequirements.isEmpty()) {
            throw new IllegalStateException("World playtime requirements cannot be empty when not using total playtime");
        }
        for (Map.Entry<String, Long> entry : this.worldPlaytimeRequirements.entrySet()) {
            if (entry.getKey() == null || entry.getKey().trim().isEmpty()) {
                throw new IllegalStateException("World name cannot be null or empty");
            }
            if (entry.getValue() >= 0L) continue;
            throw new IllegalStateException("World playtime requirement cannot be negative: " + String.valueOf(entry.getValue()));
        }
    }

    @Nullable
    private World getCachedWorld(@NotNull String worldName) {
        return this.worldCache.computeIfAbsent(worldName, Bukkit::getWorld);
    }

    private boolean checkWorldPlaytimeRequirements(@NotNull Player player) {
        for (Map.Entry<String, Long> entry : this.worldPlaytimeRequirements.entrySet()) {
            String worldName = entry.getKey();
            Long requiredSeconds = entry.getValue();
            long actualSeconds = this.getWorldPlaytimeSeconds(player, worldName);
            if (actualSeconds >= requiredSeconds) continue;
            return false;
        }
        return true;
    }

    private double calculateWorldPlaytimeProgress(@NotNull Player player) {
        if (this.worldPlaytimeRequirements.isEmpty()) {
            return 1.0;
        }
        double totalProgress = 0.0;
        int validRequirements = 0;
        for (Map.Entry<String, Long> entry : this.worldPlaytimeRequirements.entrySet()) {
            String worldName = entry.getKey();
            Long requiredSeconds = entry.getValue();
            if (requiredSeconds <= 0L) {
                totalProgress += 1.0;
            } else {
                long actualSeconds = this.getWorldPlaytimeSeconds(player, worldName);
                totalProgress += Math.min(1.0, (double)actualSeconds / (double)requiredSeconds.longValue());
            }
            ++validRequirements;
        }
        return validRequirements > 0 ? totalProgress / (double)validRequirements : 1.0;
    }

    @NotNull
    private String formatWorldRequirements() {
        if (this.worldPlaytimeRequirements.isEmpty()) {
            return "No world requirements";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Long> entry : this.worldPlaytimeRequirements.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append(": ").append(PlaytimeRequirement.formatDuration(entry.getValue()));
        }
        return sb.toString();
    }

    @NotNull
    private String formatCurrentWorldPlaytime(@NotNull Player player) {
        if (this.worldPlaytimeRequirements.isEmpty()) {
            return "No world requirements";
        }
        StringBuilder sb = new StringBuilder();
        for (String worldName : this.worldPlaytimeRequirements.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            long currentSeconds = this.getWorldPlaytimeSeconds(player, worldName);
            sb.append(worldName).append(": ").append(PlaytimeRequirement.formatDuration(currentSeconds));
        }
        return sb.toString();
    }
}

