/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermissionRequirement
extends AbstractRequirement {
    @JsonProperty(value="requiredPermissions")
    private final List<String> requiredPermissions;
    @JsonProperty(value="permissionMode")
    private final PermissionMode permissionMode;
    @JsonProperty(value="minimumRequired")
    private final int minimumRequired;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="checkNegated")
    private final boolean checkNegated;

    public PermissionRequirement(@NotNull String permission) {
        this(List.of(permission), PermissionMode.ALL, 1, null, false);
    }

    public PermissionRequirement(@NotNull List<String> requiredPermissions) {
        this(requiredPermissions, PermissionMode.ALL, requiredPermissions.size(), null, false);
    }

    public PermissionRequirement(@NotNull List<String> requiredPermissions, @NotNull PermissionMode permissionMode) {
        this(requiredPermissions, permissionMode, permissionMode == PermissionMode.ANY ? 1 : requiredPermissions.size(), null, false);
    }

    @JsonCreator
    public PermissionRequirement(@JsonProperty(value="requiredPermissions") @NotNull List<String> requiredPermissions, @JsonProperty(value="permissionMode") @Nullable PermissionMode permissionMode, @JsonProperty(value="minimumRequired") @Nullable Integer minimumRequired, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="checkNegated") @Nullable Boolean checkNegated) {
        super(Requirement.Type.PERMISSION);
        int minRequired;
        PermissionMode mode;
        if (requiredPermissions.isEmpty()) {
            throw new IllegalArgumentException("At least one permission must be specified.");
        }
        for (String permission : requiredPermissions) {
            if (permission != null && !permission.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Permission cannot be null or empty.");
        }
        PermissionMode permissionMode2 = mode = permissionMode != null ? permissionMode : PermissionMode.ALL;
        int n = minimumRequired != null ? minimumRequired : (minRequired = mode == PermissionMode.ANY ? 1 : requiredPermissions.size());
        if (minRequired < 1) {
            throw new IllegalArgumentException("Minimum required must be at least 1.");
        }
        if (minRequired > requiredPermissions.size()) {
            throw new IllegalArgumentException("Minimum required (" + minRequired + ") cannot exceed total permissions (" + requiredPermissions.size() + ").");
        }
        this.requiredPermissions = new ArrayList<String>(requiredPermissions);
        this.permissionMode = mode;
        this.minimumRequired = minRequired;
        this.description = description;
        this.checkNegated = checkNegated != null ? checkNegated : false;
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        return switch (this.permissionMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.requiredPermissions.stream().allMatch(permission -> this.checkPermission(player, (String)permission));
            case 1 -> this.requiredPermissions.stream().anyMatch(permission -> this.checkPermission(player, (String)permission));
            case 2 -> {
                long matchingPermissions = this.requiredPermissions.stream().filter(permission -> this.checkPermission(player, (String)permission)).count();
                if (matchingPermissions >= (long)this.minimumRequired) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        if (this.requiredPermissions.isEmpty()) {
            return 1.0;
        }
        long heldPermissions = this.requiredPermissions.stream().filter(permission -> this.checkPermission(player, (String)permission)).count();
        return switch (this.permissionMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Math.min(1.0, (double)heldPermissions / (double)this.requiredPermissions.size());
            case 1 -> {
                if (heldPermissions > 0L) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case 2 -> Math.min(1.0, (double)heldPermissions / (double)this.minimumRequired);
        };
    }

    @Override
    public void consume(@NotNull Player player) {
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.permission";
    }

    @NotNull
    public List<String> getRequiredPermissions() {
        return new ArrayList<String>(this.requiredPermissions);
    }

    @NotNull
    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    public int getMinimumRequired() {
        return this.minimumRequired;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isCheckNegated() {
        return this.checkNegated;
    }

    @JsonIgnore
    @NotNull
    public List<PermissionStatus> getDetailedPermissionStatus(@NotNull Player player) {
        return IntStream.range(0, this.requiredPermissions.size()).mapToObj(index -> {
            String permission = this.requiredPermissions.get(index);
            boolean hasPermission = this.checkPermission(player, permission);
            return new PermissionStatus(index, permission, hasPermission);
        }).toList();
    }

    @JsonIgnore
    @NotNull
    public List<String> getHeldPermissions(@NotNull Player player) {
        return this.requiredPermissions.stream().filter(permission -> this.checkPermission(player, (String)permission)).toList();
    }

    @JsonIgnore
    @NotNull
    public List<String> getMissingPermissions(@NotNull Player player) {
        return this.requiredPermissions.stream().filter(permission -> !this.checkPermission(player, (String)permission)).toList();
    }

    @JsonIgnore
    public boolean isAllMode() {
        return this.permissionMode == PermissionMode.ALL;
    }

    @JsonIgnore
    public boolean isAnyMode() {
        return this.permissionMode == PermissionMode.ANY;
    }

    @JsonIgnore
    public boolean isMinimumMode() {
        return this.permissionMode == PermissionMode.MINIMUM;
    }

    @JsonIgnore
    public void validate() {
        if (this.requiredPermissions.isEmpty()) {
            throw new IllegalStateException("PermissionRequirement must have at least one permission.");
        }
        if (this.minimumRequired < 1 || this.minimumRequired > this.requiredPermissions.size()) {
            throw new IllegalStateException("Invalid minimumRequired: " + this.minimumRequired + " (must be between 1 and " + this.requiredPermissions.size() + ").");
        }
        for (int i = 0; i < this.requiredPermissions.size(); ++i) {
            String permission = this.requiredPermissions.get(i);
            if (permission != null && !permission.trim().isEmpty()) continue;
            throw new IllegalStateException("Permission at index " + i + " is null or empty.");
        }
    }

    @JsonIgnore
    @NotNull
    public static PermissionRequirement fromString(@NotNull List<String> requiredPermissions, @NotNull String modeString, int minimumRequired) {
        PermissionMode mode;
        try {
            mode = PermissionMode.valueOf(modeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid permission mode: " + modeString + ". Valid modes are: ALL, ANY, MINIMUM.");
        }
        return new PermissionRequirement(requiredPermissions, mode, minimumRequired, null, false);
    }

    private boolean checkPermission(@NotNull Player player, @NotNull String permission) {
        boolean hasPermission = player.hasPermission(permission);
        return this.checkNegated != hasPermission;
    }

    public static enum PermissionMode {
        ALL,
        ANY,
        MINIMUM;

    }

    public static final class PermissionStatus {
        private final int index;
        private final String permission;
        private final boolean hasPermission;

        public PermissionStatus(int index, @NotNull String permission, boolean hasPermission) {
            this.index = index;
            this.permission = permission;
            this.hasPermission = hasPermission;
        }

        public int getIndex() {
            return this.index;
        }

        @NotNull
        public String getPermission() {
            return this.permission;
        }

        public boolean hasPermission() {
            return this.hasPermission;
        }
    }
}

