/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocationRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = Logger.getLogger(LocationRequirement.class.getName());
    @JsonProperty(value="requiredWorld")
    private final String requiredWorld;
    @JsonProperty(value="requiredRegion")
    private final String requiredRegion;
    @JsonProperty(value="requiredCoordinates")
    private final Coordinates requiredCoordinates;
    @JsonProperty(value="requiredDistance")
    private final double requiredDistance;
    @JsonProperty(value="description")
    private final String description;
    @JsonIgnore
    private volatile transient Boolean worldGuardAvailable;
    @JsonIgnore
    private volatile transient World cachedWorld;

    public LocationRequirement(@NotNull String requiredWorld, double x, double y, double z, double requiredDistance) {
        this(requiredWorld, null, new Coordinates(x, y, z), (Double)requiredDistance, null);
    }

    public LocationRequirement(@NotNull String requiredWorld, @NotNull String requiredRegion) {
        this(requiredWorld, requiredRegion, null, (Double)0.0, null);
    }

    @JsonCreator
    public LocationRequirement(@JsonProperty(value="requiredWorld") @Nullable String requiredWorld, @JsonProperty(value="requiredRegion") @Nullable String requiredRegion, @JsonProperty(value="requiredCoordinates") @Nullable Coordinates requiredCoordinates, @JsonProperty(value="requiredDistance") @Nullable Double requiredDistance, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.LOCATION);
        if (requiredWorld == null && requiredRegion == null && requiredCoordinates == null) {
            throw new IllegalArgumentException("At least one location criterion must be specified (world, region, or coordinates).");
        }
        if (requiredCoordinates != null && (requiredDistance == null || requiredDistance < 0.0)) {
            throw new IllegalArgumentException("Required distance must be non-negative when coordinates are specified.");
        }
        if (requiredWorld != null && requiredWorld.trim().isEmpty()) {
            throw new IllegalArgumentException("Required world name cannot be empty.");
        }
        if (requiredRegion != null && requiredRegion.trim().isEmpty()) {
            throw new IllegalArgumentException("Required region name cannot be empty.");
        }
        this.requiredWorld = requiredWorld;
        this.requiredRegion = requiredRegion;
        this.requiredCoordinates = requiredCoordinates;
        this.requiredDistance = requiredDistance != null ? requiredDistance : 0.0;
        this.description = description;
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        Location targetLocation;
        double distance;
        Location playerLocation = player.getLocation();
        if (this.requiredWorld != null && !this.requiredWorld.equals(playerLocation.getWorld().getName())) {
            return false;
        }
        if (this.requiredCoordinates != null && (distance = playerLocation.distance(targetLocation = new Location(playerLocation.getWorld(), this.requiredCoordinates.getX(), this.requiredCoordinates.getY(), this.requiredCoordinates.getZ()))) > this.requiredDistance) {
            return false;
        }
        return this.requiredRegion == null || this.isInRegion(playerLocation, this.requiredRegion);
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        Location playerLocation = player.getLocation();
        double progress = 1.0;
        if (this.requiredWorld != null) {
            double worldProgress = this.requiredWorld.equals(playerLocation.getWorld().getName()) ? 1.0 : 0.0;
            progress = Math.min(progress, worldProgress);
        }
        if (this.requiredCoordinates != null) {
            Location targetLocation = new Location(playerLocation.getWorld(), this.requiredCoordinates.getX(), this.requiredCoordinates.getY(), this.requiredCoordinates.getZ());
            double distance = playerLocation.distance(targetLocation);
            double coordinateProgress = this.requiredDistance > 0.0 ? Math.max(0.0, 1.0 - distance / this.requiredDistance) : (distance == 0.0 ? 1.0 : 0.0);
            progress = Math.min(progress, coordinateProgress);
        }
        if (this.requiredRegion != null) {
            double regionProgress = this.isInRegion(playerLocation, this.requiredRegion) ? 1.0 : 0.0;
            progress = Math.min(progress, regionProgress);
        }
        return Math.max(0.0, Math.min(1.0, progress));
    }

    @Override
    public void consume(@NotNull Player player) {
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.location";
    }

    @Nullable
    public String getRequiredWorld() {
        return this.requiredWorld;
    }

    @Nullable
    public String getRequiredRegion() {
        return this.requiredRegion;
    }

    @Nullable
    public Coordinates getRequiredCoordinates() {
        return this.requiredCoordinates;
    }

    public double getRequiredDistance() {
        return this.requiredDistance;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public double getCurrentDistance(@NotNull Player player) {
        if (this.requiredCoordinates == null) {
            return -1.0;
        }
        Location playerLocation = player.getLocation();
        Location targetLocation = new Location(playerLocation.getWorld(), this.requiredCoordinates.getX(), this.requiredCoordinates.getY(), this.requiredCoordinates.getZ());
        return playerLocation.distance(targetLocation);
    }

    @JsonIgnore
    public boolean isInCorrectWorld(@NotNull Player player) {
        if (this.requiredWorld == null) {
            return true;
        }
        return this.requiredWorld.equals(player.getWorld().getName());
    }

    @JsonIgnore
    public boolean isWithinDistance(@NotNull Player player) {
        if (this.requiredCoordinates == null) {
            return true;
        }
        return this.getCurrentDistance(player) <= this.requiredDistance;
    }

    @JsonIgnore
    public boolean isInCorrectRegion(@NotNull Player player) {
        if (this.requiredRegion == null) {
            return true;
        }
        return this.isInRegion(player.getLocation(), this.requiredRegion);
    }

    @JsonIgnore
    @NotNull
    public String getFormattedStatus(@NotNull Player player) {
        StringBuilder status = new StringBuilder();
        if (this.requiredWorld != null) {
            status.append("World: ").append(player.getWorld().getName()).append(this.isInCorrectWorld(player) ? " \u2713" : " \u2717").append(" (Required: ").append(this.requiredWorld).append(")");
        }
        if (this.requiredCoordinates != null) {
            if (status.length() > 0) {
                status.append(", ");
            }
            double distance = this.getCurrentDistance(player);
            status.append("Distance: ").append(String.format("%.1f", distance)).append(this.isWithinDistance(player) ? " \u2713" : " \u2717").append(" (Max: ").append(String.format("%.1f", this.requiredDistance)).append(")");
        }
        if (this.requiredRegion != null) {
            if (status.length() > 0) {
                status.append(", ");
            }
            status.append("Region: ").append(this.requiredRegion).append(this.isInCorrectRegion(player) ? " \u2713" : " \u2717");
        }
        return status.toString();
    }

    @JsonIgnore
    public void validate() {
        World world;
        if (this.requiredWorld == null && this.requiredRegion == null && this.requiredCoordinates == null) {
            throw new IllegalStateException("At least one location criterion must be specified.");
        }
        if (this.requiredCoordinates != null && this.requiredDistance < 0.0) {
            throw new IllegalStateException("Required distance must be non-negative: " + this.requiredDistance);
        }
        if (this.requiredWorld != null && this.requiredWorld.trim().isEmpty()) {
            throw new IllegalStateException("Required world name cannot be empty.");
        }
        if (this.requiredRegion != null && this.requiredRegion.trim().isEmpty()) {
            throw new IllegalStateException("Required region name cannot be empty.");
        }
        if (this.requiredWorld != null && (world = this.getCachedWorld()) == null) {
            throw new IllegalStateException("Required world does not exist: " + this.requiredWorld);
        }
    }

    @Nullable
    private World getCachedWorld() {
        if (this.requiredWorld == null) {
            return null;
        }
        if (this.cachedWorld != null) {
            return this.cachedWorld;
        }
        this.cachedWorld = Bukkit.getWorld((String)this.requiredWorld);
        return this.cachedWorld;
    }

    private boolean isWorldGuardAvailable() {
        if (this.worldGuardAvailable == null) {
            Plugin worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
            this.worldGuardAvailable = worldGuardPlugin != null && worldGuardPlugin.isEnabled();
        }
        return this.worldGuardAvailable;
    }

    private boolean isInRegion(@NotNull Location location, @NotNull String regionName) {
        if (!this.isWorldGuardAvailable()) {
            LOGGER.log(Level.WARNING, "WorldGuard is not available, region check for '" + regionName + "' will always return false");
            return false;
        }
        return false;
    }

    public static final class Coordinates {
        @JsonProperty(value="x")
        private final double x;
        @JsonProperty(value="y")
        private final double y;
        @JsonProperty(value="z")
        private final double z;

        @JsonCreator
        public Coordinates(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y, @JsonProperty(value="z") double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public String toString() {
            return String.format("(%.1f, %.1f, %.1f)", this.x, this.y, this.z);
        }
    }
}

