/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import de.jexcellence.evaluable.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = Logger.getLogger(ItemRequirement.class.getName());
    @JsonProperty(value="requiredItems")
    private final List<ItemStack> requiredItems;
    @JsonProperty(value="itemBuilders")
    private final List<ItemBuilder> itemBuilders;
    @JsonProperty(value="consumeOnComplete")
    private final boolean consumeOnComplete;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="exactMatch")
    private final boolean exactMatch;

    protected ItemRequirement() {
        super(Requirement.Type.ITEM);
        this.requiredItems = new ArrayList<ItemStack>();
        this.itemBuilders = new ArrayList<ItemBuilder>();
        this.consumeOnComplete = true;
        this.description = null;
        this.exactMatch = true;
    }

    @JsonCreator
    public ItemRequirement(@JsonProperty(value="requiredItems") @Nullable List<ItemStack> requiredItems, @JsonProperty(value="itemBuilders") @Nullable List<ItemBuilder> itemBuilders, @JsonProperty(value="consumeOnComplete") @Nullable Boolean consumeOnComplete, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="exactMatch") @Nullable Boolean exactMatch) {
        super(Requirement.Type.ITEM);
        ArrayList builders;
        ArrayList items = requiredItems != null ? requiredItems : new ArrayList();
        ArrayList arrayList = builders = itemBuilders != null ? itemBuilders : new ArrayList();
        if (!items.isEmpty()) {
            this.requiredItems = new ArrayList<ItemStack>(items);
            this.itemBuilders = new ArrayList<ItemBuilder>(builders);
        } else if (!builders.isEmpty()) {
            this.itemBuilders = new ArrayList<ItemBuilder>(builders);
            this.requiredItems = builders.stream().map(ItemBuilder::build).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        } else {
            throw new IllegalArgumentException("At least one required item or item builder must be specified.");
        }
        this.consumeOnComplete = consumeOnComplete != null ? consumeOnComplete : true;
        this.description = description;
        boolean bl = this.exactMatch = exactMatch != null ? exactMatch : true;
        if (this.requiredItems.isEmpty()) {
            throw new IllegalArgumentException("At least one required item must be specified.");
        }
        for (ItemStack item : this.requiredItems) {
            if (item != null && !item.getType().isAir() && item.getAmount() > 0) continue;
            throw new IllegalArgumentException("Invalid item in requirements: " + String.valueOf(item));
        }
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        return this.requiredItems.stream().allMatch(item -> this.hasEnoughItems(player, (ItemStack)item));
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        if (this.requiredItems.isEmpty()) {
            return 1.0;
        }
        double totalCollected = 0.0;
        double totalRequired = 0.0;
        for (ItemStack requiredItem : this.requiredItems) {
            int actualAmount = this.countItems(player, requiredItem);
            int requiredAmount = requiredItem.getAmount();
            totalCollected += (double)Math.min(actualAmount, requiredAmount);
            totalRequired += (double)requiredAmount;
        }
        return totalRequired > 0.0 ? Math.min(1.0, totalCollected / totalRequired) : 1.0;
    }

    @Override
    public void consume(@NotNull Player player) {
        if (!this.consumeOnComplete) {
            return;
        }
        this.requiredItems.forEach(item -> this.removeItems(player, (ItemStack)item));
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.item";
    }

    public List<ItemStack> getRequiredItems() {
        return this.requiredItems.stream().map(ItemStack::clone).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<ItemBuilder> getItemBuilders() {
        return new ArrayList<ItemBuilder>(this.itemBuilders);
    }

    public boolean isConsumeOnComplete() {
        return this.consumeOnComplete;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    @JsonIgnore
    @NotNull
    public List<ItemProgress> getDetailedProgress(@NotNull Player player) {
        return IntStream.range(0, this.requiredItems.size()).mapToObj(index -> {
            ItemStack requiredItem = this.requiredItems.get(index);
            int currentAmount = this.countItems(player, requiredItem);
            int requiredAmount = requiredItem.getAmount();
            double progress = requiredAmount > 0 ? Math.min(1.0, (double)currentAmount / (double)requiredAmount) : 1.0;
            boolean completed = currentAmount >= requiredAmount;
            return new ItemProgress(index, requiredItem, requiredAmount, currentAmount, progress, completed);
        }).toList();
    }

    @JsonIgnore
    @NotNull
    public List<ItemStack> getMissingItems(@NotNull Player player) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack requiredItem : this.requiredItems) {
            int currentAmount = this.countItems(player, requiredItem);
            int shortage = Math.max(0, requiredItem.getAmount() - currentAmount);
            if (shortage <= 0) continue;
            ItemStack missingItem = requiredItem.clone();
            missingItem.setAmount(shortage);
            missing.add(missingItem);
        }
        return missing;
    }

    @JsonIgnore
    public void validate() {
        if (this.requiredItems.isEmpty()) {
            throw new IllegalStateException("ItemRequirement must have at least one required item.");
        }
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            ItemStack item = this.requiredItems.get(i);
            if (item == null) {
                throw new IllegalStateException("Required item at index " + i + " is null.");
            }
            if (item.getType().isAir()) {
                throw new IllegalStateException("Required item at index " + i + " is air.");
            }
            if (item.getAmount() > 0) continue;
            throw new IllegalStateException("Required item at index " + i + " has invalid amount: " + item.getAmount());
        }
    }

    private boolean hasEnoughItems(@NotNull Player player, @NotNull ItemStack requiredItem) {
        if (this.exactMatch) {
            return player.getInventory().containsAtLeast(requiredItem, requiredItem.getAmount());
        }
        int totalAmount = player.getInventory().all(requiredItem.getType()).values().stream().mapToInt(ItemStack::getAmount).sum();
        return totalAmount >= requiredItem.getAmount();
    }

    private int countItems(@NotNull Player player, @NotNull ItemStack requiredItem) {
        if (this.exactMatch) {
            return player.getInventory().all(requiredItem).values().stream().filter(stack -> stack.isSimilar(requiredItem)).mapToInt(ItemStack::getAmount).sum();
        }
        return player.getInventory().all(requiredItem.getType()).values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    private void removeItems(@NotNull Player player, @NotNull ItemStack requiredItem) {
        int remaining = requiredItem.getAmount();
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length && remaining > 0; ++i) {
            boolean matches;
            ItemStack stack = contents[i];
            if (stack == null) continue;
            boolean bl = this.exactMatch ? stack.isSimilar(requiredItem) : (matches = stack.getType() == requiredItem.getType());
            if (!matches) continue;
            int remove = Math.min(remaining, stack.getAmount());
            stack.setAmount(stack.getAmount() - remove);
            remaining -= remove;
            if (stack.getAmount() > 0) continue;
            contents[i] = null;
        }
        player.getInventory().setContents(contents);
    }

    public record ItemProgress(int index, @NotNull ItemStack requiredItem, int requiredAmount, int currentAmount, double progress, boolean completed) {
        @NotNull
        private final ItemStack requiredItem;

        public ItemProgress(int index, @NotNull ItemStack requiredItem, int requiredAmount, int currentAmount, double progress, boolean completed) {
            this.index = index;
            this.requiredItem = requiredItem.clone();
            this.requiredAmount = requiredAmount;
            this.currentAmount = currentAmount;
            this.progress = progress;
            this.completed = completed;
        }

        @NotNull
        public ItemStack requiredItem() {
            return this.requiredItem.clone();
        }

        public int getProgressPercentage() {
            return (int)(this.progress * 100.0);
        }

        public int getShortage() {
            return Math.max(0, this.requiredAmount - this.currentAmount);
        }
    }
}

