/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExperienceLevelRequirement
extends AbstractRequirement {
    @JsonProperty(value="requiredLevel")
    private final int requiredLevel;
    @JsonProperty(value="experienceType")
    private final ExperienceType experienceType;
    @JsonProperty(value="consumeOnComplete")
    private final boolean consumeOnComplete;
    @JsonProperty(value="description")
    private final String description;

    public ExperienceLevelRequirement(int requiredLevel) {
        this(requiredLevel, ExperienceType.LEVEL, true, null);
    }

    public ExperienceLevelRequirement(int requiredLevel, @NotNull ExperienceType experienceType) {
        this(requiredLevel, experienceType, true, null);
    }

    @JsonCreator
    public ExperienceLevelRequirement(@JsonProperty(value="requiredLevel") int requiredLevel, @JsonProperty(value="experienceType") @Nullable ExperienceType experienceType, @JsonProperty(value="consumeOnComplete") @Nullable Boolean consumeOnComplete, @JsonProperty(value="description") @Nullable String description) {
        super(Requirement.Type.EXPERIENCE_LEVEL);
        if (requiredLevel < 0) {
            throw new IllegalArgumentException("Required level cannot be negative: " + requiredLevel);
        }
        this.requiredLevel = requiredLevel;
        this.experienceType = experienceType != null ? experienceType : ExperienceType.LEVEL;
        this.consumeOnComplete = consumeOnComplete != null ? consumeOnComplete : true;
        this.description = description;
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        return switch (this.experienceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (player.getLevel() >= this.requiredLevel) {
                    yield true;
                }
                yield false;
            }
            case 1 -> player.getTotalExperience() >= this.requiredLevel;
        };
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        if (this.requiredLevel <= 0) {
            return 1.0;
        }
        int currentAmount = switch (this.experienceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> player.getLevel();
            case 1 -> player.getTotalExperience();
        };
        double progress = (double)currentAmount / (double)this.requiredLevel;
        return Math.max(0.0, Math.min(1.0, progress));
    }

    @Override
    public void consume(@NotNull Player player) {
        if (!this.consumeOnComplete) {
            return;
        }
        switch (this.experienceType.ordinal()) {
            case 0: {
                if (player.getLevel() < this.requiredLevel) break;
                player.setLevel(player.getLevel() - this.requiredLevel);
                break;
            }
            case 1: {
                if (player.getTotalExperience() < this.requiredLevel) break;
                int newTotalExp = player.getTotalExperience() - this.requiredLevel;
                player.setTotalExperience(0);
                player.setLevel(0);
                player.setExp(0.0f);
                if (newTotalExp <= 0) break;
                player.giveExp(newTotalExp);
            }
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return switch (this.experienceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "requirement.experience_level";
            case 1 -> "requirement.experience_points";
        };
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @NotNull
    public ExperienceType getExperienceType() {
        return this.experienceType;
    }

    public boolean isConsumeOnComplete() {
        return this.consumeOnComplete;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public int getCurrentExperience(@NotNull Player player) {
        return switch (this.experienceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> player.getLevel();
            case 1 -> player.getTotalExperience();
        };
    }

    @JsonIgnore
    public int getShortage(@NotNull Player player) {
        int current = this.getCurrentExperience(player);
        return Math.max(0, this.requiredLevel - current);
    }

    @JsonIgnore
    public boolean isLevelBased() {
        return this.experienceType == ExperienceType.LEVEL;
    }

    @JsonIgnore
    public boolean isPointsBased() {
        return this.experienceType == ExperienceType.POINTS;
    }

    @JsonIgnore
    public void validate() {
        if (this.requiredLevel < 0) {
            throw new IllegalStateException("Required level cannot be negative: " + this.requiredLevel);
        }
        if (this.experienceType == null) {
            throw new IllegalStateException("Experience type cannot be null");
        }
    }

    @JsonIgnore
    @NotNull
    public static ExperienceLevelRequirement fromString(int requiredLevel, @NotNull String experienceTypeString, boolean consumeOnComplete) {
        ExperienceType experienceType;
        try {
            experienceType = ExperienceType.valueOf(experienceTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid experience type: " + experienceTypeString + ". Valid types are: LEVEL, POINTS.");
        }
        return new ExperienceLevelRequirement(requiredLevel, experienceType, consumeOnComplete, null);
    }

    public static enum ExperienceType {
        LEVEL,
        POINTS;

    }
}

