/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = Logger.getLogger(CustomRequirement.class.getName());
    @JsonProperty(value="customType")
    private final CustomType customType;
    @JsonProperty(value="customScript")
    private final String customScript;
    @JsonProperty(value="progressScript")
    private final String progressScript;
    @JsonProperty(value="consumeScript")
    private final String consumeScript;
    @JsonProperty(value="customData")
    private final Map<String, Object> customData;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="cacheScripts")
    private final boolean cacheScripts;
    @JsonIgnore
    private volatile transient ScriptEngine scriptEngine;
    @JsonIgnore
    private final transient ReadWriteLock scriptEngineLock = new ReentrantReadWriteLock();

    public CustomRequirement(@NotNull String customScript) {
        this(CustomType.SCRIPT, customScript, null, null, new HashMap<String, Object>(), null, true);
    }

    public CustomRequirement(@NotNull String customScript, @NotNull Map<String, Object> customData) {
        this(CustomType.SCRIPT, customScript, null, null, customData, null, true);
    }

    @JsonCreator
    public CustomRequirement(@JsonProperty(value="customType") @Nullable CustomType customType, @JsonProperty(value="customScript") @Nullable String customScript, @JsonProperty(value="progressScript") @Nullable String progressScript, @JsonProperty(value="consumeScript") @Nullable String consumeScript, @JsonProperty(value="customData") @Nullable Map<String, Object> customData, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="cacheScripts") @Nullable Boolean cacheScripts) {
        super(Requirement.Type.CUSTOM);
        CustomType customType2 = this.customType = customType != null ? customType : CustomType.SCRIPT;
        if (this.customType == CustomType.SCRIPT && (customScript == null || customScript.trim().isEmpty())) {
            throw new IllegalArgumentException("Custom script cannot be null or empty for SCRIPT type.");
        }
        this.customScript = customScript;
        this.progressScript = progressScript;
        this.consumeScript = consumeScript;
        this.customData = customData != null ? new HashMap<String, Object>(customData) : new HashMap();
        this.description = description;
        this.cacheScripts = cacheScripts != null ? cacheScripts : true;
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        return switch (this.customType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.executeScript(player, this.customScript, Boolean.class, false);
            case 1 -> this.executePluginLogic(player, "isMet");
            case 2 -> this.executeDataLogic(player, "isMet");
        };
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        return switch (this.customType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.progressScript != null && !this.progressScript.trim().isEmpty()) {
                    yield this.executeScript(player, this.progressScript, Double.class, 0.0);
                }
                if (this.isMet(player)) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case 1 -> this.executePluginProgressLogic(player);
            case 2 -> this.executeDataProgressLogic(player);
        };
    }

    @Override
    public void consume(@NotNull Player player) {
        switch (this.customType.ordinal()) {
            case 0: {
                if (this.consumeScript == null || this.consumeScript.trim().isEmpty()) break;
                this.executeScript(player, this.consumeScript, Void.class, null);
                break;
            }
            case 1: {
                this.executePluginConsumeLogic(player);
                break;
            }
            case 2: {
                this.executeDataConsumeLogic(player);
            }
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.custom";
    }

    @NotNull
    public CustomType getCustomType() {
        return this.customType;
    }

    @Nullable
    public String getCustomScript() {
        return this.customScript;
    }

    @Nullable
    public String getProgressScript() {
        return this.progressScript;
    }

    @Nullable
    public String getConsumeScript() {
        return this.consumeScript;
    }

    @NotNull
    public Map<String, Object> getCustomData() {
        return Collections.unmodifiableMap(this.customData);
    }

    @JsonIgnore
    public <T> T getCustomDataValue(@NotNull String key, @Nullable T defaultValue) {
        Object value = this.customData.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "Custom data value for key '" + key + "' is not of expected type", e);
            return defaultValue;
        }
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isCacheScripts() {
        return this.cacheScripts;
    }

    @JsonIgnore
    public boolean isScriptBased() {
        return this.customType == CustomType.SCRIPT;
    }

    @JsonIgnore
    public boolean isPluginBased() {
        return this.customType == CustomType.PLUGIN;
    }

    @JsonIgnore
    public boolean isDataBased() {
        return this.customType == CustomType.DATA;
    }

    @JsonIgnore
    public void validate() {
        if (this.customType == CustomType.SCRIPT) {
            if (this.customScript == null || this.customScript.trim().isEmpty()) {
                throw new IllegalStateException("Custom script cannot be null or empty for SCRIPT type.");
            }
            try {
                this.getScriptEngine();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize script engine", e);
            }
        }
        if (this.customData == null) {
            throw new IllegalStateException("Custom data cannot be null.");
        }
    }

    @NotNull
    private ScriptEngine getScriptEngine() {
        if (!this.cacheScripts) {
            return this.createScriptEngine();
        }
        this.scriptEngineLock.readLock().lock();
        try {
            if (this.scriptEngine != null) {
                ScriptEngine scriptEngine = this.scriptEngine;
                return scriptEngine;
            }
        }
        finally {
            this.scriptEngineLock.readLock().unlock();
        }
        this.scriptEngineLock.writeLock().lock();
        try {
            if (this.scriptEngine == null) {
                this.scriptEngine = this.createScriptEngine();
            }
            ScriptEngine scriptEngine = this.scriptEngine;
            return scriptEngine;
        }
        finally {
            this.scriptEngineLock.writeLock().unlock();
        }
    }

    @NotNull
    private ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        if (engine == null) {
            throw new IllegalStateException("JavaScript engine not available");
        }
        return engine;
    }

    private <T> T executeScript(@NotNull Player player, @NotNull String script, @NotNull Class<T> expectedType, @Nullable T defaultValue) {
        try {
            ScriptEngine engine = this.getScriptEngine();
            engine.put("player", player);
            engine.put("customData", this.customData);
            engine.put("requirement", this);
            this.setupScriptHelpers(engine, player);
            Object result = engine.eval(script);
            if (result == null) {
                return defaultValue;
            }
            if (expectedType == Boolean.class && result instanceof Boolean) {
                return (T)result;
            }
            if (expectedType == Double.class) {
                if (result instanceof Number) {
                    return (T)Double.valueOf(((Number)result).doubleValue());
                }
            } else if (expectedType == Void.class) {
                return null;
            }
            return (T)result;
        }
        catch (ScriptException e) {
            LOGGER.log(Level.SEVERE, "Error executing custom script: " + script, e);
            return defaultValue;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error in custom script execution", e);
            return defaultValue;
        }
    }

    private void setupScriptHelpers(@NotNull ScriptEngine engine, @NotNull Player player) {
        try {
            engine.put("Statistic", Statistic.class);
            engine.put("EntityType", EntityType.class);
            engine.eval("function getCustomData(key, defaultValue) {\n    var value = customData.get(key);\n    return value != null ? value : defaultValue;\n}\n\nfunction hasCustomData(key) {\n    return customData.containsKey(key);\n}\n\nfunction log(message) {\n    java.util.logging.Logger.getLogger('CustomRequirement').info(message);\n}\n\nfunction getKillCount(mobType) {\n    try {\n        var entityType = EntityType.valueOf(mobType.toUpperCase());\n        return player.getStatistic(Statistic.KILL_ENTITY, entityType);\n    } catch (e) {\n        log('Invalid mob type: ' + mobType);\n        return 0;\n    }\n}\n\nfunction getPlayTime() {\n    return player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20.0;\n}\n\nfunction hasPermission(permission) {\n    return player.hasPermission(permission);\n}\n\nfunction getLevel() {\n    return player.getLevel();\n}\n");
        }
        catch (ScriptException e) {
            LOGGER.log(Level.WARNING, "Failed to setup script helpers", e);
        }
    }

    private boolean executePluginLogic(@NotNull Player player, @NotNull String operation) {
        LOGGER.log(Level.WARNING, "Plugin-based custom requirements not yet implemented");
        return false;
    }

    private boolean executeDataLogic(@NotNull Player player, @NotNull String operation) {
        LOGGER.log(Level.WARNING, "Data-driven custom requirements not yet implemented");
        return false;
    }

    private double executePluginProgressLogic(@NotNull Player player) {
        return 0.0;
    }

    private double executeDataProgressLogic(@NotNull Player player) {
        return 0.0;
    }

    private void executePluginConsumeLogic(@NotNull Player player) {
    }

    private void executeDataConsumeLogic(@NotNull Player player) {
    }

    public static enum CustomType {
        SCRIPT,
        PLUGIN,
        DATA;

    }
}

