/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CurrencyRequirement
extends AbstractRequirement {
    private static final Logger LOGGER = CentralLogger.getLogger(CurrencyRequirement.class.getName());
    private static final long DEFAULT_TIMEOUT_MS = 5000L;
    @JsonProperty(value="requiredCurrencies")
    private final Map<String, Double> currencyIdentifiers;
    @JsonProperty(value="currencyPlugin")
    private final String currencyPlugin;
    @JsonProperty(value="timeoutMillis")
    private final long timeoutMillis;

    public CurrencyRequirement(@NotNull Map<String, Double> requiredCurrencies) {
        this(requiredCurrencies, (String)null, 5000L);
    }

    public CurrencyRequirement(@NotNull Map<String, Double> requiredCurrencies, @Nullable String currencyPlugin, long timeoutMillis) {
        super(Requirement.Type.CURRENCY);
        this.currencyIdentifiers = new HashMap<String, Double>(requiredCurrencies);
        this.currencyPlugin = currencyPlugin;
        this.timeoutMillis = timeoutMillis > 0L ? timeoutMillis : 5000L;
    }

    @JsonCreator
    public CurrencyRequirement(@JsonProperty(value="requiredCurrencies") @NotNull Map<String, Double> currencyIdentifiers, @JsonProperty(value="currencyPlugin") @Nullable String currencyPlugin, @JsonProperty(value="timeoutMillis") @Nullable Long timeoutMillis) {
        super(Requirement.Type.CURRENCY);
        this.currencyIdentifiers = new HashMap<String, Double>(currencyIdentifiers);
        this.currencyPlugin = currencyPlugin;
        this.timeoutMillis = timeoutMillis != null && timeoutMillis > 0L ? timeoutMillis : 5000L;
    }

    @Nullable
    public String getCurrencyPlugin() {
        return this.currencyPlugin;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public CompletableFuture<Boolean> isMetAsync(@NotNull Player player) {
        LOGGER.warning("Currency requirement checking not implemented - economy system unavailable");
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<Double> calculateProgressAsync(@NotNull Player player) {
        LOGGER.warning("Currency progress calculation not implemented - economy system unavailable");
        return CompletableFuture.completedFuture(0.0);
    }

    public CompletableFuture<Void> consumeAsync(@NotNull Player player) {
        LOGGER.warning("Currency consumption not implemented - economy system unavailable");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        try {
            return this.isMetAsync(player).join();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error checking currency requirements", exception);
            return false;
        }
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        try {
            return this.calculateProgressAsync(player).join();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error calculating currency progress", exception);
            return 0.0;
        }
    }

    @Override
    public void consume(@NotNull Player player) {
        try {
            this.consumeAsync(player).join();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error consuming currencies", exception);
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.currency";
    }

    @Nullable
    private Object getCurrencyAdapter() {
        return null;
    }

    private Map<Object, Double> resolveCurrencies() {
        HashMap<Object, Double> resolved = new HashMap<Object, Double>();
        return resolved;
    }
}

