/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.requirement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rdq.requirement.Requirement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeRequirement
extends AbstractRequirement {
    @JsonProperty(value="requirements")
    private final List<AbstractRequirement> requirements;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="minimumRequired")
    private final int minimumRequired;
    @JsonProperty(value="maximumRequired")
    private final Integer maximumRequired;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="allowPartialProgress")
    private final boolean allowPartialProgress;

    public CompositeRequirement(@NotNull List<AbstractRequirement> requirements) {
        this(requirements, Operator.AND, requirements.size(), null, null, true);
    }

    public CompositeRequirement(@NotNull List<AbstractRequirement> requirements, @NotNull Operator operator) {
        this(requirements, operator, operator == Operator.OR ? 1 : requirements.size(), null, null, true);
    }

    public CompositeRequirement(@NotNull List<AbstractRequirement> requirements, int minimumRequired) {
        this(requirements, Operator.MINIMUM, minimumRequired, null, null, true);
    }

    @JsonCreator
    public CompositeRequirement(@JsonProperty(value="requirements") @NotNull List<AbstractRequirement> requirements, @JsonProperty(value="operator") @Nullable Operator operator, @JsonProperty(value="minimumRequired") int minimumRequired, @JsonProperty(value="maximumRequired") @Nullable Integer maximumRequired, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="allowPartialProgress") @Nullable Boolean allowPartialProgress) {
        super(Requirement.Type.COMPOSITE);
        if (requirements.isEmpty()) {
            throw new IllegalArgumentException("CompositeRequirement must contain at least one requirement.");
        }
        int adjustedMinimum = minimumRequired;
        if (minimumRequired < 1) {
            adjustedMinimum = 1;
        } else if (minimumRequired > requirements.size()) {
            adjustedMinimum = requirements.size();
        }
        this.requirements = new ArrayList<AbstractRequirement>(requirements);
        this.operator = operator != null ? operator : Operator.AND;
        this.minimumRequired = adjustedMinimum;
        this.maximumRequired = maximumRequired;
        this.description = description;
        this.allowPartialProgress = allowPartialProgress != null ? allowPartialProgress : true;
    }

    @Override
    public boolean isMet(@NotNull Player player) {
        return switch (this.operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.requirements.stream().allMatch(req -> req.isMet(player));
            case 1 -> this.requirements.stream().anyMatch(req -> req.isMet(player));
            case 2 -> {
                long completedCount = this.requirements.stream().filter(req -> req.isMet(player)).count();
                if (completedCount >= (long)this.minimumRequired) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public double calculateProgress(@NotNull Player player) {
        if (this.requirements.isEmpty()) {
            return 0.0;
        }
        return switch (this.operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                double totalProgress = this.requirements.stream().mapToDouble(req -> req.calculateProgress(player)).sum();
                yield Math.min(1.0, totalProgress / (double)this.requirements.size());
            }
            case 1 -> this.requirements.stream().mapToDouble(req -> req.calculateProgress(player)).max().orElse(0.0);
            case 2 -> {
                List<Double> progressValues = this.requirements.stream().mapToDouble(req -> req.calculateProgress(player)).boxed().sorted(Comparator.reverseOrder()).toList();
                if (!this.allowPartialProgress) {
                    long completedCount = progressValues.stream().filter(progress -> progress >= 1.0).count();
                    yield Math.min(1.0, (double)completedCount / (double)this.minimumRequired);
                }
                double totalProgress = progressValues.stream().limit(this.minimumRequired).mapToDouble(Double::doubleValue).sum();
                yield Math.min(1.0, totalProgress / (double)this.minimumRequired);
            }
        };
    }

    @Override
    public void consume(@NotNull Player player) {
        switch (this.operator.ordinal()) {
            case 0: {
                this.requirements.forEach(req -> req.consume(player));
                break;
            }
            case 1: {
                this.requirements.stream().max(Comparator.comparingDouble(req -> req.calculateProgress(player))).ifPresent(req -> req.consume(player));
                break;
            }
            case 2: {
                this.requirements.stream().sorted(Comparator.comparingDouble(req -> req.calculateProgress(player)).reversed()).limit(this.minimumRequired).forEach(req -> req.consume(player));
            }
        }
    }

    @Override
    @NotNull
    public String getDescriptionKey() {
        return "requirement.composite." + this.operator.name().toLowerCase();
    }

    @NotNull
    public List<AbstractRequirement> getRequirements() {
        return new ArrayList<AbstractRequirement>(this.requirements);
    }

    @NotNull
    public Operator getOperator() {
        return this.operator;
    }

    public int getMinimumRequired() {
        return this.minimumRequired;
    }

    @Nullable
    public Integer getMaximumRequired() {
        return this.maximumRequired;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isAllowPartialProgress() {
        return this.allowPartialProgress;
    }

    @JsonIgnore
    @NotNull
    public List<RequirementProgress> getDetailedProgress(@NotNull Player player) {
        return IntStream.range(0, this.requirements.size()).mapToObj(index -> {
            AbstractRequirement requirement = this.requirements.get(index);
            double progress = requirement.calculateProgress(player);
            boolean completed = requirement.isMet(player);
            return new RequirementProgress(index, requirement, progress, completed);
        }).toList();
    }

    @JsonIgnore
    @NotNull
    public List<AbstractRequirement> getCompletedRequirements(@NotNull Player player) {
        return this.requirements.stream().filter(req -> req.isMet(player)).toList();
    }

    @JsonIgnore
    @NotNull
    public List<AbstractRequirement> getRequirementsByProgress(@NotNull Player player) {
        return this.requirements.stream().sorted(Comparator.comparingDouble(req -> req.calculateProgress(player)).reversed()).toList();
    }

    @JsonIgnore
    public boolean isAndLogic() {
        return this.operator == Operator.AND;
    }

    @JsonIgnore
    public boolean isOrLogic() {
        return this.operator == Operator.OR;
    }

    @JsonIgnore
    public boolean isMinimumLogic() {
        return this.operator == Operator.MINIMUM;
    }

    @JsonIgnore
    public void validate() {
        if (this.requirements.isEmpty()) {
            throw new IllegalStateException("CompositeRequirement must have at least one requirement.");
        }
        if (this.minimumRequired < 1 || this.minimumRequired > this.requirements.size()) {
            throw new IllegalStateException("Invalid minimumRequired: " + this.minimumRequired + " (must be between 1 and " + this.requirements.size() + ").");
        }
        for (int i = 0; i < this.requirements.size(); ++i) {
            AbstractRequirement requirement = this.requirements.get(i);
            if (requirement != null) continue;
            throw new IllegalStateException("Requirement at index " + i + " is null.");
        }
    }

    @JsonIgnore
    @NotNull
    public static CompositeRequirement fromString(@NotNull List<AbstractRequirement> requirements, @NotNull String operatorString, int minimumRequired) {
        Operator operator;
        try {
            operator = Operator.valueOf(operatorString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid operator: " + operatorString + ". Valid operators are: AND, OR, MINIMUM.");
        }
        return new CompositeRequirement(requirements, operator, minimumRequired, null, null, true);
    }

    public static enum Operator {
        AND,
        OR,
        MINIMUM;

    }

    public record RequirementProgress(int index, @NotNull AbstractRequirement requirement, double progress, boolean completed) {
        public int getProgressPercentage() {
            return (int)(this.progress * 100.0);
        }
    }
}

