/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.rank;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.config.ranks.rank.DefaultRankSection;
import com.raindropcentral.rdq.config.ranks.rank.RankSection;
import com.raindropcentral.rdq.config.ranks.ranktree.RankTreeSection;
import com.raindropcentral.rdq.config.ranks.system.RankSystemSection;
import com.raindropcentral.rdq.config.requirement.BaseRequirementSection;
import com.raindropcentral.rdq.database.entity.RRequirement;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.utility.requirement.RequirementFactory;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.evaluable.ConfigKeeper;
import de.jexcellence.evaluable.ConfigManager;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankSystemFactory {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private static final String FILE_PATH = "rank";
    private static final String FILE_RANK_PATH = "paths";
    private static final String FILE_NAME = "rank-system.yml";
    private static final List<String> INITIAL_RANKS = List.of("cleric.yml", "mage.yml", "merchant.yml", "ranger.yml", "rogue.yml", "warrior.yml");
    private final RDQ rdq;
    private final RequirementFactory requirementFactory;
    private volatile boolean isInitializing = false;
    private RankSystemSection rankSystemSection;
    private final Map<String, RankTreeSection> rankTreeSections = new HashMap<String, RankTreeSection>();
    private final Map<String, Map<String, RankSection>> rankSections = new HashMap<String, Map<String, RankSection>>();
    private final Map<String, RRankTree> rankTrees = new HashMap<String, RRankTree>();
    private final Map<String, Map<String, RRank>> ranks = new HashMap<String, Map<String, RRank>>();
    private RRank defaultRank;

    public RankSystemFactory(@NotNull RDQ rdq) {
        this.rdq = rdq;
        this.requirementFactory = new RequirementFactory(rdq);
    }

    public void initialize() {
        if (this.isInitializing) {
            LOGGER.warning("Rank system initialization already in progress");
            return;
        }
        this.isInitializing = true;
        try {
            LOGGER.info("Starting rank system initialization...");
            this.loadConfigurations();
            this.validateConfigurations();
            this.createDefaultRank();
            this.createRankTrees();
            this.createRanks();
            this.establishConnections();
            LOGGER.info("Rank system initialization completed successfully");
            this.logSummary();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize rank system", e);
            this.clearData();
        }
        finally {
            this.isInitializing = false;
        }
    }

    private void loadConfigurations() {
        LOGGER.info("Loading configurations...");
        this.rankSystemSection = this.loadSystemConfig();
        File pathsDir = new File(this.rdq.getPlugin().getDataFolder(), "rank/paths");
        if (pathsDir.mkdirs()) {
            LOGGER.info("Created rank paths directory");
        }
        this.loadRankTreeConfigs();
        this.loadRankConfigs();
        LOGGER.info("Loaded " + this.rankTreeSections.size() + " trees with " + this.rankSections.values().stream().mapToInt(Map::size).sum() + " total ranks");
    }

    private RankSystemSection loadSystemConfig() {
        try {
            ConfigManager cfgManager = new ConfigManager((Plugin)this.rdq.getPlugin(), FILE_PATH);
            ConfigKeeper<RankSystemSection> cfgKeeper = new ConfigKeeper<RankSystemSection>(cfgManager, FILE_NAME, RankSystemSection.class);
            return (RankSystemSection)cfgKeeper.rootSection;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading rank system config, using defaults", e);
            return new RankSystemSection(new EvaluationEnvironmentBuilder());
        }
    }

    private void loadRankTreeConfigs() {
        File folder = new File(this.rdq.getPlugin().getDataFolder(), "rank/paths");
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        for (String fileName : INITIAL_RANKS) {
            this.loadSingleTreeConfig(fileName);
        }
        File[] files = folder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                if (INITIAL_RANKS.contains(file.getName().toLowerCase())) continue;
                this.loadSingleTreeConfig(file.getName());
            }
        }
    }

    private void loadSingleTreeConfig(String fileName) {
        try {
            String treeId = this.toIdentifier(fileName);
            ConfigManager cfgManager = new ConfigManager((Plugin)this.rdq.getPlugin(), "rank/paths");
            ConfigKeeper<RankTreeSection> cfgKeeper = new ConfigKeeper<RankTreeSection>(cfgManager, fileName, RankTreeSection.class);
            RankTreeSection section = (RankTreeSection)cfgKeeper.rootSection;
            section.setTreeId(treeId);
            section.afterParsing(new ArrayList<Field>());
            this.rankTreeSections.put(treeId, section);
            LOGGER.fine("Loaded tree config: " + treeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load tree config: " + fileName, e);
        }
    }

    private void loadRankConfigs() {
        this.rankTreeSections.forEach((treeId, treeSection) -> {
            Map<String, RankSection> treeRanks = treeSection.getRanks();
            if (treeRanks == null || treeRanks.isEmpty()) {
                LOGGER.warning("No ranks found in tree config: " + treeId);
                return;
            }
            LOGGER.info("Loading " + treeRanks.size() + " ranks from tree: " + treeId);
            treeRanks.forEach((rankId, rankSection) -> {
                rankSection.setRankTreeName((String)treeId);
                rankSection.setRankName((String)rankId);
                Map<String, BaseRequirementSection> configRequirements = rankSection.getRequirements();
                if (configRequirements != null && !configRequirements.isEmpty()) {
                    LOGGER.info("  Config: Rank '" + rankId + "' has " + configRequirements.size() + " requirements: " + String.valueOf(configRequirements.keySet()));
                } else {
                    LOGGER.info("  Config: Rank '" + rankId + "' has no requirements configured");
                }
                this.processRequirementContext((RankSection)rankSection, (String)treeId, (String)rankId);
                try {
                    rankSection.afterParsing(new ArrayList<Field>());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to process rank " + rankId, e);
                }
            });
            this.rankSections.put((String)treeId, treeRanks);
        });
    }

    private void processRequirementContext(RankSection rankSection, String treeId, String rankId) {
        Map<String, BaseRequirementSection> requirements = rankSection.getRequirements();
        if (requirements == null) {
            return;
        }
        requirements.forEach((reqKey, reqSection) -> {
            if (reqSection != null) {
                reqSection.setContext(treeId, rankId, (String)reqKey);
                try {
                    reqSection.afterParsing(new ArrayList<Field>());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to process requirement " + reqKey, e);
                }
            }
        });
    }

    private void validateConfigurations() {
        ArrayList errors = new ArrayList();
        Set<String> validTreeIds = this.rankTreeSections.keySet();
        this.rankTreeSections.forEach((treeId, config) -> {
            this.validateReferences(config.getPrerequisiteRankTrees(), validTreeIds, errors, "Tree " + treeId + " has invalid prerequisite: ");
            this.validateReferences(config.getUnlockedRankTrees(), validTreeIds, errors, "Tree " + treeId + " has invalid unlocked tree: ");
            this.validateReferences(config.getConnectedRankTrees(), validTreeIds, errors, "Tree " + treeId + " has invalid connected tree: ");
        });
        this.rankSections.forEach((treeId, treeRanks) -> {
            Set validRankIds = treeRanks.keySet();
            treeRanks.forEach((rankId, config) -> {
                this.validateReferences(config.getPreviousRanks(), validRankIds, errors, "Rank " + rankId + " has invalid previous rank: ");
                this.validateReferences(config.getNextRanks(), validRankIds, errors, "Rank " + rankId + " has invalid next rank: ");
            });
        });
        this.rankTreeSections.keySet().forEach(treeId -> {
            if (this.hasCycle((String)treeId, (Set<String>)new HashSet<String>(), (Set<String>)new HashSet<String>())) {
                errors.add("Cycle detected in prerequisites starting at: " + treeId);
            }
        });
        if (!errors.isEmpty()) {
            errors.forEach(e -> LOGGER.severe("Validation error: " + e));
            throw new IllegalStateException("Configuration validation failed");
        }
    }

    private void validateReferences(List<String> refs, Set<String> valid, List<String> errors, String prefix) {
        if (refs == null) {
            return;
        }
        refs.stream().filter(r -> !valid.contains(r)).forEach(r -> errors.add(prefix + r));
    }

    private boolean hasCycle(String treeId, Set<String> visited, Set<String> stack) {
        if (stack.contains(treeId)) {
            return true;
        }
        if (visited.contains(treeId)) {
            return false;
        }
        visited.add(treeId);
        stack.add(treeId);
        RankTreeSection section = this.rankTreeSections.get(treeId);
        if (section != null) {
            for (String preReq : section.getPrerequisiteRankTrees()) {
                if (!this.hasCycle(preReq, visited, stack)) continue;
                return true;
            }
        }
        stack.remove(treeId);
        return false;
    }

    private void createDefaultRank() {
        if (this.rankSystemSection == null) {
            return;
        }
        String defaultRankId = this.rankSystemSection.getDefaultRank().getDefaultRankIdentifier();
        if (defaultRankId == null || defaultRankId.isBlank()) {
            return;
        }
        LOGGER.info("Creating default rank: " + defaultRankId);
        try {
            RRank existing = this.findRankByIdentifier(defaultRankId);
            if (existing != null) {
                this.defaultRank = existing;
                LOGGER.info("Using existing default rank: " + defaultRankId);
                return;
            }
            DefaultRankSection cfg = this.rankSystemSection.getDefaultRank();
            RRank newRank = new RRank(defaultRankId, cfg.getDisplayNameKey(), cfg.getDescriptionKey(), cfg.getLuckPermsGroup(), cfg.getPrefixKey(), cfg.getSuffixKey(), cfg.getIcon(), true, cfg.getTier(), cfg.getWeight());
            this.rdq.getRankRepository().create(newRank);
            this.defaultRank = newRank;
            LOGGER.info("Created default rank: " + defaultRankId);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create default rank", e);
        }
    }

    private void createRankTrees() {
        if (this.rankTreeSections.isEmpty()) {
            return;
        }
        LOGGER.info("Creating " + this.rankTreeSections.size() + " rank trees...");
        this.rankTreeSections.forEach((treeId, config) -> {
            try {
                RRankTree existing;
                if (config.getMinimumRankTreesToBeDone() > 0 && config.getPrerequisiteRankTrees().isEmpty()) {
                    config.setMinimumRankTreesToBeDone(0);
                    LOGGER.info("Reset minimumRankTreesToBeDone to 0 for tree: " + treeId);
                }
                if ((existing = this.findTreeByIdentifier((String)treeId)) != null) {
                    existing.setDisplayOrder(config.getDisplayOrder());
                    existing.setMinimumRankTreesToBeDone(config.getMinimumRankTreesToBeDone());
                    existing.setFinalRankTree(config.getFinalRankTree());
                    this.rdq.getRankTreeRepository().update(existing);
                    this.rankTrees.put((String)treeId, existing);
                    LOGGER.fine("Updated tree: " + treeId);
                } else {
                    RRankTree newTree = new RRankTree((String)treeId, config.getDisplayNameKey(), config.getDescriptionKey(), config.getIcon(), config.getDisplayOrder(), config.getMinimumRankTreesToBeDone(), config.getEnabled(), config.getFinalRankTree());
                    LOGGER.info("Creating new tree in DB: " + treeId + ", enabled=" + config.getEnabled());
                    RRankTree created = this.rdq.getRankTreeRepository().create(newTree);
                    LOGGER.info("Created tree with ID: " + String.valueOf(created != null ? created.getId() : "null"));
                    this.rankTrees.put((String)treeId, created != null ? created : newTree);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to create/update tree: " + treeId, e);
            }
        });
        LOGGER.info("Created/updated " + this.rankTrees.size() + " rank trees");
    }

    private void createRanks() {
        if (this.rankSections.isEmpty()) {
            return;
        }
        LOGGER.info("Creating ranks...");
        this.rankSections.forEach((treeId, treeRanks) -> {
            RRankTree rankTree = this.rankTrees.get(treeId);
            if (rankTree == null) {
                LOGGER.warning("Tree not found for ranks: " + treeId);
                return;
            }
            HashMap createdRanks = new HashMap();
            treeRanks.forEach((rankId, config) -> {
                try {
                    RRank rank = this.createOrUpdateRank((String)rankId, (RankSection)config, rankTree);
                    if (rank != null) {
                        createdRanks.put(rankId, rank);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to create rank: " + rankId, e);
                }
            });
            this.ranks.put((String)treeId, createdRanks);
        });
        this.populateRankTreeRanksCollections();
        int total = this.ranks.values().stream().mapToInt(Map::size).sum();
        LOGGER.info("Created/updated " + total + " ranks");
    }

    private void populateRankTreeRanksCollections() {
        this.ranks.forEach((treeId, treeRanks) -> {
            RRankTree rankTree = this.rankTrees.get(treeId);
            if (rankTree != null) {
                ArrayList<RRank> rankList = new ArrayList<RRank>(treeRanks.values());
                rankTree.setRanks(rankList);
                LOGGER.fine("Populated " + rankList.size() + " ranks for tree: " + treeId);
            }
        });
    }

    private RRank createOrUpdateRank(String rankId, RankSection config, RRankTree rankTree) {
        RRank existing = this.findRankByIdentifier(rankId);
        if (existing != null) {
            boolean needsTreeUpdate;
            boolean bl = needsTreeUpdate = !Objects.equals(existing.getRankTree() != null ? existing.getRankTree().getId() : null, rankTree != null ? rankTree.getId() : null);
            if (needsTreeUpdate) {
                existing.setRankTree(rankTree);
                this.rdq.getRankRepository().update(existing);
            }
            this.updateRankRequirements(rankId, config);
            return this.findRankByIdentifier(rankId);
        }
        RRank newRank = new RRank(rankId, config.getDisplayNameKey(), config.getDescriptionKey(), config.getLuckPermsGroup(), config.getPrefixKey(), config.getSuffixKey(), config.getIcon(), config.getInitialRank(), config.getTier(), config.getWeight(), rankTree);
        this.rdq.getRankRepository().create(newRank);
        LOGGER.fine("Created rank: " + rankId);
        this.updateRankRequirements(rankId, config);
        return this.findRankByIdentifier(rankId);
    }

    private void updateRankRequirements(String rankId, RankSection config) {
        try {
            RRank rank = this.findRankByIdentifier(rankId);
            if (rank == null) {
                LOGGER.warning("Rank not found for requirements update: " + rankId);
                return;
            }
            this.cleanupPlayerProgress(rank);
            Map<String, BaseRequirementSection> configReqs = config.getRequirements();
            LOGGER.info("updateRankRequirements for '" + rankId + "': config has " + (configReqs != null ? configReqs.size() : 0) + " requirements: " + String.valueOf(configReqs != null ? configReqs.keySet() : "null"));
            List<RRankUpgradeRequirement> newRequirements = this.requirementFactory.parseRequirements(rank, configReqs);
            if (newRequirements.isEmpty()) {
                rank.getUpgradeRequirements().clear();
                this.rdq.getRankRepository().update(rank);
                LOGGER.info("No requirements found for rank: " + rankId);
                return;
            }
            ArrayList<RRequirement> savedRequirements = new ArrayList<RRequirement>();
            for (RRankUpgradeRequirement upgradeReq : newRequirements) {
                RRequirement req = upgradeReq.getRequirement();
                if (req.getId() == null) {
                    req = this.rdq.getRequirementRepository().create(req);
                }
                savedRequirements.add(req);
            }
            rank = this.findRankByIdentifier(rankId);
            if (rank == null) {
                return;
            }
            rank.getUpgradeRequirements().clear();
            for (int i = 0; i < newRequirements.size(); ++i) {
                RRankUpgradeRequirement template = newRequirements.get(i);
                RRankUpgradeRequirement newUpgradeReq = new RRankUpgradeRequirement(null, (RRequirement)savedRequirements.get(i), template.getIcon());
                newUpgradeReq.setDisplayOrder(template.getDisplayOrder());
                rank.addUpgradeRequirement(newUpgradeReq);
            }
            this.rdq.getRankRepository().update(rank);
            LOGGER.info("Updated " + newRequirements.size() + " requirements for rank: " + rankId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to update requirements for rank: " + rankId, e);
        }
    }

    private void cleanupPlayerProgress(RRank rank) {
        try {
            for (RRankUpgradeRequirement upgradeReq : rank.getUpgradeRequirements()) {
                List progress = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("upgradeRequirement", upgradeReq));
                for (RPlayerRankUpgradeProgress p : progress) {
                    this.rdq.getPlayerRankUpgradeProgressRepository().delete(p.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to cleanup player progress for rank: " + rank.getIdentifier(), e);
        }
    }

    private void establishConnections() {
        LOGGER.info("Establishing connections...");
        this.rankSections.forEach((treeId, treeRanks) -> {
            Set validRankIds = treeRanks.keySet();
            treeRanks.forEach((rankId, config) -> {
                try {
                    this.updateRankConnections((String)rankId, (RankSection)config, validRankIds, (String)treeId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to update connections for rank: " + rankId, e);
                }
            });
        });
        this.rankTreeSections.forEach((treeId, config) -> {
            try {
                this.updateTreeConnections((String)treeId, (RankTreeSection)config);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to update connections for tree: " + treeId, e);
            }
        });
        LOGGER.info("Connections established");
    }

    private void updateRankConnections(String rankId, RankSection config, Set<String> validRankIds, String treeId) {
        RRank cachedRank;
        RRank rank = this.findRankByIdentifier(rankId);
        if (rank == null) {
            return;
        }
        List<String> prevRanks = config.getPreviousRanks().stream().filter(validRankIds::contains).collect(Collectors.toList());
        rank.setPreviousRanks(prevRanks);
        List<String> nextRanks = config.getNextRanks().stream().filter(validRankIds::contains).collect(Collectors.toList());
        rank.setNextRanks(nextRanks);
        this.rdq.getRankRepository().update(rank);
        Map<String, RRank> cachedTreeRanks = this.ranks.get(treeId);
        if (cachedTreeRanks != null && (cachedRank = cachedTreeRanks.get(rankId)) != null) {
            cachedRank.setPreviousRanks(prevRanks);
            cachedRank.setNextRanks(nextRanks);
        }
    }

    private void updateTreeConnections(String treeId, RankTreeSection config) {
        RRankTree tree = this.findTreeByIdentifier(treeId);
        if (tree == null) {
            return;
        }
        List<RRankTree> preReqTrees = config.getPrerequisiteRankTrees().stream().map(this::findTreeByIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        tree.setPrerequisiteRankTrees(preReqTrees);
        List<RRankTree> unlockedTrees = config.getUnlockedRankTrees().stream().map(this::findTreeByIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        tree.setUnlockedRankTrees(unlockedTrees);
        List<RRankTree> connectedTrees = config.getConnectedRankTrees().stream().map(this::findTreeByIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        tree.setConnectedRankTrees(connectedTrees);
        this.rdq.getRankTreeRepository().update(tree);
    }

    @Nullable
    private RRank findRankByIdentifier(String identifier) {
        return this.rdq.getRankRepository().findByAttributes(Map.of("identifier", identifier)).orElse(null);
    }

    @Nullable
    private RRankTree findTreeByIdentifier(String identifier) {
        return this.rdq.getRankTreeRepository().findByAttributes(Map.of("identifier", identifier)).orElse(null);
    }

    private String toIdentifier(String fileName) {
        return fileName.replace(".yml", "").replace(" ", "").replace("-", "_").toLowerCase();
    }

    private void clearData() {
        this.rankTreeSections.clear();
        this.rankSections.clear();
        this.rankTrees.clear();
        this.ranks.clear();
        this.defaultRank = null;
    }

    private void logSummary() {
        int totalRanks = this.ranks.values().stream().mapToInt(Map::size).sum();
        int totalRequirements = 0;
        LOGGER.info("=== Rank System Summary ===");
        LOGGER.info("Rank Trees: " + this.rankTrees.size());
        LOGGER.info("Total Ranks: " + totalRanks);
        LOGGER.info("Default Rank: " + (this.defaultRank != null ? this.defaultRank.getIdentifier() : "None"));
        for (Map.Entry<String, Map<String, RRank>> treeEntry : this.ranks.entrySet()) {
            String treeId = treeEntry.getKey();
            Map<String, RRank> treeRanks = treeEntry.getValue();
            int treeReqCount = 0;
            for (Map.Entry<String, RRank> rankEntry : treeRanks.entrySet()) {
                RRank rank = rankEntry.getValue();
                int reqCount = rank.getUpgradeRequirements() != null ? rank.getUpgradeRequirements().size() : 0;
                treeReqCount += reqCount;
                if (reqCount <= 0) continue;
                LOGGER.info("  [" + treeId + "] Rank '" + rank.getIdentifier() + "' has " + reqCount + " requirements");
            }
            LOGGER.info("Tree '" + treeId + "': " + treeRanks.size() + " ranks, " + treeReqCount + " total requirements");
            totalRequirements += treeReqCount;
        }
        LOGGER.info("Total Requirements: " + totalRequirements);
        LOGGER.info("===========================");
    }

    public Map<String, RRankTree> getRankTrees() {
        return Map.copyOf(this.rankTrees);
    }

    public Map<String, Map<String, RRank>> getRanks() {
        return this.ranks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Map.copyOf((Map)e.getValue())));
    }

    @Nullable
    public RRank getDefaultRank() {
        return this.defaultRank;
    }

    public boolean isInitialized() {
        return !this.rankTrees.isEmpty() || this.defaultRank != null;
    }

    public RankSystemSection getRankSystemSection() {
        return this.rankSystemSection;
    }
}

