/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.rank;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankPath;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.rank.IRankSystemService;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class FreeRankSystemService
implements IRankSystemService {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ-Free");
    private static final int MAX_ABSOLVABLE_RANK_TREES = 1;
    private static final int MAX_RANKS_PER_TREE = 3;
    private static final int MAX_ACTIVE_RANK_PATHS = 1;
    private static FreeRankSystemService instance;
    private RDQ rdq;

    private FreeRankSystemService() {
    }

    public static FreeRankSystemService initialize(@NotNull RDQ rdq) {
        if (instance == null) {
            instance = new FreeRankSystemService();
        }
        FreeRankSystemService.instance.rdq = rdq;
        LOGGER.log(Level.INFO, "FreeRankSystemService initialized with limits: maxTrees=1, maxRanks=3, maxPaths=1");
        return instance;
    }

    public static FreeRankSystemService getInstance() {
        if (instance == null) {
            throw new IllegalStateException("FreeRankSystemService not initialized. Call initialize() first.");
        }
        return instance;
    }

    @Override
    public boolean isPremium() {
        return false;
    }

    @Override
    public int getMaxAbsolvableRankTrees() {
        return 1;
    }

    @Override
    public int getMaxRanksPerTree() {
        return 3;
    }

    @Override
    public int getMaxActiveRankPaths() {
        return 1;
    }

    @Override
    public boolean canStartNewRankTree(@NotNull RDQPlayer player) {
        int absolvedCount = this.getAbsolvedRankTreeCount(player);
        return absolvedCount < 1;
    }

    @Override
    public boolean canProgressToRank(@NotNull RDQPlayer player, @NotNull RRank rank) {
        RRankTree rankTree = rank.getRankTree();
        if (rankTree == null) {
            return false;
        }
        return !this.isRankBeyondLimit(rank, rankTree);
    }

    @Override
    public boolean isPreviewOnly(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        if (this.hasActiveOrAbsolvedTree(player, rankTree)) {
            return false;
        }
        int absolvedCount = this.getAbsolvedRankTreeCount(player);
        return absolvedCount >= 1;
    }

    @Override
    public boolean isRankBeyondLimit(@NotNull RRank rank, @NotNull RRankTree rankTree) {
        List<RRank> sortedRanks = rankTree.getRanks().stream().sorted(Comparator.comparingInt(RRank::getTier)).toList();
        int rankPosition = 0;
        for (int i = 0; i < sortedRanks.size(); ++i) {
            if (!sortedRanks.get(i).getIdentifier().equals(rank.getIdentifier())) continue;
            rankPosition = i + 1;
            break;
        }
        return rankPosition > 3;
    }

    @Override
    public int getAbsolvedRankTreeCount(@NotNull RDQPlayer player) {
        try {
            if (this.rdq == null) {
                return 0;
            }
            List rankPaths = this.rdq.getPlayerRankPathRepository().findAllByAttributes(Map.of("player", player));
            return (int)rankPaths.stream().map(RPlayerRankPath::getSelectedRankPath).distinct().count();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get absolved rank tree count", exception);
            return 0;
        }
    }

    @Override
    public int getActiveRankPathCount(@NotNull RDQPlayer player) {
        try {
            if (this.rdq == null) {
                return 0;
            }
            List rankPaths = this.rdq.getPlayerRankPathRepository().findAllByAttributes(Map.of("player", player));
            return (int)rankPaths.stream().filter(RPlayerRankPath::isActive).count();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get active rank path count", exception);
            return 0;
        }
    }

    @Override
    @NotNull
    public String getRestrictionMessageKey(@NotNull IRankSystemService.RankRestrictionType restrictionType) {
        return switch (restrictionType) {
            default -> throw new MatchException(null, null);
            case IRankSystemService.RankRestrictionType.MAX_RANK_TREES_REACHED -> "free.restriction.max_rank_trees";
            case IRankSystemService.RankRestrictionType.MAX_RANKS_PER_TREE_REACHED -> "free.restriction.max_ranks_per_tree";
            case IRankSystemService.RankRestrictionType.MAX_ACTIVE_PATHS_REACHED -> "free.restriction.max_active_paths";
            case IRankSystemService.RankRestrictionType.RANK_TREE_PREVIEW_ONLY -> "free.restriction.preview_only";
            case IRankSystemService.RankRestrictionType.RANK_BEYOND_LIMIT -> "free.restriction.rank_beyond_limit";
        };
    }

    private boolean hasActiveOrAbsolvedTree(@NotNull RDQPlayer player, @NotNull RRankTree rankTree) {
        try {
            if (this.rdq == null) {
                return false;
            }
            List rankPaths = this.rdq.getPlayerRankPathRepository().findAllByAttributes(Map.of("player", player));
            return rankPaths.stream().anyMatch(path -> path.getSelectedRankPath() != null && path.getSelectedRankPath().getIdentifier().equals(rankTree.getIdentifier()));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if player has tree", exception);
            return false;
        }
    }
}

