/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.permissions;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.config.permissions.PermissionsSection;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.evaluable.ConfigKeeper;
import de.jexcellence.evaluable.ConfigManager;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PermissionsService {
    private static final Logger LOGGER = CentralLogger.getLogger(PermissionsService.class.getName());
    private static final String FOLDER_PATH = "permissions";
    private static final String FILE_NAME = "permissions.yml";
    private Map<String, List<String>> permissions;
    private final RDQ rdq;

    public PermissionsService(@NotNull RDQ rdq) {
        this.rdq = rdq;
        try {
            ConfigManager cfgManager = new ConfigManager((Plugin)rdq.getPlugin(), FOLDER_PATH);
            ConfigKeeper<PermissionsSection> cfgKeeper = new ConfigKeeper<PermissionsSection>(cfgManager, FILE_NAME, PermissionsSection.class);
            this.permissions = ((PermissionsSection)cfgKeeper.rootSection).getPermissions();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error loading permissions.yml", exception);
        }
    }

    public boolean addPermissionSet(@NotNull Player player, @NotNull String pluginName, @NotNull String group, @NotNull List<String> permissions, boolean check) {
        if (check && !Bukkit.getPluginManager().isPluginEnabled(pluginName)) {
            new I18n.Builder("admin_permissions_overview_ui.errors.plugin_not_found", player).includePrefix().withPlaceholder("plugin_name", pluginName).build().sendMessage();
            return false;
        }
        if (this.rdq.getLuckPermsService() == null) {
            new I18n.Builder("admin_permissions_overview_ui.errors.no_luckperms_installed", player).includePrefix().build().sendMessage();
            return false;
        }
        for (String permission : permissions) {
            this.rdq.getLuckPermsService().assignPermission(group, permission);
        }
        LOGGER.info("Assigning " + permissions.size() + " permissions to group '" + group + "'");
        return true;
    }

    public void addPermissionSet(@NotNull String pluginName, @NotNull String group, @NotNull List<String> permissions, boolean check) {
        if (check && !Bukkit.getPluginManager().isPluginEnabled(pluginName)) {
            LOGGER.info("Notice: No LuckPerms service is enabled. Skipping permission assignment.");
            return;
        }
        if (this.rdq.getLuckPermsService() == null) {
            LOGGER.info("Notice: No LuckPerms service is enabled. Skipping permission assignment.");
            return;
        }
        for (String permission : permissions) {
            this.rdq.getLuckPermsService().assignPermission(group, permission);
        }
        LOGGER.info("Added " + permissions.size() + " permissions to group '" + group + "'.");
    }

    public void addAllPermissionSets(@NotNull Player player) {
        this.permissions.forEach((permission, value) -> this.addPermissionSet(player, "LuckPerms", (String)permission, (List<String>)value, true));
    }

    public void addAllPermissionSets() {
        this.permissions.forEach((permission, value) -> this.addPermissionSet("LuckPerms", (String)permission, (List<String>)value, true));
    }

    @Generated
    public Map<String, List<String>> getPermissions() {
        return this.permissions;
    }
}

