/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.manager;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRankUpgradeProgress;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import com.raindropcentral.rplatform.logging.CentralLogger;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RankRequirementProgressManager {
    private static final Logger LOGGER = CentralLogger.getLogger(RankRequirementProgressManager.class.getName());
    private final RDQ rdq;
    private final Map<String, RequirementProgressData> progressCache = new ConcurrentHashMap<String, RequirementProgressData>();
    private final Map<String, Long> cacheTimestamps = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_EXPIRY_MS = 30000L;

    public RankRequirementProgressManager(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @NotNull
    public RequirementProgressData getRequirementProgress(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        String cacheKey = this.generateCacheKey(player.getUniqueId().toString(), requirement.getId().toString());
        RequirementProgressData cached = this.progressCache.get(cacheKey);
        Long timestamp = this.cacheTimestamps.get(cacheKey);
        if (cached != null && timestamp != null && System.currentTimeMillis() - timestamp < 30000L) {
            return cached;
        }
        RequirementProgressData freshProgress = this.calculateRequirementProgress(player, rdqPlayer, requirement);
        this.progressCache.put(cacheKey, freshProgress);
        this.cacheTimestamps.put(cacheKey, System.currentTimeMillis());
        return freshProgress;
    }

    @NotNull
    public RequirementCompletionResult attemptRequirementCompletion(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        try {
            RPlayerRankUpgradeProgress existingProgress = this.getOrCreateProgressEntry(rdqPlayer, requirement);
            if (existingProgress.isCompleted()) {
                LOGGER.log(Level.FINE, "Requirement " + requirement.getId() + " already completed for player " + player.getName());
                return new RequirementCompletionResult(false, "requirement.already_completed", this.getRequirementProgress(player, rdqPlayer, requirement));
            }
            AbstractRequirement abstractRequirement = requirement.getRequirement().getRequirement();
            boolean isMet = abstractRequirement.isMet(player);
            if (!isMet) {
                LOGGER.log(Level.FINE, "Requirement " + requirement.getId() + " not yet met for player " + player.getName());
                return new RequirementCompletionResult(false, "requirement.not_met", this.getRequirementProgress(player, rdqPlayer, requirement));
            }
            try {
                LOGGER.log(Level.INFO, "Consuming resources for requirement " + requirement.getId() + " for player " + player.getName());
                abstractRequirement.consume(player);
                LOGGER.log(Level.INFO, "Successfully consumed resources for requirement " + requirement.getId());
            }
            catch (Exception consumeException) {
                LOGGER.log(Level.SEVERE, "Failed to consume resources for requirement " + requirement.getId() + " for player " + player.getName(), consumeException);
                return new RequirementCompletionResult(false, "requirement.consumption_failed", this.getRequirementProgress(player, rdqPlayer, requirement));
            }
            existingProgress.setProgress(1.0);
            this.rdq.getPlayerRankUpgradeProgressRepository().update(existingProgress);
            String cacheKey = this.generateCacheKey(player.getUniqueId().toString(), requirement.getId().toString());
            this.progressCache.remove(cacheKey);
            this.cacheTimestamps.remove(cacheKey);
            LOGGER.log(Level.INFO, "Successfully completed requirement " + requirement.getId() + " for player " + player.getName() + " with resource consumption");
            return new RequirementCompletionResult(true, "requirement.completed_successfully", this.getRequirementProgress(player, rdqPlayer, requirement));
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to complete requirement " + requirement.getId() + " for player " + player.getName(), exception);
            return new RequirementCompletionResult(false, "requirement.completion_error", this.getRequirementProgress(player, rdqPlayer, requirement));
        }
    }

    public boolean areAllRequirementsCompleted(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> requirements = rank.getUpgradeRequirements();
            if (requirements.isEmpty()) {
                return true;
            }
            for (RRankUpgradeRequirement requirement : requirements) {
                RequirementProgressData progress = this.getRequirementProgress(player, rdqPlayer, requirement);
                if (progress.isCompleted()) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to check if all requirements are completed for rank " + rank.getIdentifier(), exception);
            return false;
        }
    }

    public double getRankOverallProgress(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> requirements = rank.getUpgradeRequirements();
            if (requirements.isEmpty()) {
                return 1.0;
            }
            double totalProgress = 0.0;
            for (RRankUpgradeRequirement requirement : requirements) {
                RequirementProgressData progress = this.getRequirementProgress(player, rdqPlayer, requirement);
                totalProgress += progress.getProgressPercentage();
            }
            return totalProgress / (double)requirements.size();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to calculate overall progress for rank " + rank.getIdentifier(), exception);
            return 0.0;
        }
    }

    public void initializeRankProgressTracking(@NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> requirements = rank.getUpgradeRequirements();
            for (RRankUpgradeRequirement requirement : requirements) {
                this.getOrCreateProgressEntry(rdqPlayer, requirement);
            }
            LOGGER.log(Level.INFO, "Initialized progress tracking for " + requirements.size() + " requirements in rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize progress tracking for rank " + rank.getIdentifier(), exception);
        }
    }

    public void cleaRDQPlayerCache(@NotNull Player player) {
        String playerPrefix = player.getUniqueId().toString() + ":";
        this.progressCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerPrefix));
        this.cacheTimestamps.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerPrefix));
        LOGGER.log(Level.FINE, "Cleared progress cache for player " + player.getName());
    }

    public void clearAllCache() {
        this.progressCache.clear();
        this.cacheTimestamps.clear();
        LOGGER.log(Level.FINE, "Cleared all progress cache");
    }

    public void refreshRankProgress(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRank rank) {
        try {
            Set<RRankUpgradeRequirement> requirements = rank.getUpgradeRequirements();
            for (RRankUpgradeRequirement requirement : requirements) {
                String cacheKey = this.generateCacheKey(player.getUniqueId().toString(), requirement.getId().toString());
                this.progressCache.remove(cacheKey);
                this.cacheTimestamps.remove(cacheKey);
                this.getRequirementProgress(player, rdqPlayer, requirement);
            }
            LOGGER.log(Level.INFO, "Refreshed progress cache for " + requirements.size() + " requirements in rank " + rank.getIdentifier());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh rank progress for rank " + rank.getIdentifier(), exception);
        }
    }

    public void refreshRequirementProgress(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        try {
            String cacheKey = this.generateCacheKey(player.getUniqueId().toString(), requirement.getId().toString());
            this.progressCache.remove(cacheKey);
            this.cacheTimestamps.remove(cacheKey);
            this.getRequirementProgress(player, rdqPlayer, requirement);
            LOGGER.log(Level.FINE, "Refreshed progress cache for requirement " + requirement.getId());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to refresh requirement progress for requirement " + requirement.getId(), exception);
        }
    }

    @NotNull
    private RequirementProgressData calculateRequirementProgress(@NotNull Player player, @NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        try {
            RPlayerRankUpgradeProgress dbProgress = this.getOrCreateProgressEntry(rdqPlayer, requirement);
            if (dbProgress.isCompleted()) {
                return new RequirementProgressData(requirement.getId().toString(), requirement.getRequirement().getRequirement().getType().name(), requirement.getRequirement().getRequirement().getDescriptionKey(), true, 1.0, RequirementStatus.COMPLETED, "requirement.status.completed", requirement.getDisplayOrder());
            }
            AbstractRequirement abstractRequirement = requirement.getRequirement().getRequirement();
            boolean isMet = false;
            double progressPercentage = 0.0;
            RequirementStatus status = RequirementStatus.NOT_STARTED;
            String statusMessage = "requirement.status.not_started";
            try {
                isMet = abstractRequirement.isMet(player);
                progressPercentage = abstractRequirement.calculateProgress(player);
                progressPercentage = Math.max(0.0, Math.min(1.0, progressPercentage));
                if (isMet) {
                    status = RequirementStatus.READY_TO_COMPLETE;
                    statusMessage = "requirement.status.ready_to_complete";
                } else if (progressPercentage > 0.0) {
                    status = RequirementStatus.IN_PROGRESS;
                    statusMessage = "requirement.status.in_progress";
                }
            }
            catch (Exception progressException) {
                LOGGER.log(Level.WARNING, "Failed to calculate progress for requirement " + requirement.getId(), progressException);
                status = RequirementStatus.ERROR;
                statusMessage = "requirement.status.error";
            }
            return new RequirementProgressData(requirement.getId().toString(), abstractRequirement.getType().name(), abstractRequirement.getDescriptionKey(), false, progressPercentage, status, statusMessage, requirement.getDisplayOrder());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Critical error calculating requirement progress for " + requirement.getId(), exception);
            return new RequirementProgressData(requirement.getId().toString(), "UNKNOWN", "requirement.error.unknown", false, 0.0, RequirementStatus.ERROR, "requirement.status.error", requirement.getDisplayOrder());
        }
    }

    @NotNull
    private RPlayerRankUpgradeProgress getOrCreateProgressEntry(@NotNull RDQPlayer rdqPlayer, @NotNull RRankUpgradeRequirement requirement) {
        try {
            List existingProgress = this.rdq.getPlayerRankUpgradeProgressRepository().findAllByAttributes(Map.of("player.uniqueId", rdqPlayer.getUniqueId(), "upgradeRequirement.id", requirement.getId()));
            if (!existingProgress.isEmpty()) {
                return (RPlayerRankUpgradeProgress)existingProgress.get(0);
            }
            RPlayerRankUpgradeProgress newProgress = new RPlayerRankUpgradeProgress(rdqPlayer, requirement);
            this.rdq.getPlayerRankUpgradeProgressRepository().create(newProgress);
            LOGGER.log(Level.FINE, "Created new progress entry for requirement " + requirement.getId() + " and player " + rdqPlayer.getPlayerName());
            return newProgress;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to get or create progress entry", exception);
            throw new RuntimeException("Database operation failed", exception);
        }
    }

    @NotNull
    private String generateCacheKey(@NotNull String playerId, @NotNull String requirementId) {
        return playerId + ":" + requirementId;
    }

    public static class RequirementProgressData {
        private final String requirementId;
        private final String requirementType;
        private final String descriptionKey;
        private final boolean isCompleted;
        private final double progressPercentage;
        private final RequirementStatus status;
        private final String statusMessage;
        private final int displayOrder;

        public RequirementProgressData(@NotNull String requirementId, @NotNull String requirementType, @NotNull String descriptionKey, boolean isCompleted, double progressPercentage, @NotNull RequirementStatus status, @NotNull String statusMessage, int displayOrder) {
            this.requirementId = requirementId;
            this.requirementType = requirementType;
            this.descriptionKey = descriptionKey;
            this.isCompleted = isCompleted;
            this.progressPercentage = progressPercentage;
            this.status = status;
            this.statusMessage = statusMessage;
            this.displayOrder = displayOrder;
        }

        public String getRequirementId() {
            return this.requirementId;
        }

        public String getRequirementType() {
            return this.requirementType;
        }

        public String getDescriptionKey() {
            return this.descriptionKey;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public double getProgressPercentage() {
            return this.progressPercentage;
        }

        public RequirementStatus getStatus() {
            return this.status;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public int getDisplayOrder() {
            return this.displayOrder;
        }

        public int getProgressAsPercentage() {
            return (int)Math.round(this.progressPercentage * 100.0);
        }

        public boolean hasProgress() {
            return this.progressPercentage > 0.0;
        }

        public String getFormattedProgress() {
            return this.getProgressAsPercentage() + "%";
        }

        public boolean canBeCompleted() {
            return this.status == RequirementStatus.READY_TO_COMPLETE && !this.isCompleted;
        }

        public String toString() {
            return "RequirementProgressData{id='" + this.requirementId + "', type='" + this.requirementType + "', completed=" + this.isCompleted + ", progress=" + this.getProgressAsPercentage() + "%, status=" + String.valueOf((Object)this.status) + "}";
        }
    }

    public static class RequirementCompletionResult {
        private final boolean success;
        private final String messageKey;
        private final RequirementProgressData updatedProgress;

        public RequirementCompletionResult(boolean success, @NotNull String messageKey, @NotNull RequirementProgressData updatedProgress) {
            this.success = success;
            this.messageKey = messageKey;
            this.updatedProgress = updatedProgress;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public RequirementProgressData getUpdatedProgress() {
            return this.updatedProgress;
        }

        public void sendMessage(@NotNull Player player) {
            new I18n.Builder(this.messageKey, player).includePrefix().build().sendMessage();
        }
    }

    public static enum RequirementStatus {
        NOT_STARTED,
        IN_PROGRESS,
        READY_TO_COMPLETE,
        COMPLETED,
        ERROR;

    }
}

