/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.listener;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RPlayerRank;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rplatform.logging.CentralLogger;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerPreLogin
implements Listener {
    private static final Logger LOGGER = CentralLogger.getLogger("RDQ");
    private final RDQ rdq;

    public PlayerPreLogin(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPreLogin(AsyncPlayerPreLoginEvent event) {
        UUID uniqueId = event.getUniqueId();
        String playerName = event.getName();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.rdq.getPlayerRepository().findByAttributes(Map.of("uniqueId", uniqueId)).orElse(null), this.rdq.getExecutor()).thenCompose(existing -> existing == null ? this.createPlayer(uniqueId, playerName) : this.handlePlayer((RDQPlayer)existing, playerName))).exceptionally(throwable -> {
            LOGGER.log(Level.WARNING, "Error handling pre-login for " + playerName + " (" + String.valueOf(uniqueId) + ")", (Throwable)throwable);
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)Component.text((String)"Player data could not be processed. Please try again or contact the administrator of the server."));
            return null;
        });
    }

    private CompletableFuture<RDQPlayer> handlePlayer(@NotNull RDQPlayer player, @NotNull String playerName) {
        if (player.getPlayerName().equals(playerName)) {
            return CompletableFuture.completedFuture(player);
        }
        player.setPlayerName(playerName);
        return this.rdq.getPlayerRepository().updateAsync(player);
    }

    private CompletableFuture<RDQPlayer> createPlayer(@NotNull UUID uniqueId, @NotNull String playerName) {
        RRank defaultRank;
        RDQPlayer player = new RDQPlayer(uniqueId, playerName);
        if (this.rdq.getRankSystemFactory().getDefaultRank() != null && (defaultRank = (RRank)this.rdq.getRankRepository().findByAttributes(Map.of("identifier", this.rdq.getRankSystemFactory().getDefaultRank().getIdentifier())).orElse(null)) != null) {
            RPlayerRank defaultPlayerRank = new RPlayerRank(player, defaultRank);
            player.addPlayerRank(defaultPlayerRank);
        }
        return this.rdq.getPlayerRepository().createAsync(player).thenCompose(created -> this.addPlayerStatistic(player));
    }

    private CompletableFuture<RDQPlayer> addPlayerStatistic(@NotNull RDQPlayer player) {
        return CompletableFuture.completedFuture(player);
    }
}

