/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.listener;

import com.raindropcentral.rdq.RDQ;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class BountyPlayerQuitListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(BountyPlayerQuitListener.class.getName());
    private final RDQ rdq;

    public BountyPlayerQuitListener(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.rdq.getVisualIndicatorManager().hasIndicators(playerId)) {
            this.rdq.getVisualIndicatorManager().removeIndicators(playerId);
            LOGGER.fine("Cleaned up visual indicators tracking for " + player.getName() + " on quit");
        }
    }
}

