/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.listener;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.database.entity.bounty.Bounty;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class BountyPlayerJoinListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("RDQ");
    private final RDQ rdq;

    public BountyPlayerJoinListener(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LOGGER.info("Checking for bounty on player join: " + player.getName());
        try {
            Bounty bounty = this.rdq.getBountyFactory().getBounty(player.getUniqueId());
            if (bounty != null && bounty.isActive()) {
                LOGGER.info("Found active bounty immediately for " + player.getName() + " (ID: " + bounty.getId() + ")");
                this.rdq.getPlatform().getScheduler().runDelayed(() -> {
                    if (player.isOnline()) {
                        this.applyVisualIndicators(player, bounty);
                        this.notifyPlayerOfBounty(player, bounty);
                    }
                }, 20L);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Immediate bounty check failed for " + player.getName() + ": " + e.getMessage());
        }
        this.scheduleVisualIndicatorCheck(player, 0);
    }

    private void scheduleVisualIndicatorCheck(@NotNull Player player, int attempt) {
        if (!player.isOnline() || attempt >= 3) {
            if (attempt >= 3) {
                LOGGER.warning("Failed to apply visual indicators after 3 attempts for " + player.getName());
            }
            return;
        }
        long delay = 40L * (long)(attempt + 1);
        this.rdq.getPlatform().getScheduler().runDelayed(() -> {
            if (!player.isOnline()) {
                return;
            }
            LOGGER.info("Async attempt " + (attempt + 1) + " - Checking for bounty: " + player.getName());
            ((CompletableFuture)this.rdq.getBountyFactory().getBountyAsync(player.getUniqueId()).thenAccept(bounty -> {
                if (bounty == null) {
                    LOGGER.info("No bounty found for player: " + player.getName() + " (async attempt " + (attempt + 1) + ")");
                    this.scheduleVisualIndicatorCheck(player, attempt + 1);
                    return;
                }
                if (!bounty.isActive()) {
                    LOGGER.info("Bounty found but not active for player: " + player.getName());
                    return;
                }
                LOGGER.info("Active bounty found for player: " + player.getName() + " (ID: " + bounty.getId() + ") on async attempt " + (attempt + 1));
                this.rdq.getPlatform().getScheduler().runSync(() -> {
                    if (player.isOnline()) {
                        this.applyVisualIndicators(player, (Bounty)bounty);
                        if (attempt == 0) {
                            this.notifyPlayerOfBounty(player, (Bounty)bounty);
                        }
                    }
                });
            })).exceptionally(ex -> {
                LOGGER.log(Level.SEVERE, "Error checking bounty for player " + player.getName() + " on async attempt " + (attempt + 1), (Throwable)ex);
                this.scheduleVisualIndicatorCheck(player, attempt + 1);
                return null;
            });
        }, delay);
    }

    private void applyVisualIndicators(@NotNull Player player, @NotNull Bounty bounty) {
        try {
            LOGGER.info("Applying visual indicators to " + player.getName() + " (bounty ID: " + bounty.getId() + ")");
            if (this.rdq.getVisualIndicatorManager() != null) {
                this.rdq.getVisualIndicatorManager().forceRefreshIndicators(player);
            }
            this.rdq.getPlatform().getScheduler().runDelayed(() -> {
                if (player.isOnline()) {
                    this.rdq.getVisualIndicatorManager().forceRefreshIndicators(player);
                    LOGGER.info("Reapplied visual indicators to " + player.getName() + " (second attempt)");
                }
            }, 40L);
            this.rdq.getPlatform().getScheduler().runDelayed(() -> {
                if (player.isOnline()) {
                    this.rdq.getVisualIndicatorManager().forceRefreshIndicators(player);
                    LOGGER.info("Reapplied visual indicators to " + player.getName() + " (third attempt)");
                }
            }, 100L);
            LOGGER.info("Applied visual indicators to " + player.getName() + " (bounty ID: " + bounty.getId() + ") on join");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to apply visual indicators to " + player.getName(), e);
        }
    }

    private void notifyPlayerOfBounty(@NotNull Player player, @NotNull Bounty bounty) {
        new I18n.Builder("bounty_listener.bounty_active.warning", player).includePrefix().build().sendMessage();
        new I18n.Builder("bounty_listener.bounty_active.value", player).withPlaceholder("bounty_value", String.format("%.2f", bounty.getTotalEstimatedValue())).build().sendMessage();
        if (bounty.getExpiresAt() != null) {
            new I18n.Builder("bounty_listener.bounty_active.expires", player).withPlaceholder("expires_at", bounty.getExpiresAt().toString()).build().sendMessage();
        }
        new I18n.Builder("bounty_listener.bounty_active.commissioner", player).withPlaceholder("commissioner_uuid", bounty.getCommissionerUniqueId().toString()).build().sendMessage();
    }
}

