/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.listener;

import com.raindropcentral.rdq.RDQ;
import com.raindropcentral.rdq.bounty.claim.ClaimResult;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.jetbrains.annotations.NotNull;

public class BountyPlayerDeathListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(BountyPlayerDeathListener.class.getName());
    private final RDQ rdq;

    public BountyPlayerDeathListener(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Player victim = event.getEntity();
        UUID victimUuid = victim.getUniqueId();
        Player killer = victim.getKiller();
        UUID lastHitterUuid = killer != null ? killer.getUniqueId() : null;
        Location deathLocation = victim.getLocation();
        LOGGER.info("Player death: " + victim.getName() + ", killer: " + (killer != null ? killer.getName() : "null") + ", has bounty: " + this.rdq.getBountyFactory().hasBounty(victimUuid));
        ((CompletableFuture)this.rdq.getBountyFactory().claimBounty(victimUuid, lastHitterUuid, deathLocation).thenAccept(claimResult -> {
            if (!claimResult.hasWinners()) {
                return;
            }
            this.rdq.getVisualIndicatorManager().removeIndicators(victimUuid);
            this.rdq.getPlatform().getScheduler().runSync(() -> {
                this.announceClaimToWinners((ClaimResult)claimResult, victim);
                this.announceClaimToBroadcast((ClaimResult)claimResult, victim);
            });
        })).exceptionally(ex -> {
            LOGGER.log(Level.SEVERE, "Error processing bounty claim for " + victim.getName(), (Throwable)ex);
            return null;
        });
    }

    private void announceClaimToWinners(@NotNull ClaimResult claimResult, @NotNull Player victim) {
        for (Map.Entry<UUID, Double> entry : claimResult.winners().entrySet()) {
            UUID winnerUuid = entry.getKey();
            Double proportion = entry.getValue();
            Player winner = Bukkit.getPlayer((UUID)winnerUuid);
            if (winner == null || !winner.isOnline()) continue;
            new I18n.Builder("bounty_listener.bounty_claimed.title", winner).includePrefix().build().sendMessage();
            new I18n.Builder("bounty_listener.bounty_claimed.victim", winner).withPlaceholder("victim_name", victim.getName()).build().sendMessage();
            if (claimResult.getWinnerCount() <= 1) continue;
            new I18n.Builder("bounty_listener.bounty_claimed.share", winner).withPlaceholder("percentage", String.format("%.1f", proportion * 100.0)).build().sendMessage();
        }
    }

    private void announceClaimToBroadcast(@NotNull ClaimResult claimResult, @NotNull Player victim) {
        if (claimResult.getWinnerCount() == 1) {
            UUID winnerUuid = claimResult.winners().keySet().iterator().next();
            Player winner = Bukkit.getPlayer((UUID)winnerUuid);
            String winnerName = winner != null ? winner.getName() : "Someone";
            Component broadcastMsg = (Component)new I18n.Builder("bounty_listener.bounty_claimed.broadcast", victim).withPlaceholder("claimer_name", winnerName).withPlaceholder("victim_name", victim.getName()).build().component();
            Bukkit.broadcast((Component)broadcastMsg);
        } else {
            Component broadcastMsg = (Component)new I18n.Builder("bounty_listener.bounty_claimed.broadcast_multiple", victim).withPlaceholder("winner_count", String.valueOf(claimResult.getWinnerCount())).withPlaceholder("victim_name", victim.getName()).build().component();
            Bukkit.broadcast((Component)broadcastMsg);
        }
    }
}

