/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.listener;

import com.raindropcentral.rdq.RDQ;
import java.util.logging.Logger;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jetbrains.annotations.NotNull;

public class BountyDamageListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(BountyDamageListener.class.getName());
    private final RDQ rdq;

    public BountyDamageListener(@NotNull RDQ rdq) {
        this.rdq = rdq;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        LOGGER.info("Damage event detected: " + String.valueOf(event.getDamager().getType()) + " -> " + String.valueOf(event.getEntity().getType()) + " (damage: " + event.getFinalDamage() + ", cancelled: " + event.isCancelled() + ")");
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            LOGGER.info("Not a player victim, skipping");
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            LOGGER.info("Not a player attacker, skipping");
            return;
        }
        Player attacker = (Player)entity2;
        double damage = event.getFinalDamage();
        this.rdq.getBountyFactory().getDamageTracker().recordDamage(victim.getUniqueId(), attacker.getUniqueId(), damage);
        LOGGER.info("Recorded " + damage + " PvP damage from " + attacker.getName() + " to " + victim.getName());
    }
}

