/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.json.reward;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.raindropcentral.rdq.json.ItemStackJSONDeserializer;
import com.raindropcentral.rdq.json.ItemStackJSONSerializer;
import com.raindropcentral.rdq.reward.AbstractReward;
import java.io.IOException;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RewardParser {
    private static final ObjectMapper MAPPER = RewardParser.createObjectMapper();

    private RewardParser() {
    }

    @NotNull
    private static ObjectMapper createObjectMapper() {
        SimpleModule bukkitModule = new SimpleModule("BukkitModule");
        bukkitModule.addSerializer(ItemStack.class, (JsonSerializer)new ItemStackJSONSerializer());
        bukkitModule.addDeserializer(ItemStack.class, (JsonDeserializer)new ItemStackJSONDeserializer());
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)bukkitModule)).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).build();
    }

    @NotNull
    public static AbstractReward parse(@NotNull String json) throws IOException {
        return (AbstractReward)MAPPER.readValue(json, AbstractReward.class);
    }

    @NotNull
    public static String serialize(@NotNull AbstractReward requirement) throws IOException {
        return MAPPER.writeValueAsString((Object)requirement);
    }
}

