/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.json.requirement;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.raindropcentral.rdq.json.ItemStackJSONDeserializer;
import com.raindropcentral.rdq.json.ItemStackJSONSerializer;
import com.raindropcentral.rdq.json.requirement.RequirementMixin;
import com.raindropcentral.rdq.requirement.AbstractRequirement;
import java.io.IOException;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequirementParser {
    private static final ObjectMapper MAPPER = RequirementParser.createObjectMapper();

    private RequirementParser() {
    }

    @NotNull
    private static ObjectMapper createObjectMapper() {
        SimpleModule bukkitModule = new SimpleModule("BukkitModule");
        bukkitModule.addSerializer(ItemStack.class, (JsonSerializer)new ItemStackJSONSerializer());
        bukkitModule.addDeserializer(ItemStack.class, (JsonDeserializer)new ItemStackJSONDeserializer());
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)bukkitModule)).addMixIn(AbstractRequirement.class, RequirementMixin.class)).build();
    }

    @NotNull
    public static AbstractRequirement parse(@NotNull String json) throws IOException {
        return (AbstractRequirement)MAPPER.readValue(json, AbstractRequirement.class);
    }

    @NotNull
    public static String serialize(@NotNull AbstractRequirement requirement) throws IOException {
        return MAPPER.writeValueAsString((Object)requirement);
    }
}

