/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackJSONSerializer
extends StdSerializer<ItemStack> {
    public ItemStackJSONSerializer() {
        super(ItemStack.class);
    }

    public void serialize(@Nullable ItemStack itemStack, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) throws IOException {
        if (itemStack == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeStartObject();
        try {
            String binaryData = this.serializeToBinary(itemStack);
            jsonGenerator.writeStringField("binaryData", binaryData);
            jsonGenerator.writeStringField("serializationType", "binary");
        }
        catch (Exception e) {
            Map serialized = itemStack.serialize();
            jsonGenerator.writeFieldName("mapData");
            serializerProvider.defaultSerializeValue((Object)serialized, jsonGenerator);
            jsonGenerator.writeStringField("serializationType", "map");
        }
        jsonGenerator.writeEndObject();
    }

    private String serializeToBinary(@NotNull ItemStack itemStack) {
        byte[] data = itemStack.serializeAsBytes();
        return Base64.getEncoder().encodeToString(data);
    }
}

