/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackJSONDeserializer
extends StdDeserializer<ItemStack> {
    public ItemStackJSONDeserializer() {
        super(ItemStack.class);
    }

    @NotNull
    public ItemStack deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.readValueAsTree();
        if (node.has("serializationType")) {
            String serializationType = node.get("serializationType").asText();
            if ("binary".equals(serializationType) && node.has("binaryData")) {
                return this.deserializeFromBinary(node.get("binaryData").asText());
            }
            if ("map".equals(serializationType) && node.has("mapData")) {
                return this.deserializeFromMap(node.get("mapData"));
            }
        }
        return this.deserializeLegacyFormat(node);
    }

    @NotNull
    private ItemStack deserializeFromBinary(@NotNull String binaryData) {
        try {
            byte[] data = Base64.getDecoder().decode(binaryData);
            return ItemStack.deserializeBytes((byte[])data);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize ItemStack from binary data", e);
        }
    }

    @NotNull
    private ItemStack deserializeFromMap(@NotNull JsonNode mapNode) {
        try {
            HashMap map = new HashMap();
            mapNode.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                map.put((String)entry.getKey(), this.convertJsonNodeToObject(value));
            });
            return ItemStack.deserialize(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize ItemStack from map data", e);
        }
    }

    private Object convertJsonNodeToObject(@NotNull JsonNode node) {
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isArray()) {
            ArrayList list = new ArrayList();
            node.forEach(element -> list.add(this.convertJsonNodeToObject((JsonNode)element)));
            return list;
        }
        if (node.isObject()) {
            HashMap map = new HashMap();
            node.fields().forEachRemaining(entry -> map.put((String)entry.getKey(), this.convertJsonNodeToObject((JsonNode)entry.getValue())));
            return map;
        }
        return null;
    }

    @NotNull
    private ItemStack deserializeLegacyFormat(@NotNull JsonNode node) {
        if (node.has("type")) {
            String typeStr = node.get("type").asText();
            try {
                Material material = Material.valueOf((String)typeStr);
                int amount = node.has("amount") ? node.get("amount").asInt(1) : 1;
                return new ItemStack(material, amount);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid material type: " + typeStr, e);
            }
        }
        throw new RuntimeException("Unable to deserialize ItemStack: missing required fields");
    }
}

