/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rankpath;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_player_rank_path_completion")
public class RPlayerRankPathCompletion
extends BaseEntity {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="player_id", nullable=false)
    private RDQPlayer player;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="rank_tree_id", nullable=false)
    private RRankTree completedRankTree;
    @Column(name="completed_at", nullable=false)
    private LocalDateTime completedAt;
    @Column(name="rewards_granted", nullable=false)
    private boolean rewardsGranted;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="final_rank_id", nullable=false)
    private RRank finalRank;

    protected RPlayerRankPathCompletion() {
    }

    public RPlayerRankPathCompletion(@NotNull RDQPlayer player, @NotNull RRankTree completedRankTree, @NotNull RRank finalRank) {
        this.player = player;
        this.completedRankTree = completedRankTree;
        this.finalRank = finalRank;
        this.completedAt = LocalDateTime.now();
        this.rewardsGranted = false;
    }

    public RDQPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(RDQPlayer player) {
        this.player = player;
    }

    public RRankTree getCompletedRankTree() {
        return this.completedRankTree;
    }

    public void setCompletedRankTree(RRankTree completedRankTree) {
        this.completedRankTree = completedRankTree;
    }

    public LocalDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(LocalDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public boolean isRewardsGranted() {
        return this.rewardsGranted;
    }

    public void setRewardsGranted(boolean rewardsGranted) {
        this.rewardsGranted = rewardsGranted;
    }

    public RRank getFinalRank() {
        return this.finalRank;
    }

    public void setFinalRank(RRank finalRank) {
        this.finalRank = finalRank;
    }
}

