/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.IconSectionConverter;
import com.raindropcentral.rdq.database.entity.RRequirement;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="r_rank_upgrade_requirement")
public class RRankUpgradeRequirement
extends BaseEntity {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rank_id", nullable=false)
    private RRank rank;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="requirement_id", nullable=false)
    private RRequirement requirement;
    @Column(name="icon", nullable=false, columnDefinition="LONGTEXT")
    @Convert(converter=IconSectionConverter.class)
    private IconSection icon;
    @Column(name="display_order")
    private int displayOrder = 0;
    @Version
    @Column(name="version")
    private int version;

    protected RRankUpgradeRequirement() {
    }

    public RRankUpgradeRequirement(@Nullable RRank rank, @NotNull RRequirement requirement, @NotNull IconSection icon) {
        this.rank = rank;
        this.requirement = requirement;
        this.icon = icon;
        if (rank != null) {
            rank.addUpgradeRequirement(this);
        }
    }

    @NotNull
    public RRank getRank() {
        return this.rank;
    }

    @NotNull
    public RRequirement getRequirement() {
        return this.requirement;
    }

    public void setRequirement(@NotNull RRequirement requirement) {
        this.requirement = requirement;
    }

    @NotNull
    public IconSection getIcon() {
        return this.icon;
    }

    public void setIcon(@NotNull IconSection icon) {
        this.icon = icon;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isMet(@NotNull Player player) {
        return this.requirement.isMet(player);
    }

    public double calculateProgress(@NotNull Player player) {
        return this.requirement.calculateProgress(player);
    }

    public void consume(@NotNull Player player) {
        this.requirement.consume(player);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RRankUpgradeRequirement)) {
            return false;
        }
        RRankUpgradeRequirement that = (RRankUpgradeRequirement)o;
        if (this.getId() != null && that.getId() != null) {
            return this.getId().equals(that.getId());
        }
        if (this.requirement != null && that.requirement != null && this.rank != null && that.rank != null) {
            return this.requirement.equals(that.requirement) && this.rank.equals(that.rank) && this.displayOrder == that.displayOrder;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        if (this.requirement != null && this.rank != null) {
            return Objects.hash(this.requirement, this.rank, this.displayOrder);
        }
        return System.identityHashCode(this);
    }

    public void setRank(@Nullable RRank rank) {
        if (this.rank != null && this.rank != rank) {
            this.rank.getUpgradeRequirements().remove(this);
        }
        this.rank = rank;
        if (rank != null && !rank.getUpgradeRequirements().contains(this)) {
            rank.getUpgradeRequirements().add(this);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }
}

