/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.IconSectionConverter;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.Hibernate;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_rank_tree")
public class RRankTree
extends BaseEntity {
    @Column(name="identifier", unique=true, nullable=false)
    private String identifier;
    @Column(name="display_name_key", nullable=false, unique=true)
    private String displayNameKey;
    @Column(name="description_key", nullable=false)
    private String descriptionKey;
    @Column(name="display_order", nullable=false)
    private int displayOrder;
    @Column(name="minimum_rank_trees_to_be_done", nullable=false)
    private int minimumRankTreesToBeDone;
    @Column(name="is_enabled", nullable=false)
    private boolean isEnabled;
    @Column(name="is_final_rank_tree", nullable=false)
    private boolean isFinalRankTree;
    @Column(name="icon", nullable=false, columnDefinition="LONGTEXT")
    @Convert(converter=IconSectionConverter.class)
    private IconSection icon;
    @OneToMany(mappedBy="rankTree", cascade={CascadeType.PERSIST, CascadeType.MERGE}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<RRank> ranks = new ArrayList<RRank>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="r_rank_tree_prerequisites", joinColumns={@JoinColumn(name="rank_tree_id")}, inverseJoinColumns={@JoinColumn(name="prerequisite_rank_tree_id")})
    private List<RRankTree> prerequisiteRankTrees = new ArrayList<RRankTree>();
    @ManyToMany(mappedBy="prerequisiteRankTrees", fetch=FetchType.LAZY)
    private List<RRankTree> unlockedRankTrees = new ArrayList<RRankTree>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="r_rank_tree_connection", joinColumns={@JoinColumn(name="from_rank_tree_id")}, inverseJoinColumns={@JoinColumn(name="to_rank_tree_id")})
    private List<RRankTree> connectedRankTrees = new ArrayList<RRankTree>();
    @Version
    @Column(name="version")
    private int version;

    protected RRankTree() {
    }

    public RRankTree(@NotNull String identifier, @NotNull String displayNameKey, @NotNull String descriptionKey, @NotNull IconSection icon, int displayOrder, int minimumRankTreesToBeDone, boolean isEnabled, boolean isFinalRankTree) {
        this.identifier = identifier;
        this.displayNameKey = displayNameKey;
        this.descriptionKey = descriptionKey;
        this.icon = icon;
        this.displayOrder = displayOrder;
        this.minimumRankTreesToBeDone = minimumRankTreesToBeDone;
        this.isEnabled = isEnabled;
        this.isFinalRankTree = isFinalRankTree;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getMinimumRankTreesToBeDone() {
        return this.minimumRankTreesToBeDone;
    }

    public void setMinimumRankTreesToBeDone(int minimumRankTreesToBeDone) {
        this.minimumRankTreesToBeDone = minimumRankTreesToBeDone;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isFinalRankTree() {
        return this.isFinalRankTree;
    }

    public void setFinalRankTree(boolean finalRankTree) {
        this.isFinalRankTree = finalRankTree;
    }

    public IconSection getIcon() {
        return this.icon;
    }

    public List<RRank> getRanks() {
        return this.ranks;
    }

    public void setRanks(List<RRank> ranks) {
        if (Hibernate.isInitialized(this.ranks)) {
            if (!Objects.equals(this.ranks, ranks)) {
                this.ranks.clear();
                if (ranks != null) {
                    this.ranks.addAll(ranks);
                }
            }
        } else {
            this.ranks = ranks != null ? new ArrayList<RRank>(ranks) : new ArrayList();
        }
    }

    public List<RRankTree> getPrerequisiteRankTrees() {
        return this.prerequisiteRankTrees;
    }

    public void setPrerequisiteRankTrees(List<RRankTree> prerequisiteRankTrees) {
        if (Hibernate.isInitialized(this.prerequisiteRankTrees)) {
            if (!Objects.equals(this.prerequisiteRankTrees, prerequisiteRankTrees)) {
                this.prerequisiteRankTrees.clear();
                if (prerequisiteRankTrees != null) {
                    this.prerequisiteRankTrees.addAll(prerequisiteRankTrees);
                }
            }
        } else {
            this.prerequisiteRankTrees = prerequisiteRankTrees != null ? new ArrayList<RRankTree>(prerequisiteRankTrees) : new ArrayList();
        }
    }

    public List<RRankTree> getUnlockedRankTrees() {
        return this.unlockedRankTrees;
    }

    public void setUnlockedRankTrees(List<RRankTree> unlockedRankTrees) {
        if (Hibernate.isInitialized(this.unlockedRankTrees)) {
            if (!Objects.equals(this.unlockedRankTrees, unlockedRankTrees)) {
                this.unlockedRankTrees.clear();
                if (unlockedRankTrees != null) {
                    this.unlockedRankTrees.addAll(unlockedRankTrees);
                }
            }
        } else {
            this.unlockedRankTrees = unlockedRankTrees != null ? new ArrayList<RRankTree>(unlockedRankTrees) : new ArrayList();
        }
    }

    public List<RRankTree> getConnectedRankTrees() {
        return this.connectedRankTrees;
    }

    public void setConnectedRankTrees(List<RRankTree> connectedRankTrees) {
        if (Hibernate.isInitialized(this.connectedRankTrees)) {
            if (!Objects.equals(this.connectedRankTrees, connectedRankTrees)) {
                this.connectedRankTrees.clear();
                if (connectedRankTrees != null) {
                    this.connectedRankTrees.addAll(connectedRankTrees);
                }
            }
        } else {
            this.connectedRankTrees = connectedRankTrees != null ? new ArrayList<RRankTree>(connectedRankTrees) : new ArrayList();
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RRankTree)) {
            return false;
        }
        RRankTree that = (RRankTree)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

