/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.config.utility.IconSection;
import com.raindropcentral.rdq.database.converter.IconSectionConverter;
import com.raindropcentral.rdq.database.entity.rank.RRankTree;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="r_rank")
public class RRank
extends BaseEntity {
    @Transient
    private static final Logger LOGGER = Logger.getLogger(RRank.class.getName());
    @Column(name="identifier", nullable=false, unique=true)
    private String identifier;
    @Column(name="display_name_key", nullable=false, unique=true)
    private String displayNameKey;
    @Column(name="description_key", nullable=false)
    private String descriptionKey;
    @Column(name="assigned_luckperms_group", nullable=false)
    private String assignedLuckPermsGroup;
    @Column(name="prefix_key", nullable=false)
    private String prefixKey;
    @Column(name="suffix_key", nullable=false)
    private String suffixKey;
    @Column(name="tier", nullable=false)
    private int tier;
    @Column(name="weight", nullable=false)
    private int weight;
    @Column(name="is_initial_rank")
    private boolean isInitialRank;
    @Column(name="is_final_rank")
    private boolean isFinalRank;
    @Column(name="is_enabled")
    private boolean isEnabled;
    @Column(name="icon", nullable=false, columnDefinition="LONGTEXT")
    @Convert(converter=IconSectionConverter.class)
    private IconSection icon;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="r_rank_previous_ranks", joinColumns={@JoinColumn(name="rank_id")})
    @Column(name="previous_rank_identifier")
    private List<String> previousRanks = new ArrayList<String>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="r_rank_next_ranks", joinColumns={@JoinColumn(name="rank_id")})
    @Column(name="next_rank_identifier")
    private List<String> nextRanks = new ArrayList<String>();
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="rank_tree_id", nullable=true)
    private RRankTree rankTree;
    @OneToMany(mappedBy="rank", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<RRankUpgradeRequirement> upgradeRequirements = new HashSet<RRankUpgradeRequirement>();
    @Version
    @Column(name="version")
    private int version;

    protected RRank() {
    }

    public RRank(@NotNull String identifier, @NotNull String displayNameKey, @NotNull String descriptionKey, @NotNull String assignedLuckPermsGroup, @NotNull String prefixKey, @NotNull String suffixKey, @NotNull IconSection icon, boolean isInitialRank, int tier, int weight, @Nullable RRankTree rankTree) {
        this.identifier = identifier;
        this.displayNameKey = displayNameKey;
        this.descriptionKey = descriptionKey;
        this.assignedLuckPermsGroup = assignedLuckPermsGroup;
        this.prefixKey = prefixKey;
        this.suffixKey = suffixKey;
        this.icon = icon;
        this.isInitialRank = isInitialRank;
        this.tier = tier;
        this.weight = weight;
        this.rankTree = rankTree;
    }

    public RRank(@NotNull String identifier, @NotNull String displayNameKey, @NotNull String descriptionKey, @NotNull String assignedLuckPermsGroup, @NotNull String prefixKey, @NotNull String suffixKey, @NotNull IconSection icon, boolean isInitialRank, int tier, int weight) {
        this(identifier, displayNameKey, descriptionKey, assignedLuckPermsGroup, prefixKey, suffixKey, icon, isInitialRank, tier, weight, null);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getAssignedLuckPermsGroup() {
        return this.assignedLuckPermsGroup;
    }

    public String getPrefixKey() {
        return this.prefixKey;
    }

    public String getSuffixKey() {
        return this.suffixKey;
    }

    public int getTier() {
        return this.tier;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isInitialRank() {
        return this.isInitialRank;
    }

    public boolean isFinalRank() {
        return this.isFinalRank;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public RRankTree getRankTree() {
        return this.rankTree;
    }

    @NotNull
    public Set<RRankUpgradeRequirement> getUpgradeRequirements() {
        return this.upgradeRequirements;
    }

    @NotNull
    public List<RRankUpgradeRequirement> getUpgradeRequirementsOrdered() {
        return this.upgradeRequirements.stream().sorted((r1, r2) -> Integer.compare(r1.getDisplayOrder(), r2.getDisplayOrder())).collect(Collectors.toList());
    }

    public IconSection getIcon() {
        return this.icon;
    }

    public List<String> getPreviousRanks() {
        return this.previousRanks;
    }

    public List<String> getNextRanks() {
        return this.nextRanks;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setRankTree(@Nullable RRankTree rankTree) {
        this.rankTree = rankTree;
    }

    public void setPreviousRanks(List<String> previousRanks) {
        this.previousRanks = previousRanks;
    }

    public void setNextRanks(List<String> nextRanks) {
        this.nextRanks = nextRanks;
    }

    public boolean addUpgradeRequirement(@NotNull RRankUpgradeRequirement upgradeRequirement) {
        if (this.upgradeRequirements.contains(upgradeRequirement)) {
            LOGGER.log(Level.FINE, "Upgrade requirement already exists for rank: " + this.identifier);
            return false;
        }
        boolean added = this.upgradeRequirements.add(upgradeRequirement);
        if (added) {
            if (upgradeRequirement.getRank() != this) {
                upgradeRequirement.setRank(this);
            }
            LOGGER.log(Level.FINE, "Added upgrade requirement to rank: " + this.identifier + ". Total requirements: " + this.upgradeRequirements.size());
        }
        return added;
    }

    public boolean removeUpgradeRequirement(@NotNull RRankUpgradeRequirement upgradeRequirement) {
        boolean removed = this.upgradeRequirements.remove(upgradeRequirement);
        if (removed) {
            if (upgradeRequirement.getRank() == this) {
                upgradeRequirement.setRank(null);
            }
            LOGGER.log(Level.FINE, "Removed upgrade requirement from rank: " + this.identifier + ". Remaining requirements: " + this.upgradeRequirements.size());
        }
        return removed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RRank)) {
            return false;
        }
        RRank rRank = (RRank)o;
        return this.identifier.equals(rRank.identifier);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }
}

