/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rdq.database.entity.rank;

import com.raindropcentral.rdq.database.entity.player.RDQPlayer;
import com.raindropcentral.rdq.database.entity.rank.RRank;
import com.raindropcentral.rdq.database.entity.rank.RRankUpgradeRequirement;
import de.jexcellence.hibernate.entity.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="r_player_rank_upgrade_progress", uniqueConstraints={@UniqueConstraint(columnNames={"player_id", "upgrade_requirement_id"})})
public class RPlayerRankUpgradeProgress
extends BaseEntity {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="player_id", nullable=false)
    private RDQPlayer player;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="upgrade_requirement_id", nullable=false)
    private RRankUpgradeRequirement upgradeRequirement;
    @Column(name="progress_value", nullable=false)
    private double progress;

    protected RPlayerRankUpgradeProgress() {
    }

    public RPlayerRankUpgradeProgress(@NotNull RDQPlayer player, @NotNull RRankUpgradeRequirement upgradeRequirement) {
        this.player = player;
        this.upgradeRequirement = upgradeRequirement;
        this.progress = 0.0;
    }

    @NotNull
    public RDQPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(@NotNull RDQPlayer player) {
        this.player = player;
    }

    @NotNull
    public RRankUpgradeRequirement getUpgradeRequirement() {
        return this.upgradeRequirement;
    }

    public void setUpgradeRequirement(@NotNull RRankUpgradeRequirement upgradeRequirement) {
        this.upgradeRequirement = upgradeRequirement;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = Math.min(progress, 1.0);
    }

    public double incrementProgress(double amount) {
        this.setProgress(this.progress + amount);
        return this.progress;
    }

    public void resetProgress() {
        this.progress = 0.0;
    }

    public boolean isCompleted() {
        return this.progress >= 1.0;
    }

    @NotNull
    public RRank getTargetRank() {
        return this.upgradeRequirement.getRank();
    }
}

